/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.interfaces.KCDSAParams;
import com.initech.provider.crypto.interfaces.KCDSAPublicKey;
import com.initech.provider.crypto.spec.KCDSAParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;

public final class KCDSAPublicKeyImpl
implements Zeroizable,
KCDSAPublicKey {
    private static final long serialVersionUID = 7622069011006330295L;
    private BigInteger Y;
    private KCDSAParameterSpec spec;
    private PublicKeyInfo kinfo;
    private boolean modified = false;

    public KCDSAPublicKeyImpl() {
        this.kinfo = new PublicKeyInfo();
    }

    public KCDSAPublicKeyImpl(BigInteger Y, BigInteger P, BigInteger Q, BigInteger G) throws InvalidKeyException {
        this.Y = Y;
        this.spec = new KCDSAParameterSpec(P, Q, G);
        this.kinfo = new PublicKeyInfo();
        this.modified = true;
    }

    public KCDSAPublicKeyImpl(byte[] pubkey) throws InvalidKeyException {
        try {
            this.kinfo = new PublicKeyInfo(pubkey);
            String keyAlg = this.kinfo.getAlg();
            if (!keyAlg.equals("1.2.410.200004.1.21")) {
                throw new InvalidKeyException("this algorithm is not KCDSA");
            }
            String alg = OIDDictionary.getNamebyOID(keyAlg);
            AlgorithmParameters ap = AlgorithmParameters.getInstance(alg, InitechProvider.NAME);
            ap.init(this.kinfo.getAlgParameter());
            this.spec = ap.getParameterSpec(KCDSAParameterSpec.class);
            DERDecoder dec = new DERDecoder(this.kinfo.getPublicKeyAsByteArray());
            this.Y = dec.decodeInteger();
            this.modified = true;
        }
        catch (Exception ex) {
            throw new InvalidKeyException(ex.getMessage());
        }
    }

    public KCDSAParams getParams() {
        return this.spec;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public String getAlgorithm() {
        return "KCDSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.kinfo.getEncoded();
            }
            AlgorithmParameters param = AlgorithmParameters.getInstance("KCDSA", InitechProvider.NAME);
            param.init(this.spec);
            this.kinfo.setAlgName("1.2.410.200004.1.21");
            this.kinfo.setAlgParameter(param.getEncoded());
            DEREncoder enc = new DEREncoder();
            enc.encodeInteger(this.Y);
            byte[] key = enc.toByteArray();
            this.kinfo.setPublicKey(key);
            byte[] ret = this.kinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void zeroize() {
        if (this.Y != null) {
            this.Y = BigInteger.ZERO;
        }
        this.modified = true;
    }
}

