/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.SelfTestCase;
import com.initech.provider.crypto.kcdsa.KCDSAPrivateKeyImpl;
import com.initech.provider.crypto.kcdsa.KCDSAPublicKeyImpl;
import com.initech.provider.crypto.kcdsa.SHA224withKCDSA;
import com.initech.provider.crypto.kcdsa.SHA256withKCDSA;
import java.math.BigInteger;

public class KCDSASelfTestCase
implements SelfTestCase {
    static BigInteger P = new BigInteger("C7DB223C7AD306AF783C8D24393CF0253FAA2ABA743DFCA57049080387265238145845E35718E7C1DB2495BAB781E234554F8A899BF667C280F0A39A9E045D2641A28B43153C0C53CB1953A7F2FAA01471F30BF902FC410175EDFDE8AC9561F51AD9B0CE2ACE84D192FFE93AE38D884901747AF032BC1D8FD45A9982E9AD792A6AC904966BEC09F0AC0BC3F56AF70DC733C18979E74200C55C4423DBF043E76BE8EC17B1B2F10CFC05E74F3E73DE26213DA011850ACC174716476FE1C8722840A5DCFEE5825E90C3CADEA9B0EE95C6F496F6FE4DAECC02CC9C437651E7A43F08FFE4E4C722B79A78DE6434E7DCA2F8573D4142C0D6E9448A5EE90130BD9D7E7F", 16);
    static BigInteger Q = new BigInteger("B865081F93D1DA350C6EE0E4912A40A27078B2F29283D89F5DA85889", 16);
    static BigInteger G = new BigInteger("7E80D4C533C3EC6A2EDF752F481B7BCB3243A507DAE8D6EA62C4F5FC5786C0C76DF0553C908398A84C13E9B05F9C3F120CA806832B8E49C033B9FA1F9BB5B235058410506DCE1CD70104B4D6C2F2B452CFCB47318DB03AACAC447B3D040988D2DA7A7D8C66D84E473C32DBE6840033BB6312F520A36CC37BB0B70F4AAB1C02647311BE836084C3637D992F05525573B6D8030117E3AF279ACCDD28C9A0A2A6874C2BBCCDE42034B633B30A57E3BCFA4037AA92013E596B28A0839C766433691CCC83B048E6573BC2B5941AB1A1E544310D3EE36DD1C86D376F30C50DC0E1CA2BAE71E32836AC4C0956F1E36C8D4FAE75F4C96AA4938965FCEBA3D1BC152F8D9B", 16);
    static BigInteger X = new BigInteger("8F9B3C38B86AE1092E332241737EDF00341DFC4AC032AD4EFAE54F41", 16);
    static BigInteger Y = new BigInteger("36FB519BB1B76B99AE5182A05E40631728179C5C47814EEE94C001B62ACB5E1A80E5C409D64749D1A12312317E2EC3201826BD991838045E6AEE8EC6CABCF1450BA5975A74EE4FCAF92E105C1E09007DE29C034A4A7D9B1E79760B3D73B417C1F315229294E96B00DB85CD23A059EAC334200DD73C99A3B52B8F6F6E298B0C500B30D6995CF4EB1FE860658DB82BD2ED13A29AF00CB8671E7403F50C6D5B06200A4173D2AD38DEF7C808D4CA8861B331FED444D4F7B961E7C0212E13ABB6407B0FB4C131751C422C9797CB3EA591A81CE53FBF4E9CA364E3F24A658F90C6A78BF37F343D3426DF1C33BDCC9AF10C52D59F5384010B5AD05EE11B97E2D194F740", 16);
    static byte[] input = Hex.parseHexaString("87EBDDBD2F3DEA78962459713F12768542F47A3AF6B3A4BC3DA3BB818E96F69503D4D33212BEAA2962841A219690A7D905A193FBD43839125C74136A0B89010E5ED4C0EF136B98F46FB21607C2BD60C75FF34434AB7DC508F158F27CE1F30BBF48CB305BB6C8CF27FBE5AD3E240E0703814BB72D487DB5B956A836381CC07864");

    void testSHA224KCDSA() throws KSXRuntimeException {
        BigInteger P = new BigInteger("C7DB223C7AD306AF783C8D24393CF0253FAA2ABA743DFCA57049080387265238145845E35718E7C1DB2495BAB781E234554F8A899BF667C280F0A39A9E045D2641A28B43153C0C53CB1953A7F2FAA01471F30BF902FC410175EDFDE8AC9561F51AD9B0CE2ACE84D192FFE93AE38D884901747AF032BC1D8FD45A9982E9AD792A6AC904966BEC09F0AC0BC3F56AF70DC733C18979E74200C55C4423DBF043E76BE8EC17B1B2F10CFC05E74F3E73DE26213DA011850ACC174716476FE1C8722840A5DCFEE5825E90C3CADEA9B0EE95C6F496F6FE4DAECC02CC9C437651E7A43F08FFE4E4C722B79A78DE6434E7DCA2F8573D4142C0D6E9448A5EE90130BD9D7E7F", 16);
        BigInteger Q = new BigInteger("B865081F93D1DA350C6EE0E4912A40A27078B2F29283D89F5DA85889", 16);
        BigInteger G = new BigInteger("7E80D4C533C3EC6A2EDF752F481B7BCB3243A507DAE8D6EA62C4F5FC5786C0C76DF0553C908398A84C13E9B05F9C3F120CA806832B8E49C033B9FA1F9BB5B235058410506DCE1CD70104B4D6C2F2B452CFCB47318DB03AACAC447B3D040988D2DA7A7D8C66D84E473C32DBE6840033BB6312F520A36CC37BB0B70F4AAB1C02647311BE836084C3637D992F05525573B6D8030117E3AF279ACCDD28C9A0A2A6874C2BBCCDE42034B633B30A57E3BCFA4037AA92013E596B28A0839C766433691CCC83B048E6573BC2B5941AB1A1E544310D3EE36DD1C86D376F30C50DC0E1CA2BAE71E32836AC4C0956F1E36C8D4FAE75F4C96AA4938965FCEBA3D1BC152F8D9B", 16);
        BigInteger X = new BigInteger("8F9B3C38B86AE1092E332241737EDF00341DFC4AC032AD4EFAE54F41", 16);
        BigInteger Y = new BigInteger("36FB519BB1B76B99AE5182A05E40631728179C5C47814EEE94C001B62ACB5E1A80E5C409D64749D1A12312317E2EC3201826BD991838045E6AEE8EC6CABCF1450BA5975A74EE4FCAF92E105C1E09007DE29C034A4A7D9B1E79760B3D73B417C1F315229294E96B00DB85CD23A059EAC334200DD73C99A3B52B8F6F6E298B0C500B30D6995CF4EB1FE860658DB82BD2ED13A29AF00CB8671E7403F50C6D5B06200A4173D2AD38DEF7C808D4CA8861B331FED444D4F7B961E7C0212E13ABB6407B0FB4C131751C422C9797CB3EA591A81CE53FBF4E9CA364E3F24A658F90C6A78BF37F343D3426DF1C33BDCC9AF10C52D59F5384010B5AD05EE11B97E2D194F740", 16);
        byte[] input = Hex.parseHexaString("87EBDDBD2F3DEA78962459713F12768542F47A3AF6B3A4BC3DA3BB818E96F69503D4D33212BEAA2962841A219690A7D905A193FBD43839125C74136A0B89010E5ED4C0EF136B98F46FB21607C2BD60C75FF34434AB7DC508F158F27CE1F30BBF48CB305BB6C8CF27FBE5AD3E240E0703814BB72D487DB5B956A836381CC07864");
        try {
            KCDSAPublicKeyImpl publicKey = new KCDSAPublicKeyImpl(Y, P, Q, G);
            KCDSAPrivateKeyImpl privateKey = new KCDSAPrivateKeyImpl(X, Y, P, Q, G);
            SHA224withKCDSA sha224kcdsa = new SHA224withKCDSA();
            sha224kcdsa._engineInitSign(privateKey);
            sha224kcdsa._engineUpdate(input, 0, input.length);
            byte[] signedtext = sha224kcdsa._engineSign();
            sha224kcdsa._engineInitVerify(publicKey);
            sha224kcdsa._engineUpdate(input, 0, input.length);
            if (!sha224kcdsa._engineVerify(signedtext)) {
                throw new KSXRuntimeException("SHA224KCDSA SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("SHA224KCDSA SelfTest Error", e);
        }
    }

    void testSHA256KCDSA() throws KSXRuntimeException {
        BigInteger P = new BigInteger("B89C6044ADAEE2F60D88CDDF9291907B403DAD176E4DCD560B631766FE904DE65E30DDC7FB7970A1E68CAB85E48ECCDF175223FD9C622CC1CF3122BC11ABAE5C13C6D7C636BF6241D0DC8173F50701AA7947A12D6FA16A523CA90E5677453E1EE01B3609F5736C96E990941647373A3F1947EAB78A08067BC373934B2AD1C1BC1C0F2F8BF40F940C21E074C5EDC7DD06D0C59FE9BC47EA23DE69A5CA920698801B21AC48EB06C8FFAE92560DFBFA7D9C0071246ECDB49F1FE2004E0CB8EEDA32FBC6D2F6DAAFB99E8C35F96F7AC3AE895FD609689D1748D21251919732B7F642DF166D8CA3B28F7878CE3B8B0FED85101F679A4181B4B1A41B0014E6F6C879DB", 16);
        BigInteger Q = new BigInteger("B47B3F034E9D939BA80A285056132DAD7772132A06A2D9B4288C23B233B81B03", 16);
        BigInteger G = new BigInteger("57B2B90399B81E079CF67C07468832E4D88812C9BC1D14CA1C9114DFDE4497C89508C9D9F6210F7CF5914E05372EBE819577C305005CD4A2296048472F4301D361F41861B79034A04A3ABF0131CDECC9AF9659C25E6CE00573E614D68D12ACDB80B4C74109F3B8D7189F159E00F4FABC88BF2E982CDB708B071AB0B23D0E2FFF0CCE858392D1D979295CDB862436E5521FC0C214B0377681F62DC4A4862CF3B78729E93E3E17C27F3156A7DE1A41D3755E4D4BE2BBA49CA8B9381432BC2B5DDFEDF52F65571D97B569F459FE5E2D48F1399F2E004FA9E15DEC98501778F06592A5F17226015FB98C96FDFED6F26F368DCE99D0B994960CF2F05C55B9FCB02998", 16);
        BigInteger X = new BigInteger("3B9EF898234A0F78015E83F7F102BEB41A38DDCB5265DFD77888FB070DECC18B", 16);
        BigInteger Y = new BigInteger("2203EA8B1EF6836232113817F488DF3164DBBBB33E2348A37C6A2C7CE948D6DB96769BF931BE6C5C641161D34A18DCF44001D3C39334ED6E5653646BF8B7C351F1C1DEDFE68DEE2E5CF3595995A76045E1BA9B0A308519154846526192407F5CC54E3A95241E75A7E7AA9C115D9D30CF4087EBFE965605F3AAC442BCF9BBC45CB1BF64E3EA0786E36720FB4EA106A070537E5D3198727AED411671E97C334C5CEE5A5F302E18BDF161AF606D4687F633BA27D470D06F15B40215157C354622B1747389ACDAAD03F235190D95C6C3870262456267FEAB9735078347930F3DA97A922E5ABA7EBBB103F0E0A702A83D7BC0CB970B7F442E415A1F140197B7CD504F", 16);
        byte[] input = Hex.parseHexaString("6938C574EA33129A4DBE75D682349A7FBF08F89AD0E4B592FC43B2E66248AECB00F3BF6AA6D106F4917BCB932F6614EE6E8C09BE71BF516E0383D5654B04314B77F1B51E433B92D4B7DDE866C3FC5632895F70FA9E41E8A2443E088FC1B95AB82B9057EDCBE94303482C6A0C2940BE321F2FACBE711561B5D3E8C5952220CECC");
        try {
            KCDSAPublicKeyImpl publicKey = new KCDSAPublicKeyImpl(Y, P, Q, G);
            KCDSAPrivateKeyImpl privateKey = new KCDSAPrivateKeyImpl(X, Y, P, Q, G);
            SHA256withKCDSA sha256kcdsa = new SHA256withKCDSA();
            sha256kcdsa._engineInitSign(privateKey);
            sha256kcdsa._engineUpdate(input, 0, input.length);
            byte[] signedtext = sha256kcdsa._engineSign();
            sha256kcdsa._engineInitVerify(publicKey);
            sha256kcdsa._engineUpdate(input, 0, input.length);
            if (!sha256kcdsa._engineVerify(signedtext)) {
                throw new KSXRuntimeException("SHA256KCDSA SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("SHA256KCDSA SelfTest Error", e);
        }
    }

    public void selfTest() {
        this.testSHA224KCDSA();
        this.testSHA256KCDSA();
    }
}

