/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import java.math.BigInteger;

public class KCDSASignedData
extends ASN1Object {
    private static final long serialVersionUID = 7120337641404183654L;
    private ASN1BitString R = new ASN1BitString();
    private BigInteger S;

    public KCDSASignedData(byte[] r, BigInteger s) {
        this.R.setByteArray(r);
        this.R.setUnusedBits(0);
        this.S = s;
    }

    public KCDSASignedData(byte[] byteArray) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(byteArray);
        this.decode(dec);
        this.encoded = (byte[])byteArray.clone();
        this.modified = false;
    }

    public byte[] getR() {
        return this.R.getAsByteArray();
    }

    public BigInteger getS() {
        return this.S;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.R = dec.decodeBitString();
        this.S = dec.decodeInteger();
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeBitString(this.R);
        enc.encodeInteger(this.S);
        enc.endOf(id);
    }
}

