/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import java.security.DigestException;
import java.security.MessageDigest;

public class KCDSAUtility {
    static final byte[] MASK = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};

    public static void PRNG(byte[] s, byte[] buf, int bits, MessageDigest md) throws DigestException {
        int mdLen = md.getDigestLength();
        byte[] tblk = new byte[mdLen];
        int k = bits / (mdLen * 8);
        int r = bits % (mdLen * 8);
        int lastBytes = r % 8 != 0 ? r / 8 + 1 : r / 8;
        for (int i = 0; i < k; ++i) {
            md.update(s);
            md.update((byte)i);
            md.digest(buf, buf.length - mdLen * (i + 1), mdLen);
        }
        md.update(s);
        md.update((byte)k);
        md.digest(tblk, 0, mdLen);
        System.arraycopy(tblk, mdLen - lastBytes, buf, 0, lastBytes);
        buf[0] = (byte)(buf[0] & MASK[r % 8]);
    }
}

