/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.mac;

import com.initech.cryptox.MacSpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.mac.HMACKey;
import com.initech.provider.crypto.md.HAS160;
import com.initech.provider.crypto.md.LSH256_224;
import com.initech.provider.crypto.md.LSH256_256;
import com.initech.provider.crypto.md.LSH512_224;
import com.initech.provider.crypto.md.LSH512_256;
import com.initech.provider.crypto.md.LSH512_384;
import com.initech.provider.crypto.md.LSH512_512;
import com.initech.provider.crypto.md.MD5;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA3_224;
import com.initech.provider.crypto.md.SHA3_256;
import com.initech.provider.crypto.md.SHA3_384;
import com.initech.provider.crypto.md.SHA3_512;
import com.initech.provider.crypto.md.SHA512;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class HMAC
extends MacSpi {
    public static String algorithm = "SHA";
    private byte[] ipad;
    private byte[] opad;
    private byte[] buffer;
    private MessageDigest mdi;
    private MessageDigest mdo;
    private int hashBlockSize;
    private boolean isInit = false;

    public HMAC(String alg) {
        algorithm = alg;
        try {
            this.maksMD();
        }
        catch (Exception e) {
            try {
                this.mdi = MessageDigest.getInstance(alg, InitechProvider.NAME);
                this.mdo = MessageDigest.getInstance(alg, InitechProvider.NAME);
            }
            catch (Exception ex) {
                throw new RuntimeException(algorithm + " is not installed");
            }
        }
        if (this.hashBlockSize <= 0 || this.mdo == null) {
            throw new RuntimeException(algorithm + " is not supported");
        }
        this.ipad = new byte[this.hashBlockSize];
        this.opad = new byte[this.hashBlockSize];
        this.buffer = new byte[this.mdo.getDigestLength()];
    }

    public String getAlgorithm() {
        return algorithm;
    }

    protected int _engineGetMacLength() {
        return this.mdo.getDigestLength();
    }

    protected void _engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._engineReset();
        if (key == null) {
            throw new InvalidKeyException("hmac key is null");
        }
        if (!(key instanceof HMACKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not hmac key");
        }
        this.setKey(key.getEncoded());
        this.isInit = true;
    }

    private void maksMD() {
        if (algorithm.equalsIgnoreCase("SHA1")) {
            this.mdi = new SHA1();
            this.mdo = new SHA1();
            this.hashBlockSize = 64;
        } else if (algorithm.equalsIgnoreCase("SHA224")) {
            this.mdi = new SHA224();
            this.mdo = new SHA224();
            this.hashBlockSize = 64;
        } else if (algorithm.equalsIgnoreCase("SHA256")) {
            this.mdi = new SHA256();
            this.mdo = new SHA256();
            this.hashBlockSize = 64;
        } else if (algorithm.equalsIgnoreCase("SHA384")) {
            this.mdi = new SHA384();
            this.mdo = new SHA384();
            this.hashBlockSize = 128;
        } else if (algorithm.equalsIgnoreCase("SHA512")) {
            this.mdi = new SHA512();
            this.mdo = new SHA512();
            this.hashBlockSize = 128;
        } else if (algorithm.equalsIgnoreCase("SHA3-224")) {
            this.mdi = new SHA3_224();
            this.mdo = new SHA3_224();
            this.hashBlockSize = 144;
        } else if (algorithm.equalsIgnoreCase("SHA3-256")) {
            this.mdi = new SHA3_256();
            this.mdo = new SHA3_256();
            this.hashBlockSize = 136;
        } else if (algorithm.equalsIgnoreCase("SHA3-384")) {
            this.mdi = new SHA3_384();
            this.mdo = new SHA3_384();
            this.hashBlockSize = 104;
        } else if (algorithm.equalsIgnoreCase("SHA3-512")) {
            this.mdi = new SHA3_512();
            this.mdo = new SHA3_512();
            this.hashBlockSize = 72;
        } else if (algorithm.equalsIgnoreCase("LSH256-224")) {
            this.mdi = new LSH256_224();
            this.mdo = new LSH256_224();
            this.hashBlockSize = 128;
        } else if (algorithm.equalsIgnoreCase("LSH256-256")) {
            this.mdi = new LSH256_256();
            this.mdo = new LSH256_256();
            this.hashBlockSize = 128;
        } else if (algorithm.equalsIgnoreCase("LSH512-224")) {
            this.mdi = new LSH512_224();
            this.mdo = new LSH512_224();
            this.hashBlockSize = 256;
        } else if (algorithm.equalsIgnoreCase("LSH512-256")) {
            this.mdi = new LSH512_256();
            this.mdo = new LSH512_256();
            this.hashBlockSize = 256;
        } else if (algorithm.equalsIgnoreCase("LSH512-384")) {
            this.mdi = new LSH512_384();
            this.mdo = new LSH512_384();
            this.hashBlockSize = 256;
        } else if (algorithm.equalsIgnoreCase("LSH512-512")) {
            this.mdi = new LSH512_512();
            this.mdo = new LSH512_512();
            this.hashBlockSize = 256;
        } else if (algorithm.equalsIgnoreCase("MD5")) {
            this.mdi = new MD5();
            this.mdo = new MD5();
            this.hashBlockSize = 64;
        } else if (algorithm.equalsIgnoreCase("HAS160")) {
            this.mdi = new HAS160();
            this.mdo = new HAS160();
            this.hashBlockSize = 64;
        } else {
            throw new RuntimeException(algorithm + " is not supported");
        }
    }

    private void setKey(byte[] key) {
        if (key.length > this.hashBlockSize) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm, InitechProvider.NAME);
                md.update(key);
                key = md.digest();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.arraycopy(key, 0, this.ipad, 0, key.length);
        System.arraycopy(key, 0, this.opad, 0, key.length);
        int i = 0;
        while (i < this.hashBlockSize) {
            int n = i;
            this.ipad[n] = (byte)(this.ipad[n] ^ 0x36);
            int n2 = i++;
            this.opad[n2] = (byte)(this.opad[n2] ^ 0x5C);
        }
        this.mdi.update(this.ipad);
        this.mdo.update(this.opad);
    }

    protected void _engineReset() {
        for (int i = 0; i < 64; ++i) {
            this.ipad[i] = 0;
            this.opad[i] = 0;
        }
        this.isInit = false;
        this.mdi.reset();
        this.mdo.reset();
        Arrays.fill(this.buffer, (byte)0);
    }

    protected void _engineUpdate(byte input) {
        if (!this.isInit) {
            throw new IllegalStateException("MAC not initialized.");
        }
        this.mdi.update(input);
    }

    protected void _engineUpdate(byte[] input, int offset, int len) {
        if (!this.isInit) {
            throw new IllegalStateException("MAC not initialized.");
        }
        this.mdi.update(input, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] _engineDoFinal() {
        if (!this.isInit) {
            throw new IllegalStateException("MAC not initialized.");
        }
        try {
            this.mdi.digest(this.buffer, 0, this.buffer.length);
            this.mdo.update(this.buffer);
            byte[] outterPadded = this.mdo.digest();
            this.mdi.update(this.ipad);
            this.mdo.update(this.opad);
            byte[] byArray = outterPadded;
            return byArray;
        }
        catch (Exception exception) {
        }
        finally {
            this._engineReset();
        }
        return null;
    }
}

