/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.mac;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.mac.HMACKey;
import com.initech.provider.crypto.spec.HMACKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class HMACKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof HMACKeySpec) {
            return new HMACKey(((HMACKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof SecretKeySpec) {
            return new HMACKey(((SecretKeySpec)keySpec).getEncoded());
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec s = (SecretKeySpec)AutoJCE.toJCEX((javax.crypto.spec.SecretKeySpec)keySpec);
            return new HMACKey(s.getEncoded());
        }
        throw new InvalidKeySpecException("unknown keySpec");
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof HMACKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "HMAC");
            }
            if (HMACKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new HMACKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("Only HMACKey can be translated.");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        return new HMACKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKeyX(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        return new HMACKey(key.getEncoded());
    }
}

