/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.mac;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.MacSpi;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.spec.MacParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

public class MAC
extends MacSpi {
    private String algorithm = "DES";
    private Cipher cip;
    private int macLength;
    private Key key;
    private byte[] temp = new byte[1];
    private byte[] buffer;
    private byte[] out;
    private int pos;
    private int blocksize;

    public MAC(String alg, int blocksize, int macLength) {
        try {
            this.algorithm = alg;
            this.cip = Cipher.getInstance(this.algorithm, InitechProvider.NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.blocksize = blocksize;
        this.macLength = macLength > blocksize ? blocksize : macLength;
    }

    public MAC(String alg, int blocksize) {
        this(alg, blocksize, blocksize);
    }

    protected int _engineGetMacLength() {
        return this.macLength;
    }

    protected void _engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int m;
        if (params instanceof MacParameterSpec && 0 < (m = ((MacParameterSpec)params).getMacLength()) && m <= this.blocksize) {
            this.macLength = m;
        }
        this.key = key;
        this.setKey(key);
        this.buffer = new byte[this.blocksize];
        this.out = new byte[this.blocksize];
    }

    private void setKey(Key key) {
        try {
            this.cip.init(1, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void _engineReset() {
        try {
            this.cip = Cipher.getInstance(this.algorithm, InitechProvider.NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setKey(this.key);
    }

    protected void _engineUpdate(byte input) {
        this.temp[0] = input;
        this.engineUpdate(this.temp, 0, 1);
    }

    protected void _engineUpdate(byte[] input, int offset, int len) {
        int q = len + this.pos;
        int len2 = 0;
        if (q < this.blocksize) {
            System.arraycopy(input, offset, this.buffer, this.pos, len);
            this.pos += len;
        } else {
            System.arraycopy(input, offset, this.buffer, this.pos, this.blocksize - this.pos);
            byte[] tt = this.inputXor(this.buffer);
            this.out = this.cip.update(tt, 0, this.blocksize);
            len2 = len - (this.blocksize - this.pos);
            this.pos = 0;
            if (len2 > 0) {
                this.engineUpdate(input, offset + (this.blocksize - this.pos), len2);
            }
        }
    }

    private byte[] inputXor(byte[] input) {
        byte[] aa = new byte[this.blocksize];
        for (int i = 0; i < this.blocksize; ++i) {
            aa[i] = (byte)(input[i] ^ this.out[i]);
        }
        return aa;
    }

    protected byte[] _engineDoFinal() {
        byte[] t = new byte[this.blocksize - this.pos];
        this.engineUpdate(t, 0, t.length);
        byte[] result = new byte[this.macLength];
        System.arraycopy(this.out, 0, result, 0, this.macLength);
        return result;
    }
}

