/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.mac;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.SelfTestCase;
import com.initech.provider.crypto.mac.HMAC;
import com.initech.provider.crypto.mac.HMACKey;
import com.initech.provider.crypto.mac.HMACwithLSH256_224;
import com.initech.provider.crypto.mac.HMACwithLSH256_256;
import com.initech.provider.crypto.mac.HMACwithLSH512_224;
import com.initech.provider.crypto.mac.HMACwithLSH512_256;
import com.initech.provider.crypto.mac.HMACwithLSH512_384;
import com.initech.provider.crypto.mac.HMACwithLSH512_512;
import com.initech.provider.crypto.mac.HMACwithSHA1;
import com.initech.provider.crypto.mac.HMACwithSHA224;
import com.initech.provider.crypto.mac.HMACwithSHA256;
import com.initech.provider.crypto.mac.HMACwithSHA384;
import com.initech.provider.crypto.mac.HMACwithSHA3_224;
import com.initech.provider.crypto.mac.HMACwithSHA3_256;
import com.initech.provider.crypto.mac.HMACwithSHA3_384;
import com.initech.provider.crypto.mac.HMACwithSHA3_512;
import com.initech.provider.crypto.mac.HMACwithSHA512;
import java.util.Arrays;

public class MACSelfTestCase
implements SelfTestCase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testHMAC(HMAC hmac, String sMsg, String sExpectMac, String sKey) throws Exception {
        byte[] msg = Hex.hexToByteArray(sMsg);
        byte[] expectMac = Hex.hexToByteArray(sExpectMac);
        HMACKey key = new HMACKey(Hex.hexToByteArray(sKey));
        byte[] mac = null;
        try {
            hmac._engineInit(key, null);
            hmac._engineUpdate(msg, 0, msg.length);
            mac = hmac._engineDoFinal();
            if (!Arrays.equals(expectMac, mac)) {
                throw new KSXRuntimeException("HMAC" + hmac.getAlgorithm() + " SelfTest Error");
            }
            if (mac == null) return;
        }
        catch (Exception e) {
            try {
                throw new KSXRuntimeException("HMAC" + hmac.getAlgorithm() + " SelfTest Error", e);
            }
            catch (Throwable throwable) {
                if (mac == null) throw throwable;
                Arrays.fill(mac, (byte)0);
                throw throwable;
            }
        }
        Arrays.fill(mac, (byte)0);
        return;
    }

    private void testHMACSHA1() throws Exception {
        String sMsg = "Hello World";
        String sExpectMac = "B0F72236447D4BEA2BE483EDE5C49779177B6A9E";
        String sKey = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F";
        this.testHMAC(new HMACwithSHA1(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA224() throws Exception {
        String sMsg = "48252c2e19f72e0733f49207e6003dd844b5f57178605d395a4c276f404485c91653e05bb1cecdbb60943d63c495f356e2913c077722da768bfd419c497506090e4194ccc07e219361f8e013e4a578aa3f72b643c1427e7ba6340802e92549435977ae47ef1010d65fa5e5e0ed38b31c82dfcbefffc8338fd17ae468c65d35bf";
        String sExpectMac = "3f403545f3140bfd6ae274f3bc5c5d5277808de62732ac0325a21af2";
        String sKey = "3d5479b91df3217ce89a52b3238ade3b";
        this.testHMAC(new HMACwithSHA224(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA256() throws Exception {
        String sMsg = "48252c2e19f72e0733f49207e6003dd844b5f57178605d395a4c276f404485c91653e05bb1cecdbb60943d63c495f356e2913c077722da768bfd419c497506090e4194ccc07e219361f8e013e4a578aa3f72b643c1427e7ba6340802e92549435977ae47ef1010d65fa5e5e0ed38b31c82dfcbefffc8338fd17ae468c65d35bf";
        String sExpectMac = "fad7554aa6f58bb0c728691cd6e7e58d3e53eab0fa8713d88e7cf0dc3add3841";
        String sKey = "3d5479b91df3217ce89a52b3238ade3b";
        this.testHMAC(new HMACwithSHA256(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA384() throws Exception {
        String sMsg = "1653e05bb1cecdbb60943d63c495f356e2913c077722da768bfd419c497506090e4194ccc07e219361f8e013e4a578aa3f72b643c1427e7ba6340802e92549435977ae47ef1010d65fa5e5e0ed38b31c82dfcbefffc8338fd17ae468c65d35bf1e7d9895e68b84ce8125b29288568cf4d461e3d1d8bae0fb34563d978824b4c4";
        String sExpectMac = "915620f25af9cab375ff96f0c5f520847c48877754b0549b969b3b4fa53843fc744728985fa7b0acd60e8e9a38efa5a3";
        String sKey = "3d5479b91df3217ce89a52b3238ade3b48252c2e19f72e0733f49207e6003dd844b5f57178605d395a4c276f404485c9";
        this.testHMAC(new HMACwithSHA384(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA512() throws Exception {
        String sMsg = "70bc5c21c81677301ce1ed7a18afbfaa97f0cb8e72ca9a7147a7ed6c93a9742d6106ef0ac12f41165ff3c78866d9cb6b7aeef351488dffa789452cb4040f9df248729b7d8b9cdb6ece5be1f9865ab6c842825aad5dff3f68cfd11c6692dcd4a4e617e82e938af7280a461c34e64077dbe1c7406fb6c513d8dabac4f499684605";
        String sExpectMac = "E99C6159DF0EE8C7A9338217FECF39D49648C08E31C7A70CEE044B704A8050B04D32681E94EF27F237EE901E1742F88C873B1A5D620E197258D4DE9953806EC1";
        String sKey = "c13fca14a58ca9eff849ce5ee367a692858d0ddd1542aec0c127ec22d68efb028d17ba72c32dcc3f00f6899e237ebaee111014d7fd6f207200922bec3bbbe4a1";
        this.testHMAC(new HMACwithSHA512(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA3_224() throws Exception {
        String sMsg = "68903177D905B867B5AB5EF5CC5E97925EB2B90C8C950F570D2F288C220D7532CC7F14BD3C3EE6548B52E7D7AB33BF219E2F948AE50B23B03CED0F78847A784F013BD0B6C545EAFD6C19544E0AC9E7EE625C9CC05974A20BAA2EAD7CDA4A906F6F8C0E6A5D61EDEAC1C64D63D166388213027AB5CE16B3EDBFBAAAA30CC6E419";
        String sExpectMac = "35989b43a21ad5919a4bc2a5b3efa6de89cb936888996f12d5e59d1c";
        String sKey = "B45239AF815A10A1850048B93C1E643D65C83D75B52C52B2CCBC5F8F";
        this.testHMAC(new HMACwithSHA3_224(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA3_256() throws Exception {
        String sMsg = "548A457280851ECA0F5476AFDAC102CF6C7DBE09B3083D74FBD03DA31E9D7F27F42CD656111A7D4BB005AD2EEAED6FB62CE0B0EBE7D6933189DA0B82AD6AA8FB8E21B19AC29374462579DA0F130E3EB8DAB87F726EEB54EB5F4AE087091087ED0BAFFFC6FAB7AAC156F823DBBCEB17DD5E4E5626B10F29AA656BE73B9A57C308";
        String sExpectMac = "5308a12f11c7a9bdf9c30baef0a7e5c516acd9070cc64efae9dee82991a52bc3";
        String sKey = "C6F1D667A50AAEBA5A200A0A7CC24FFBB24984426AB8ABACCEE75162F3E1646B";
        this.testHMAC(new HMACwithSHA3_256(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA3_384() throws Exception {
        String sMsg = "5D61EDEAC1C64D63D166388213027AB5CE16B3EDBFBAAAA30CC6E4197E3976E2EADC17A4F022791DE853DA641AE9D6712D3B7FE0E358AFF203369DD5960CAF2555FC8FB263F5818438D8F41CDDD956FD5F292D6B7ED26473A5E2E22B1FCB623B870A7E9C80070CA0A73CAE33C69AA5604B28E617F8EE702DDB11DCA4813F362D";
        String sExpectMac = "e26296d0c4df0df5d70b93ff67a8b33d8b2ead14153bb298cdc3959db6cde5e47598b9d989c9108dd47524b14f6d1f3f";
        String sKey = "E50B23B03CED0F78847A784F013BD0B6C545EAFD6C19544E0AC9E7EE625C9CC05974A20BAA2EAD7CDA4A906F6F8C0E6A";
        this.testHMAC(new HMACwithSHA3_384(), sMsg, sExpectMac, sKey);
    }

    private void testHMACSHA3_512() throws Exception {
        String sMsg = "5F292D6B7ED26473A5E2E22B1FCB623B870A7E9C80070CA0A73CAE33C69AA5604B28E617F8EE702DDB11DCA4813F362D674D0BEBB11FC37A1EC931303CF369A2D882D26AB9757C288E0CB3C72430D402DC0F5F265D074E1986C5A59BA6AE4BCCF07D18EE292E2F6DA41C8E1C7066E3C2D096A1D5EB855485C57932FD6E91F2E5";
        String sExpectMac = "b28dbce3e5d1731c82374ea4fcda06ad402fbeff821701d99563beae93ee15abf56759b7bf5c68daa51f541357a88d29c072465da4abe667fe79820a7994473a";
        String sKey = "CE16B3EDBFBAAAA30CC6E4197E3976E2EADC17A4F022791DE853DA641AE9D6712D3B7FE0E358AFF203369DD5960CAF2555FC8FB263F5818438D8F41CDDD956FD";
        this.testHMAC(new HMACwithSHA3_512(), sMsg, sExpectMac, sKey);
    }

    private void testHMACLSH256_224() throws Exception {
        String sMsg = "619F99FD88B8E59784A2C842C36442D15A112A90F7ECC48516CF91F678CE6B2CD117D176C21C7F7006F54184F0FF0AB215CA408D46325B86C1CBAE6DA7838435B1826FF81F55DD3AF24CEC725B2080C773D992172CEFCB3D88B0519409E1E1B768A81E8B8AAA2880AF707113ED0FCC98DD08C736946D3B33D44521718432A739";
        String sExpectMac = "0D0622A3540A452E3DCBDB386A861ADDD02E29315CC80EF9A9C923C5";
        String sKey = "8ADFE729028DD8A3EC07029DDAE7A81958D6DDB321F45226937B6C12";
        this.testHMAC(new HMACwithLSH256_224(), sMsg, sExpectMac, sKey);
    }

    private void testHMACLSH256_256() throws Exception {
        String sMsg = "8432A7395E518438E86288C7A52977708C1317ADB91D88F263F2D4EE0E53C70F01BC0144FB45490622C624993C3EA68F2176898F70E17C5482C7BDF89CA2EA7369C9155FA74B16FE201E257DDC79A87A957E49C56B1C4C63D9341FD9E8FA33A7A29F0B12CA2D9326CAB2B2FCEDA02239CE7480D711969F285080221758234AB2";
        String sExpectMac = "20B9616C87F97D02C1F145F9AB1C3C38D8ABD502CC7F0195BC98BDAEEE22AD95";
        String sKey = "09E1E1B768A81E8B8AAA2880AF707113ED0FCC98DD08C736946D3B33D4452171";
        this.testHMAC(new HMACwithLSH256_256(), sMsg, sExpectMac, sKey);
    }

    private void testHMACLSH512_224() throws Exception {
        String sMsg = "619F99FD88B8E59784A2C842C36442D15A112A90F7ECC48516CF91F678CE6B2CD117D176C21C7F7006F54184F0FF0AB215CA408D46325B86C1CBAE6DA7838435B1826FF81F55DD3AF24CEC725B2080C773D992172CEFCB3D88B0519409E1E1B768A81E8B8AAA2880AF707113ED0FCC98DD08C736946D3B33D44521718432A739";
        String sExpectMac = "40810D12180417C591DA22B5AD825471EB93E424954273F181013A08";
        String sKey = "8ADFE729028DD8A3EC07029DDAE7A81958D6DDB321F45226937B6C12";
        this.testHMAC(new HMACwithLSH512_224(), sMsg, sExpectMac, sKey);
    }

    private void testHMACLSH512_256() throws Exception {
        String sMsg = "8432A7395E518438E86288C7A52977708C1317ADB91D88F263F2D4EE0E53C70F01BC0144FB45490622C624993C3EA68F2176898F70E17C5482C7BDF89CA2EA7369C9155FA74B16FE201E257DDC79A87A957E49C56B1C4C63D9341FD9E8FA33A7A29F0B12CA2D9326CAB2B2FCEDA02239CE7480D711969F285080221758234AB2";
        String sExpectMac = "5DA0712F896D387FECC1A85C2D935AEE7A22563978751D73FFB54E28699D9787";
        String sKey = "09E1E1B768A81E8B8AAA2880AF707113ED0FCC98DD08C736946D3B33D4452171";
        this.testHMAC(new HMACwithLSH512_256(), sMsg, sExpectMac, sKey);
    }

    private void testHMACLSH512_384() throws Exception {
        String sMsg = "B9D01033D3CE7DFB8DA90D23CB0ADA3091323007BCDEE6F7F16DEFFAD4442C387A7284CD209037CC1DEB6F8415E619027099F2D70ABEE51B2CCE94B1BC6735CDB0F19FB4C881A4C37DFDA2B33582551BB802EF36E7326BE7ACA31EFA2D2E8FAD4596886F34696DE79527CD3891A6378453B54FAFBB0020655734B45E8F63E2E0";
        String sExpectMac = "DF0A180F7BCA497A5CE06AA63ABD5B9ECC47484221F9A48D1C88F9596A556F50436F29FA16FBBDE1B0AAFE9DED07A112";
        String sKey = "7348BBF92EB5E08DA7E6B224FFCE6FD187C51B5D7872CF47E5EF5409ED28F19D3584804096C8C7761238064E0DFFCDE7";
        this.testHMAC(new HMACwithLSH512_384(), sMsg, sExpectMac, sKey);
    }

    private void testHMACLSH512_512() throws Exception {
        String sMsg = "F08AD12A3F901E5E920E84D08E61F874EBB0114F28D2617E7D6C0579125A7B996E51B4D832C26AD90701B428D5A6D8C2363460D82AF870D00C34568DC47D63F03F62F99E1C4EE604A8B0F0990D58B163C624A6BD56DD82573A5CC87E1CF1989E4905C90565FD39E95E6261AD9E3F2D6085CB0A871648401CF02B82D6807DC3AB";
        String sExpectMac = "013f4b733ce194d481ad86e7a18b019f09e1922eaf57e7c45aa2335d221840d80dc902f76581a5fc0260121168599ddf6f053428d7050c2a2635c615a0231755";
        String sKey = "49B993F89E1E755D8C3CAA5133FC84B288D4B63206A3AE59A1DC25CEFCE7F4D2DBC4290DDBF25A8D618F390CD0C06971FF53909AEAA3AE59A7BCADBC9CC03992";
        this.testHMAC(new HMACwithLSH512_512(), sMsg, sExpectMac, sKey);
    }

    public void selfTest() {
        try {
            this.testHMACSHA224();
            this.testHMACSHA256();
            this.testHMACSHA384();
            this.testHMACSHA512();
            this.testHMACSHA3_224();
            this.testHMACSHA3_256();
            this.testHMACSHA3_384();
            this.testHMACSHA3_512();
            this.testHMACLSH256_224();
            this.testHMACLSH256_256();
            this.testHMACLSH512_224();
            this.testHMACLSH512_256();
            this.testHMACLSH512_384();
            this.testHMACLSH512_512();
        }
        catch (Exception e) {
            throw new KSXRuntimeException("Selftest of HMAC failed", e);
        }
    }
}

