/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.mac;

import com.initech.cryptox.Mac;
import com.initech.cryptox.MacSpi;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.spec.PBMAC1ParameterSpec;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBKDF2;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;

public class PBMAC1
extends MacSpi {
    Mac delegationMac;

    protected int _engineGetMacLength() {
        return this.delegationMac.getMacLength();
    }

    protected void _engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("PBEKey is needed");
        }
        if (!(params instanceof PBMAC1ParameterSpec)) {
            throw new InvalidKeyException("PBMAC1ParameterSpec is needed");
        }
        PBMAC1ParameterSpec pbmacParam = (PBMAC1ParameterSpec)params;
        PBEParameterSpec pbeParam = pbmacParam.getPBEParameterSpec();
        AlgorithmParameterSpec macParam = pbmacParam.getMacParameterSpec();
        int dkLen = pbmacParam.getDkLen();
        String macName = pbmacParam.getAlgorithm();
        try {
            byte[] derivedKey = new PBKDF2((PBEKey)key, pbeParam, dkLen).process();
            SecretKeySpec delegationKeySpec = new SecretKeySpec(derivedKey, macName);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(macName, InitechProvider.NAME);
            SecretKey delegationKey = skf.generateSecret(delegationKeySpec);
            this.delegationMac = Mac.getInstance(macName, InitechProvider.NAME);
            if (macParam == null) {
                this.delegationMac.init(delegationKey);
            } else {
                this.delegationMac.init(delegationKey, macParam);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException(e.toString());
        }
        catch (NoSuchProviderException e) {
            throw new InvalidAlgorithmParameterException(e.toString());
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidAlgorithmParameterException(e.toString());
        }
    }

    protected void _engineUpdate(byte input) {
        this.delegationMac.update(input);
    }

    protected void _engineUpdate(byte[] input, int offset, int len) {
        this.delegationMac.update(input, offset, len);
    }

    protected byte[] _engineDoFinal() {
        return this.delegationMac.doFinal();
    }

    protected void _engineReset() {
        this.delegationMac.reset();
    }
}

