/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;

public class HAS160
extends MessageDigest {
    private static final int BLOCKSIZE = 64;
    private static final int DIGEST_LENGTH = 20;
    private int[] H;
    private int count;
    private int[] X;
    private byte[] buffer = new byte[64];
    public static final int S10 = 5;
    public static final int S11 = 11;
    public static final int S12 = 7;
    public static final int S13 = 15;
    public static final int S14 = 6;
    public static final int S15 = 13;
    public static final int S16 = 8;
    public static final int S17 = 14;
    public static final int S18 = 7;
    public static final int S19 = 12;
    public static final int S110 = 9;
    public static final int S111 = 11;
    public static final int S112 = 8;
    public static final int S113 = 15;
    public static final int S114 = 6;
    public static final int S115 = 12;
    public static final int S116 = 9;
    public static final int S117 = 14;
    public static final int S118 = 5;
    public static final int S119 = 13;
    public static final int S21 = 10;
    public static final int S22 = 17;
    public static final int S23 = 25;
    public static final int S24 = 30;
    public static final int A0 = 1732584193;
    public static final int B0 = -271733879;
    public static final int C0 = -1732584194;
    public static final int D0 = 271733878;
    public static final int E0 = -1009589776;
    public static final int K0 = 0;
    public static final int K1 = 1518500249;
    public static final int K2 = 1859775393;
    public static final int K3 = -1894007588;

    public HAS160() {
        super("HAS160");
        this.X = new int[20];
        this.H = new int[5];
        this._engineReset();
    }

    private final int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset + 0] << 0 & 0xFF | bytes[offset + 1] << 8 & 0xFF00 | bytes[offset + 2] << 16 & 0xFF0000 | bytes[offset + 3] << 24 & 0xFF000000;
    }

    private final void intToBytes(byte[] bytes, int offset, int val) {
        bytes[offset + 0] = (byte)(val >>> 0 & 0xFF);
        bytes[offset + 1] = (byte)(val >>> 8 & 0xFF);
        bytes[offset + 2] = (byte)(val >>> 16 & 0xFF);
        bytes[offset + 3] = (byte)(val >>> 24 & 0xFF);
    }

    protected int _engineGetDigestLength() {
        return 20;
    }

    protected void _engineReset() {
        this.H[0] = 1732584193;
        this.H[1] = -271733879;
        this.H[2] = -1732584194;
        this.H[3] = 271733878;
        this.H[4] = -1009589776;
        this.count = 0;
    }

    protected synchronized void _engineUpdate(byte b) {
        this.buffer[this.count & 0x3F] = b;
        if ((this.count & 0x3F) == 63) {
            for (int i = 0; i < 16; ++i) {
                this.X[i] = this.bytesToInt(this.buffer, i * 4);
            }
            HAS160.processBlock(this.H, this.X);
        }
        ++this.count;
    }

    protected synchronized void _engineUpdate(byte[] bytes, int offset, int length) {
        int i;
        int index = offset;
        while ((this.count & 0x3F) != 63 && length > 0) {
            this._engineUpdate(bytes[index++]);
            --length;
        }
        if (length == 0) {
            return;
        }
        this._engineUpdate(bytes[index++]);
        --length;
        while (length > 64) {
            for (i = 0; i < 16; ++i) {
                this.X[i] = this.bytesToInt(bytes, index);
                index += 4;
            }
            this.count += 64;
            length -= 64;
            HAS160.processBlock(this.H, this.X);
        }
        for (i = 0; i != length; ++i) {
            this._engineUpdate(bytes[i + index]);
        }
    }

    protected synchronized byte[] _engineDigest() {
        long bitLength = this.count << 3;
        this._engineUpdate((byte)-128);
        while ((this.count & 0x3F) != 56) {
            this._engineUpdate((byte)0);
        }
        for (int i = 0; i < 14; ++i) {
            this.X[i] = this.bytesToInt(this.buffer, i * 4);
        }
        this.X[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(bitLength >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        HAS160.processBlock(this.H, this.X);
        byte[] digest = new byte[20];
        this.intToBytes(digest, 0, this.H[0]);
        this.intToBytes(digest, 4, this.H[1]);
        this.intToBytes(digest, 8, this.H[2]);
        this.intToBytes(digest, 12, this.H[3]);
        this.intToBytes(digest, 16, this.H[4]);
        this._engineReset();
        return digest;
    }

    public static void processBlock(int[] H, int[] X) {
        int A = H[0];
        int B = H[1];
        int C = H[2];
        int D = H[3];
        int E = H[4];
        X[16] = X[0] ^ X[1] ^ X[2] ^ X[3];
        X[17] = X[4] ^ X[5] ^ X[6] ^ X[7];
        X[18] = X[8] ^ X[9] ^ X[10] ^ X[11];
        X[19] = X[12] ^ X[13] ^ X[14] ^ X[15];
        E = HAS160.FF0(A, B, C, D, E, 0, X[18], 5);
        B = HAS160.rotateLeft(B, 10);
        D = HAS160.FF0(E, A, B, C, D, 0, X[0], 11);
        A = HAS160.rotateLeft(A, 10);
        C = HAS160.FF0(D, E, A, B, C, 0, X[1], 7);
        E = HAS160.rotateLeft(E, 10);
        B = HAS160.FF0(C, D, E, A, B, 0, X[2], 15);
        D = HAS160.rotateLeft(D, 10);
        A = HAS160.FF0(B, C, D, E, A, 0, X[3], 6);
        C = HAS160.rotateLeft(C, 10);
        E = HAS160.FF0(A, B, C, D, E, 0, X[19], 13);
        B = HAS160.rotateLeft(B, 10);
        D = HAS160.FF0(E, A, B, C, D, 0, X[4], 8);
        A = HAS160.rotateLeft(A, 10);
        C = HAS160.FF0(D, E, A, B, C, 0, X[5], 14);
        E = HAS160.rotateLeft(E, 10);
        B = HAS160.FF0(C, D, E, A, B, 0, X[6], 7);
        D = HAS160.rotateLeft(D, 10);
        A = HAS160.FF0(B, C, D, E, A, 0, X[7], 12);
        C = HAS160.rotateLeft(C, 10);
        E = HAS160.FF0(A, B, C, D, E, 0, X[16], 9);
        B = HAS160.rotateLeft(B, 10);
        D = HAS160.FF0(E, A, B, C, D, 0, X[8], 11);
        A = HAS160.rotateLeft(A, 10);
        C = HAS160.FF0(D, E, A, B, C, 0, X[9], 8);
        E = HAS160.rotateLeft(E, 10);
        B = HAS160.FF0(C, D, E, A, B, 0, X[10], 15);
        D = HAS160.rotateLeft(D, 10);
        A = HAS160.FF0(B, C, D, E, A, 0, X[11], 6);
        C = HAS160.rotateLeft(C, 10);
        E = HAS160.FF0(A, B, C, D, E, 0, X[17], 12);
        B = HAS160.rotateLeft(B, 10);
        D = HAS160.FF0(E, A, B, C, D, 0, X[12], 9);
        A = HAS160.rotateLeft(A, 10);
        C = HAS160.FF0(D, E, A, B, C, 0, X[13], 14);
        E = HAS160.rotateLeft(E, 10);
        B = HAS160.FF0(C, D, E, A, B, 0, X[14], 5);
        D = HAS160.rotateLeft(D, 10);
        A = HAS160.FF0(B, C, D, E, A, 0, X[15], 13);
        C = HAS160.rotateLeft(C, 10);
        X[16] = X[3] ^ X[6] ^ X[9] ^ X[12];
        X[17] = X[15] ^ X[2] ^ X[5] ^ X[8];
        X[18] = X[11] ^ X[14] ^ X[1] ^ X[4];
        X[19] = X[7] ^ X[10] ^ X[13] ^ X[0];
        E = HAS160.FF1(A, B, C, D, E, 1518500249, X[18], 5);
        B = HAS160.rotateLeft(B, 17);
        D = HAS160.FF1(E, A, B, C, D, 1518500249, X[3], 11);
        A = HAS160.rotateLeft(A, 17);
        C = HAS160.FF1(D, E, A, B, C, 1518500249, X[6], 7);
        E = HAS160.rotateLeft(E, 17);
        B = HAS160.FF1(C, D, E, A, B, 1518500249, X[9], 15);
        D = HAS160.rotateLeft(D, 17);
        A = HAS160.FF1(B, C, D, E, A, 1518500249, X[12], 6);
        C = HAS160.rotateLeft(C, 17);
        E = HAS160.FF1(A, B, C, D, E, 1518500249, X[19], 13);
        B = HAS160.rotateLeft(B, 17);
        D = HAS160.FF1(E, A, B, C, D, 1518500249, X[15], 8);
        A = HAS160.rotateLeft(A, 17);
        C = HAS160.FF1(D, E, A, B, C, 1518500249, X[2], 14);
        E = HAS160.rotateLeft(E, 17);
        B = HAS160.FF1(C, D, E, A, B, 1518500249, X[5], 7);
        D = HAS160.rotateLeft(D, 17);
        A = HAS160.FF1(B, C, D, E, A, 1518500249, X[8], 12);
        C = HAS160.rotateLeft(C, 17);
        E = HAS160.FF1(A, B, C, D, E, 1518500249, X[16], 9);
        B = HAS160.rotateLeft(B, 17);
        D = HAS160.FF1(E, A, B, C, D, 1518500249, X[11], 11);
        A = HAS160.rotateLeft(A, 17);
        C = HAS160.FF1(D, E, A, B, C, 1518500249, X[14], 8);
        E = HAS160.rotateLeft(E, 17);
        B = HAS160.FF1(C, D, E, A, B, 1518500249, X[1], 15);
        D = HAS160.rotateLeft(D, 17);
        A = HAS160.FF1(B, C, D, E, A, 1518500249, X[4], 6);
        C = HAS160.rotateLeft(C, 17);
        E = HAS160.FF1(A, B, C, D, E, 1518500249, X[17], 12);
        B = HAS160.rotateLeft(B, 17);
        D = HAS160.FF1(E, A, B, C, D, 1518500249, X[7], 9);
        A = HAS160.rotateLeft(A, 17);
        C = HAS160.FF1(D, E, A, B, C, 1518500249, X[10], 14);
        E = HAS160.rotateLeft(E, 17);
        B = HAS160.FF1(C, D, E, A, B, 1518500249, X[13], 5);
        D = HAS160.rotateLeft(D, 17);
        A = HAS160.FF1(B, C, D, E, A, 1518500249, X[0], 13);
        C = HAS160.rotateLeft(C, 17);
        X[16] = X[12] ^ X[5] ^ X[14] ^ X[7];
        X[17] = X[0] ^ X[9] ^ X[2] ^ X[11];
        X[18] = X[4] ^ X[13] ^ X[6] ^ X[15];
        X[19] = X[8] ^ X[1] ^ X[10] ^ X[3];
        E = HAS160.FF2(A, B, C, D, E, 1859775393, X[18], 5);
        B = HAS160.rotateLeft(B, 25);
        D = HAS160.FF2(E, A, B, C, D, 1859775393, X[12], 11);
        A = HAS160.rotateLeft(A, 25);
        C = HAS160.FF2(D, E, A, B, C, 1859775393, X[5], 7);
        E = HAS160.rotateLeft(E, 25);
        B = HAS160.FF2(C, D, E, A, B, 1859775393, X[14], 15);
        D = HAS160.rotateLeft(D, 25);
        A = HAS160.FF2(B, C, D, E, A, 1859775393, X[7], 6);
        C = HAS160.rotateLeft(C, 25);
        E = HAS160.FF2(A, B, C, D, E, 1859775393, X[19], 13);
        B = HAS160.rotateLeft(B, 25);
        D = HAS160.FF2(E, A, B, C, D, 1859775393, X[0], 8);
        A = HAS160.rotateLeft(A, 25);
        C = HAS160.FF2(D, E, A, B, C, 1859775393, X[9], 14);
        E = HAS160.rotateLeft(E, 25);
        B = HAS160.FF2(C, D, E, A, B, 1859775393, X[2], 7);
        D = HAS160.rotateLeft(D, 25);
        A = HAS160.FF2(B, C, D, E, A, 1859775393, X[11], 12);
        C = HAS160.rotateLeft(C, 25);
        E = HAS160.FF2(A, B, C, D, E, 1859775393, X[16], 9);
        B = HAS160.rotateLeft(B, 25);
        D = HAS160.FF2(E, A, B, C, D, 1859775393, X[4], 11);
        A = HAS160.rotateLeft(A, 25);
        C = HAS160.FF2(D, E, A, B, C, 1859775393, X[13], 8);
        E = HAS160.rotateLeft(E, 25);
        B = HAS160.FF2(C, D, E, A, B, 1859775393, X[6], 15);
        D = HAS160.rotateLeft(D, 25);
        A = HAS160.FF2(B, C, D, E, A, 1859775393, X[15], 6);
        C = HAS160.rotateLeft(C, 25);
        E = HAS160.FF2(A, B, C, D, E, 1859775393, X[17], 12);
        B = HAS160.rotateLeft(B, 25);
        D = HAS160.FF2(E, A, B, C, D, 1859775393, X[8], 9);
        A = HAS160.rotateLeft(A, 25);
        C = HAS160.FF2(D, E, A, B, C, 1859775393, X[1], 14);
        E = HAS160.rotateLeft(E, 25);
        B = HAS160.FF2(C, D, E, A, B, 1859775393, X[10], 5);
        D = HAS160.rotateLeft(D, 25);
        A = HAS160.FF2(B, C, D, E, A, 1859775393, X[3], 13);
        C = HAS160.rotateLeft(C, 25);
        X[16] = X[7] ^ X[2] ^ X[13] ^ X[8];
        X[17] = X[3] ^ X[14] ^ X[9] ^ X[4];
        X[18] = X[15] ^ X[10] ^ X[5] ^ X[0];
        X[19] = X[11] ^ X[6] ^ X[1] ^ X[12];
        E = HAS160.FF1(A, B, C, D, E, -1894007588, X[18], 5);
        B = HAS160.rotateLeft(B, 30);
        D = HAS160.FF1(E, A, B, C, D, -1894007588, X[7], 11);
        A = HAS160.rotateLeft(A, 30);
        C = HAS160.FF1(D, E, A, B, C, -1894007588, X[2], 7);
        E = HAS160.rotateLeft(E, 30);
        B = HAS160.FF1(C, D, E, A, B, -1894007588, X[13], 15);
        D = HAS160.rotateLeft(D, 30);
        A = HAS160.FF1(B, C, D, E, A, -1894007588, X[8], 6);
        C = HAS160.rotateLeft(C, 30);
        E = HAS160.FF1(A, B, C, D, E, -1894007588, X[19], 13);
        B = HAS160.rotateLeft(B, 30);
        D = HAS160.FF1(E, A, B, C, D, -1894007588, X[3], 8);
        A = HAS160.rotateLeft(A, 30);
        C = HAS160.FF1(D, E, A, B, C, -1894007588, X[14], 14);
        E = HAS160.rotateLeft(E, 30);
        B = HAS160.FF1(C, D, E, A, B, -1894007588, X[9], 7);
        D = HAS160.rotateLeft(D, 30);
        A = HAS160.FF1(B, C, D, E, A, -1894007588, X[4], 12);
        C = HAS160.rotateLeft(C, 30);
        E = HAS160.FF1(A, B, C, D, E, -1894007588, X[16], 9);
        B = HAS160.rotateLeft(B, 30);
        D = HAS160.FF1(E, A, B, C, D, -1894007588, X[15], 11);
        A = HAS160.rotateLeft(A, 30);
        C = HAS160.FF1(D, E, A, B, C, -1894007588, X[10], 8);
        E = HAS160.rotateLeft(E, 30);
        B = HAS160.FF1(C, D, E, A, B, -1894007588, X[5], 15);
        D = HAS160.rotateLeft(D, 30);
        A = HAS160.FF1(B, C, D, E, A, -1894007588, X[0], 6);
        C = HAS160.rotateLeft(C, 30);
        E = HAS160.FF1(A, B, C, D, E, -1894007588, X[17], 12);
        B = HAS160.rotateLeft(B, 30);
        D = HAS160.FF1(E, A, B, C, D, -1894007588, X[11], 9);
        A = HAS160.rotateLeft(A, 30);
        C = HAS160.FF1(D, E, A, B, C, -1894007588, X[6], 14);
        E = HAS160.rotateLeft(E, 30);
        B = HAS160.FF1(C, D, E, A, B, -1894007588, X[1], 5);
        D = HAS160.rotateLeft(D, 30);
        A = HAS160.FF1(B, C, D, E, A, -1894007588, X[12], 13);
        C = HAS160.rotateLeft(C, 30);
        H[0] = H[0] + A;
        H[1] = H[1] + B;
        H[2] = H[2] + C;
        H[3] = H[3] + D;
        H[4] = H[4] + E;
        for (int i = 0; i < X.length; ++i) {
            X[i] = 0;
        }
    }

    public static final int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    public static final int FF0(int A, int B, int C, int D, int E, int K, int X, int S1) {
        return HAS160.rotateLeft(A, S1) + (B & C ^ ~B & D) + E + X + K;
    }

    public static final int FF1(int A, int B, int C, int D, int E, int K, int X, int S1) {
        return HAS160.rotateLeft(A, S1) + (B ^ C ^ D) + E + X + K;
    }

    public static final int FF2(int A, int B, int C, int D, int E, int K, int X, int S1) {
        return HAS160.rotateLeft(A, S1) + ((B | ~D) ^ C) + E + X + K;
    }
}

