/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;
import com.initech.cryptox.util.ByteConverter;
import java.util.Arrays;

public abstract class LSH256
extends MessageDigest {
    private static final int[] STEP = new int[]{-1854099568, 1813713058, 1865754947, -814251453, 753628274, 703164402, -1969511384, 787162690, 237781025, -2027179250, -1537315662, 1190774290, 408938142, 324624923, 641715378, 437348464, 980181295, -1294024299, 46866262, 1086314584, 2017887414, 1824226606, 1712094936, 729405578, -1496477591, -1851762873, -840272552, 9973912, -1093977298, 674802586, 1921734462, -1521327435, 1952315919, 838311640, -1201680859, -1731671912, -1979291156, 1625572802, -35482192, -139126694, -765982333, 697726729, 405664733, 1636917552, -1871686026, 1160382498, -528988499, -1395821743, 711036245, -1072857038, 1176621301, -218984047, 13028614, 1865558631, 1488909453, 2051065085, -1947278721, -846351630, 1743963707, -444324989, -946613498, -1587768874, 397640165, -1157250441, 2060542474, 1530963391, 1522074018, 1772595048, 1533467085, -34707337, -885692676, -1060619726, 1278438532, -1679399654, 330998780, 290394065, -1035950296, -329850764, 10249159, -1996329742, 2141188304, -2108981323, -832659441, 1616830690, 48746474, 1127699808, -1660933433, -1955635333, 529580367, -842320585, 754888669, -1086340286, -357058068, 2056041891, -1658129820, -87106810, -1336799122, -1728025340, 732859657, -16579071, -1569610026, 121788701, -937601279, -911613440, 40009502, -1720880739, -633629132, 34146304, 337149304, 1234925092, -445359927, 1938547401, 1692507424, 115281718, 366070542, 185665538, 748025228, -451831187, 1506615982, -9524164, 1182711172, -437369540, -409151197, 471403021, -1031044680, -156497838, 653250823, 1847257403, -985906742, -734821855, -2072642294, 891492137, 1309489786, -1565238456, 381737005, -1996217175, 25037967, 129344501, -93124722, 1480212574, 1531425992, 1460642794, -677837501, -1926705614, 2139790224, -1118201604, 1836750472, -1837457738, -1560511197, 1723043393, 1889421594, -1242103617, 170273807, 384996793, -401531147, 219764040, -1619418939, 440520615, 250045322, -1393049484, 810695449, 159928015, -114289443, 644783445, 421160548, 1544648385, -162861672, -1531431648, -2104667063, -1848173096, 692384470, -1794379141, 864078461, 1837643805, 1094223502, 1559057860, 266444235, 1760884329, 1849149695, -1593938416, -1270134864, -171944566, 2042565839, 1245911584, -243308326, 1575706577, -1509898131, -1620279632, -7145372, -1240080257, 953410632, -1923270038, 1894269899, 1229664558, -1496762861, 199962447, -1836360349, -873045963, 213396608, -359160585, 1496059707, -1803788425, 1879001529, -149258662, 501793013, -1034512896, -991646580, -2109956895};
    private static final int ALPHA_EVEN = 29;
    private static final int ALPHA_ODD = 5;
    private static final int BETA_EVEN = 1;
    private static final int BETA_ODD = 17;
    private static final int[] GAMMA = new int[]{0, 8, 16, 24, 24, 16, 8, 0};
    private static final int BLOCKSIZE = 128;
    private static final int NUMSTEP = 26;
    private int[] cv;
    private int[] tcv;
    private int[] msg;
    private byte[] block;
    private int boff;
    private int outlenbits;

    public LSH256(String algorithm, int outLenbits) {
        super(algorithm);
        this.outlenbits = outLenbits;
        this.cv = new int[16];
        this.tcv = new int[16];
        this.msg = new int[432];
        this.block = new byte[128];
        this.initIV();
    }

    protected int _engineGetDigestLength() {
        return this.outlenbits / 8;
    }

    protected void _engineUpdate(byte input) {
        byte[] inputArr = new byte[]{0};
        inputArr[0] = input;
        this._engineUpdate(inputArr, 0, 1);
    }

    protected void _engineUpdate(byte[] input, int offset, int len) {
        if (input == null || input.length == 0) {
            return;
        }
        int bitLen = len * 8;
        int rbytes = bitLen >> 3;
        int rbits = bitLen & 7;
        int blkidx = this.boff >> 3;
        if ((this.boff & 7) > 0) {
            throw new IllegalArgumentException("bit level update is not allowed");
        }
        int gap = 128 - blkidx;
        if (blkidx > 0 && rbytes >= gap) {
            System.arraycopy(input, offset, this.block, blkidx, gap);
            this.compress(this.block, 0);
            this.boff = 0;
            rbytes -= gap;
            offset += gap;
        }
        while (rbytes >= this.block.length) {
            this.compress(input, offset);
            this.boff = 0;
            offset += 128;
            rbytes -= 128;
        }
        if (rbytes > 0) {
            blkidx = this.boff >> 3;
            System.arraycopy(input, offset, this.block, blkidx, rbytes);
            this.boff += rbytes << 3;
            offset += rbytes;
        }
        if (rbits > 0) {
            blkidx = this.boff >> 3;
            this.block[blkidx] = (byte)(input[offset] & (255 >> rbits ^ 0xFF));
            this.boff += rbits;
        }
    }

    protected byte[] _engineDigest() {
        int rbytes = this.boff >> 3;
        int rbits = this.boff & 7;
        if (rbits > 0) {
            int n = rbytes;
            this.block[n] = (byte)(this.block[n] | (byte)(1 << 7 - rbits));
        } else {
            this.block[rbytes] = -128;
        }
        Arrays.fill(this.block, rbytes + 1, this.block.length, (byte)0);
        this.compress(this.block, 0);
        int[] temp = new int[8];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.cv[i] ^ this.cv[i + 8];
        }
        this.engineReset();
        rbytes = this.outlenbits >> 3;
        rbits = this.outlenbits & 7;
        byte[] result = new byte[rbits > 0 ? rbytes + 1 : rbytes];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(temp[i >> 2] >> (i << 3 & 0x1F));
        }
        if (rbits > 0) {
            int n = rbytes;
            result[n] = (byte)(result[n] & 255 << 8 - rbits);
        }
        return result;
    }

    protected void _engineReset() {
        if (this.tcv != null) {
            Arrays.fill(this.tcv, 0);
        }
        if (this.msg != null) {
            Arrays.fill(this.msg, 0);
        }
        if (this.block != null) {
            Arrays.fill(this.block, (byte)0);
        }
        this.initIV();
    }

    protected abstract int[] getIVValue();

    private void initIV() {
        this.boff = 0;
        int[] iv = this.getIVValue();
        if (iv == null) {
            throw new RuntimeException("Invalid hash iv null");
        }
        System.arraycopy(iv, 0, this.cv, 0, this.cv.length);
    }

    private void compress(byte[] data, int offset) {
        int i;
        this.msgExpansion(data, offset);
        for (i = 0; i < 13; ++i) {
            this.step(2 * i, 29, 1);
            this.step(2 * i + 1, 5, 17);
        }
        for (i = 0; i < 16; ++i) {
            int n = i;
            this.cv[n] = this.cv[n] ^ this.msg[416 + i];
        }
    }

    private void msgExpansion(byte[] in, int offset) {
        ByteConverter.toU32(in, offset, this.msg, 0, 32);
        for (int i = 2; i <= 26; ++i) {
            int idx = 16 * i;
            this.msg[idx] = this.msg[idx - 16] + this.msg[idx - 29];
            this.msg[idx + 1] = this.msg[idx - 15] + this.msg[idx - 30];
            this.msg[idx + 2] = this.msg[idx - 14] + this.msg[idx - 32];
            this.msg[idx + 3] = this.msg[idx - 13] + this.msg[idx - 31];
            this.msg[idx + 4] = this.msg[idx - 12] + this.msg[idx - 25];
            this.msg[idx + 5] = this.msg[idx - 11] + this.msg[idx - 28];
            this.msg[idx + 6] = this.msg[idx - 10] + this.msg[idx - 27];
            this.msg[idx + 7] = this.msg[idx - 9] + this.msg[idx - 26];
            this.msg[idx + 8] = this.msg[idx - 8] + this.msg[idx - 21];
            this.msg[idx + 9] = this.msg[idx - 7] + this.msg[idx - 22];
            this.msg[idx + 10] = this.msg[idx - 6] + this.msg[idx - 24];
            this.msg[idx + 11] = this.msg[idx - 5] + this.msg[idx - 23];
            this.msg[idx + 12] = this.msg[idx - 4] + this.msg[idx - 17];
            this.msg[idx + 13] = this.msg[idx - 3] + this.msg[idx - 20];
            this.msg[idx + 14] = this.msg[idx - 2] + this.msg[idx - 19];
            this.msg[idx + 15] = this.msg[idx - 1] + this.msg[idx - 18];
        }
    }

    private void step(int stepidx, int alpha, int beta) {
        for (int colidx = 0; colidx < 8; ++colidx) {
            int vl = this.cv[colidx] ^ this.msg[16 * stepidx + colidx];
            int vr = this.cv[colidx + 8] ^ this.msg[16 * stepidx + colidx + 8];
            vl = LSH256.rol32(vl + vr, alpha) ^ STEP[8 * stepidx + colidx];
            vr = LSH256.rol32(vl + vr, beta);
            this.tcv[colidx] = vr + vl;
            this.tcv[colidx + 8] = LSH256.rol32(vr, GAMMA[colidx]);
        }
        this.wordPermutation();
    }

    private void wordPermutation() {
        this.cv[0] = this.tcv[6];
        this.cv[1] = this.tcv[4];
        this.cv[2] = this.tcv[5];
        this.cv[3] = this.tcv[7];
        this.cv[4] = this.tcv[12];
        this.cv[5] = this.tcv[15];
        this.cv[6] = this.tcv[14];
        this.cv[7] = this.tcv[13];
        this.cv[8] = this.tcv[2];
        this.cv[9] = this.tcv[0];
        this.cv[10] = this.tcv[1];
        this.cv[11] = this.tcv[3];
        this.cv[12] = this.tcv[8];
        this.cv[13] = this.tcv[11];
        this.cv[14] = this.tcv[10];
        this.cv[15] = this.tcv[9];
    }

    private static int rol32(int value, int rot) {
        return value << rot | value >>> 32 - rot;
    }
}

