/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;
import com.initech.cryptox.util.ByteConverter;
import java.util.Arrays;

public abstract class LSH512
extends MessageDigest {
    private static final long[] STEP = new long[]{-7527693643365705686L, -5035083124271340715L, -4244182054441640957L, -7345431102947911759L, -270820113377548245L, 180809222287086599L, 8787315242624788215L, -2923656467489884674L, 2290861394516558529L, -2744277778065950449L, -2396887642638180408L, -6207897939239057077L, 4186207156808307751L, -8872262093347398903L, 7837240362005274224L, 4936794877191255253L, -1544431967950109728L, -4303114161986303768L, -7257569725597161306L, -9009780045416229644L, 5944083024581098337L, 7224907149702882445L, 3475669001014349532L, -4069057647806461415L, 8909353858431935690L, 904304792093028780L, -2074268033805742271L, 8776281615432485238L, -3450420800550511437L, -6320013971023924751L, 7803217722629352204L, 5716596715183858656L, 2307676477023072069L, -7401341390315774536L, 1868693449501233444L, 5001598173583409135L, -1314430203422961533L, -930112066708118631L, -5268149318597609608L, -6574170094512454609L, 2777044236223870053L, -2130097719070239151L, 638870605368653117L, -5861354548732465356L, -5767168952929184656L, 768871814237683084L, -7302057498788401106L, 7538740491577914323L, -5722650165137909365L, 5967208410235086899L, -1830951083642113467L, 6264895019939636194L, -6422895006036327137L, -5314128551720515178L, 4939118329755180744L, 548178596021061435L, 5018433456321422651L, 2492803312524548997L, 9060917420425181227L, 5211285711755511352L, -8923793991185980219L, -671976337665580980L, -3471930338877610228L, -6692053412263624126L, -1534686885062991744L, -4985591261025214297L, 4366023761868071848L, -7311889459630850432L, -6018790594812515767L, -6677222116668347070L, -6842381553487350821L, -4310528096763099931L, -7032903913288294038L, -8471612997521012639L, -3183281696188183580L, 2412304393245703962L, 2697319324785783797L, -498885128776896539L, -6051372243841757316L, -1001076445543585111L, 324613508444490760L, -488739665173157397L, -6446656677142908745L, -7227069441978836677L, -7765208331016525542L, 913730420304451038L, -5676164475729294296L, 977770527232349339L, -8808048698313632756L, 3521114566465410532L, 3416200608132098141L, 5764304856103687382L, -3410181110615489618L, -4978954939980254230L, -1481488439374056231L, -6967391533219942488L, 5281005599671230609L, 1035983969842477588L, -7480159248109255284L, 5686822121883527973L, 9027170109877645950L, -6766078488966275420L, 6639096628768132804L, -1285448887698712505L, -7840622339000552998L, 7993463217583017506L, -3939543098285239772L, 4220503501012111475L, -4307035048848494341L, -4888228735634930874L, 9147378812131382048L, 1681029188202815541L, -4344837088800994195L, 6731454737075269776L, 2108347794718717677L, -3688500588750896211L, -103363131489948481L, -1896188045927724542L, 8139857356652131230L, 7749387672803906892L, 8628256674427140656L, -4010075500353519379L, 6889805105133446154L, -7160703549793193607L, -8117580719207207747L, -7704981886976865049L, 7461260330418393614L, -655728050027503177L, 3852676482628954791L, 2428264536880410293L, -207519056821293463L, 4373595074104404757L, -1736164507073058228L, -6378729066132294532L, -917478748266209163L, -2501412193682351699L, -5986323944674405924L, -3125312527859309610L, 2007834618056235110L, -1237454451450625967L, -3472420548746725581L, 2426852564150399267L, 4015634653808416360L, 2773108803469920138L, -7405495663429538168L, 8451419583377701546L, -495337223415021951L, -4431144769748495809L, -6968365489849996542L, -3488189519472143292L, -999562098971885921L, -6734056382903037520L, -3197745909307492575L, -4700967769657793249L, 1825542098306220154L, 4893926744628777473L, -1535755741622604383L, 7425753107427203347L, 1366957596159041169L, 3341452522617209426L, 8282784624904231156L, -9110352010932009763L, 7995717421959789203L, 3360576357346300740L, -7307600049108742261L, 8403909016707443834L, 819964812392099747L, -8243673151726103424L, 7300080123788971366L, 1376030551586546270L, 7310785261905595905L, -3328847626349635726L, 3514682897427503909L, 1535560669795526382L, 7816771973964567214L, 2751568482989856013L, -5447303704608623669L, 3151714357260910705L, -2696083208636117146L, -6963612581217007037L, -616954972899524523L, 7257466589549696259L, -1784706725447352038L, 6176825327430033971L, 1995497517509640063L, -1666149427166219876L, 8082890181480855104L, -314258222944301598L, 7463268628208162380L, 2047762069607225447L, 2498973402769316865L, 1024118810497291656L, -3665972063889949030L, -3925289086398820732L, -7179303688599570768L, -6977387001847303971L, -401346216295636301L, -8680726248520056957L, -3399878068119872221L, 4944117265870232982L, -1370872660529768089L, 5771628849528410957L, -406640599134525620L, -3854284324930613636L, 7534486854278780589L, 1109387049201107722L, -6771692042458234637L, -2187203757309185062L, -1826136355668917933L, 7569088432037486749L, 6173830464684225606L, 5573108473148083014L, -545006189856308203L, 8411310539041410329L, -6330911983068449643L, -8709043417174012229L, -8148441564173118151L, 8347599294131174918L, 254439084824541851L, -6557160150287691373L, 7507361796605205005L, 3437751909624915597L, -3730901162151015875L, -6168125294865397182L};
    private static final int ALPHA_EVEN = 23;
    private static final int ALPHA_ODD = 7;
    private static final int BETA_EVEN = 59;
    private static final int BETA_ODD = 3;
    private static final int[] GAMMA = new int[]{0, 16, 32, 48, 8, 24, 40, 56};
    private static final int BLOCKSIZE = 256;
    private static final int NUMSTEP = 28;
    private long[] cv;
    private long[] tcv;
    private long[] msg;
    private byte[] block;
    private int boff;
    private int outlenbits;

    public LSH512(String algorithm, int outLenbits) {
        super(algorithm);
        this.outlenbits = outLenbits;
        this.cv = new long[16];
        this.tcv = new long[16];
        this.msg = new long[464];
        this.block = new byte[256];
        this.initIV();
    }

    protected int _engineGetDigestLength() {
        return this.outlenbits / 8;
    }

    protected void _engineUpdate(byte input) {
        byte[] inputArr = new byte[]{0};
        inputArr[0] = input;
        this.engineUpdate(inputArr, 0, 1);
    }

    protected void _engineUpdate(byte[] input, int offset, int len) {
        if (input == null || input.length == 0) {
            return;
        }
        int bitLen = len * 8;
        int rbytes = bitLen >> 3;
        int rbits = bitLen & 7;
        int blkidx = this.boff >> 3;
        if ((this.boff & 7) > 0) {
            throw new IllegalArgumentException("bit level update is not allowed");
        }
        int gap = 256 - blkidx;
        if (blkidx > 0 && rbytes >= gap) {
            System.arraycopy(input, offset, this.block, blkidx, gap);
            this.compress(this.block, 0);
            this.boff = 0;
            rbytes -= gap;
            offset += gap;
        }
        while (rbytes >= this.block.length) {
            this.compress(input, offset);
            this.boff = 0;
            offset += 256;
            rbytes -= 256;
        }
        if (rbytes > 0) {
            blkidx = this.boff >> 3;
            System.arraycopy(input, offset, this.block, blkidx, rbytes);
            this.boff += rbytes << 3;
            offset += rbytes;
        }
        if (rbits > 0) {
            blkidx = this.boff >> 3;
            this.block[blkidx] = (byte)(input[offset] & (255 >> rbits ^ 0xFF));
            this.boff += rbits;
        }
    }

    protected byte[] _engineDigest() {
        int rbytes = this.boff >> 3;
        int rbits = this.boff & 7;
        if (rbits > 0) {
            int n = rbytes;
            this.block[n] = (byte)(this.block[n] | (byte)(1 << 7 - rbits));
        } else {
            this.block[rbytes] = -128;
        }
        Arrays.fill(this.block, rbytes + 1, this.block.length, (byte)0);
        this.compress(this.block, 0);
        long[] temp = new long[8];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.cv[i] ^ this.cv[i + 8];
        }
        this.engineReset();
        rbytes = this.outlenbits >> 3;
        rbits = this.outlenbits & 7;
        byte[] result = new byte[rbits > 0 ? rbytes + 1 : rbytes];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(temp[i >> 3] >> (i << 3 & 0x3F));
        }
        if (rbits > 0) {
            result[rbytes] = (byte)(result[rbytes] & 255 << 8 - rbits);
        }
        return result;
    }

    protected void _engineReset() {
        if (this.tcv != null) {
            Arrays.fill(this.tcv, 0L);
        }
        if (this.msg != null) {
            Arrays.fill(this.msg, 0L);
        }
        if (this.block != null) {
            Arrays.fill(this.block, (byte)0);
        }
        this.initIV();
    }

    protected abstract long[] getIVValue();

    private void initIV() {
        this.boff = 0;
        long[] iv = this.getIVValue();
        if (iv == null) {
            throw new RuntimeException("Invalid hash iv null");
        }
        System.arraycopy(iv, 0, this.cv, 0, this.cv.length);
    }

    private void compress(byte[] data, int offset) {
        int i;
        this.msgExpansion(data, offset);
        for (i = 0; i < 14; ++i) {
            this.step(2 * i, 23, 59);
            this.step(2 * i + 1, 7, 3);
        }
        for (i = 0; i < 16; ++i) {
            int n = i;
            this.cv[n] = this.cv[n] ^ this.msg[448 + i];
        }
    }

    private void msgExpansion(byte[] in, int offset) {
        ByteConverter.toU64(in, offset, this.msg, 0, 32);
        for (int i = 2; i <= 28; ++i) {
            int idx = 16 * i;
            this.msg[idx] = this.msg[idx - 16] + this.msg[idx - 29];
            this.msg[idx + 1] = this.msg[idx - 15] + this.msg[idx - 30];
            this.msg[idx + 2] = this.msg[idx - 14] + this.msg[idx - 32];
            this.msg[idx + 3] = this.msg[idx - 13] + this.msg[idx - 31];
            this.msg[idx + 4] = this.msg[idx - 12] + this.msg[idx - 25];
            this.msg[idx + 5] = this.msg[idx - 11] + this.msg[idx - 28];
            this.msg[idx + 6] = this.msg[idx - 10] + this.msg[idx - 27];
            this.msg[idx + 7] = this.msg[idx - 9] + this.msg[idx - 26];
            this.msg[idx + 8] = this.msg[idx - 8] + this.msg[idx - 21];
            this.msg[idx + 9] = this.msg[idx - 7] + this.msg[idx - 22];
            this.msg[idx + 10] = this.msg[idx - 6] + this.msg[idx - 24];
            this.msg[idx + 11] = this.msg[idx - 5] + this.msg[idx - 23];
            this.msg[idx + 12] = this.msg[idx - 4] + this.msg[idx - 17];
            this.msg[idx + 13] = this.msg[idx - 3] + this.msg[idx - 20];
            this.msg[idx + 14] = this.msg[idx - 2] + this.msg[idx - 19];
            this.msg[idx + 15] = this.msg[idx - 1] + this.msg[idx - 18];
        }
    }

    private void step(int stepidx, int alpha, int beta) {
        for (int colidx = 0; colidx < 8; ++colidx) {
            long vl = this.cv[colidx] ^ this.msg[16 * stepidx + colidx];
            long vr = this.cv[colidx + 8] ^ this.msg[16 * stepidx + colidx + 8];
            vl = LSH512.rol64(vl + vr, alpha) ^ STEP[8 * stepidx + colidx];
            vr = LSH512.rol64(vl + vr, beta);
            this.tcv[colidx] = vr + vl;
            this.tcv[colidx + 8] = LSH512.rol64(vr, GAMMA[colidx]);
        }
        this.wordPermutation();
    }

    private void wordPermutation() {
        this.cv[0] = this.tcv[6];
        this.cv[1] = this.tcv[4];
        this.cv[2] = this.tcv[5];
        this.cv[3] = this.tcv[7];
        this.cv[4] = this.tcv[12];
        this.cv[5] = this.tcv[15];
        this.cv[6] = this.tcv[14];
        this.cv[7] = this.tcv[13];
        this.cv[8] = this.tcv[2];
        this.cv[9] = this.tcv[0];
        this.cv[10] = this.tcv[1];
        this.cv[11] = this.tcv[3];
        this.cv[12] = this.tcv[8];
        this.cv[13] = this.tcv[11];
        this.cv[14] = this.tcv[10];
        this.cv[15] = this.tcv[9];
    }

    private static long rol64(long value, int rot) {
        return value << rot | value >>> 64 - rot;
    }
}

