/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;
import java.security.DigestException;

public final class MD5
extends MessageDigest {
    private static final int BLOCKSIZE = 64;
    private static final int DIGEST_LENGTH = 16;
    private int[] H;
    private int count;
    private int[] X;
    private byte[] buffer = new byte[64];
    public static final int A0 = 1732584193;
    public static final int B0 = -271733879;
    public static final int C0 = -1732584194;
    public static final int D0 = 271733878;
    public static final int K0 = 0;
    public static final int K1 = 1518500249;
    public static final int K2 = 1859775393;
    public static final int K3 = -1894007588;
    public static final int S11 = 7;
    public static final int S12 = 12;
    public static final int S13 = 17;
    public static final int S14 = 22;
    public static final int S21 = 5;
    public static final int S22 = 9;
    public static final int S23 = 14;
    public static final int S24 = 20;
    public static final int S31 = 4;
    public static final int S32 = 11;
    public static final int S33 = 16;
    public static final int S34 = 23;
    public static final int S41 = 6;
    public static final int S42 = 10;
    public static final int S43 = 15;
    public static final int S44 = 21;

    public MD5() {
        super("MD5");
        this.X = new int[20];
        this.H = new int[4];
        this._engineReset();
    }

    private final int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset + 0] & 0xFF | bytes[offset + 1] << 8 & 0xFF00 | bytes[offset + 2] << 16 & 0xFF0000 | bytes[offset + 3] << 24;
    }

    private final void intToBytes(byte[] bytes, int offset, int val) {
        bytes[offset + 0] = (byte)val;
        bytes[offset + 1] = (byte)(val >>> 8);
        bytes[offset + 2] = (byte)(val >>> 16);
        bytes[offset + 3] = (byte)(val >>> 24);
    }

    protected int _engineGetDigestLength() {
        return 16;
    }

    protected void _engineReset() {
        this.H[0] = 1732584193;
        this.H[1] = -271733879;
        this.H[2] = -1732584194;
        this.H[3] = 271733878;
        this.count = 0;
    }

    protected void _engineUpdate(byte b) {
        try {
            this.buffer[this.count & 0x3F] = b;
            if ((this.count & 0x3F) == 63) {
                for (int i = 0; i < 16; ++i) {
                    this.X[i] = this.bytesToInt(this.buffer, i * 4);
                }
                this.processBlock(this.H, this.X);
            }
            ++this.count;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("InitechProvider: MD5 engineUpdate 1");
        }
    }

    protected void _engineUpdate(byte[] bytes, int offset, int length) {
        try {
            int i;
            int index = offset;
            while ((this.count & 0x3F) != 63 && length > 0) {
                this._engineUpdate(bytes[index++]);
                --length;
            }
            if (length == 0) {
                return;
            }
            this._engineUpdate(bytes[index++]);
            --length;
            while (length > 64) {
                for (i = 0; i < 16; ++i) {
                    this.X[i] = this.bytesToInt(bytes, index);
                    index += 4;
                }
                this.count += 64;
                length -= 64;
                this.processBlock(this.H, this.X);
            }
            for (i = 0; i != length; ++i) {
                this._engineUpdate(bytes[i + index]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("InitechProvider: MD5 engineUpdate 2");
        }
    }

    protected byte[] _engineDigest() {
        try {
            long bitLength = this.count << 3;
            this._engineUpdate((byte)-128);
            while ((this.count & 0x3F) != 56) {
                this._engineUpdate((byte)0);
            }
            for (int i = 0; i < 14; ++i) {
                this.X[i] = this.bytesToInt(this.buffer, i * 4);
            }
            this.X[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
            this.X[15] = (int)(bitLength >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.processBlock(this.H, this.X);
            byte[] digest = new byte[16];
            this.intToBytes(digest, 0, this.H[0]);
            this.intToBytes(digest, 4, this.H[1]);
            this.intToBytes(digest, 8, this.H[2]);
            this.intToBytes(digest, 12, this.H[3]);
            this._engineReset();
            return digest;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("InitechProvider: MD5 engineDigest");
            return new byte[16];
        }
    }

    protected int _engineDigest(byte[] buf, int off, int len) throws DigestException {
        if (len < 16 || buf.length - off < 16) {
            throw new DigestException("Not enough buffer to hold digest");
        }
        try {
            long bitLength = this.count << 3;
            this._engineUpdate((byte)-128);
            while ((this.count & 0x3F) != 56) {
                this._engineUpdate((byte)0);
            }
            for (int i = 0; i < 14; ++i) {
                this.X[i] = this.bytesToInt(this.buffer, i * 4);
            }
            this.X[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
            this.X[15] = (int)(bitLength >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.processBlock(this.H, this.X);
            this.intToBytes(buf, off, this.H[0]);
            this.intToBytes(buf, off + 4, this.H[1]);
            this.intToBytes(buf, off + 8, this.H[2]);
            this.intToBytes(buf, off + 12, this.H[3]);
            this._engineReset();
            return 16;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("InitechProvider: MD5 engineDigest");
            return 0;
        }
    }

    public void processBlock(int[] H, int[] X) {
        int a = H[0];
        int b = H[1];
        int c = H[2];
        int d = H[3];
        int temp = 0;
        temp = a + (b & c | ~b & d) + X[0] + -680876936;
        a = b + (temp << 7 | temp >>> 25);
        temp = d + (a & b | ~a & c) + X[1] + -389564586;
        d = a + (temp << 12 | temp >>> 20);
        temp = c + (d & a | ~d & b) + X[2] + 606105819;
        c = d + (temp << 17 | temp >>> 15);
        temp = b + (c & d | ~c & a) + X[3] + -1044525330;
        b = c + (temp << 22 | temp >>> 10);
        temp = a + (b & c | ~b & d) + X[4] + -176418897;
        a = b + (temp << 7 | temp >>> 25);
        temp = d + (a & b | ~a & c) + X[5] + 1200080426;
        d = a + (temp << 12 | temp >>> 20);
        temp = c + (d & a | ~d & b) + X[6] + -1473231341;
        c = d + (temp << 17 | temp >>> 15);
        temp = b + (c & d | ~c & a) + X[7] + -45705983;
        b = c + (temp << 22 | temp >>> 10);
        temp = a + (b & c | ~b & d) + X[8] + 1770035416;
        a = b + (temp << 7 | temp >>> 25);
        temp = d + (a & b | ~a & c) + X[9] + -1958414417;
        d = a + (temp << 12 | temp >>> 20);
        temp = c + (d & a | ~d & b) + X[10] + -42063;
        c = d + (temp << 17 | temp >>> 15);
        temp = b + (c & d | ~c & a) + X[11] + -1990404162;
        b = c + (temp << 22 | temp >>> 10);
        temp = a + (b & c | ~b & d) + X[12] + 1804603682;
        a = b + (temp << 7 | temp >>> 25);
        temp = d + (a & b | ~a & c) + X[13] + -40341101;
        d = a + (temp << 12 | temp >>> 20);
        temp = c + (d & a | ~d & b) + X[14] + -1502002290;
        c = d + (temp << 17 | temp >>> 15);
        temp = b + (c & d | ~c & a) + X[15] + 1236535329;
        b = c + (temp << 22 | temp >>> 10);
        temp = a + (b & d | c & ~d) + X[1] + -165796510;
        a = b + (temp << 5 | temp >>> 27);
        temp = d + (a & c | b & ~c) + X[6] + -1069501632;
        d = a + (temp << 9 | temp >>> 23);
        temp = c + (d & b | a & ~b) + X[11] + 643717713;
        c = d + (temp << 14 | temp >>> 18);
        temp = b + (c & a | d & ~a) + X[0] + -373897302;
        b = c + (temp << 20 | temp >>> 12);
        temp = a + (b & d | c & ~d) + X[5] + -701558691;
        a = b + (temp << 5 | temp >>> 27);
        temp = d + (a & c | b & ~c) + X[10] + 38016083;
        d = a + (temp << 9 | temp >>> 23);
        temp = c + (d & b | a & ~b) + X[15] + -660478335;
        c = d + (temp << 14 | temp >>> 18);
        temp = b + (c & a | d & ~a) + X[4] + -405537848;
        b = c + (temp << 20 | temp >>> 12);
        temp = a + (b & d | c & ~d) + X[9] + 568446438;
        a = b + (temp << 5 | temp >>> 27);
        temp = d + (a & c | b & ~c) + X[14] + -1019803690;
        d = a + (temp << 9 | temp >>> 23);
        temp = c + (d & b | a & ~b) + X[3] + -187363961;
        c = d + (temp << 14 | temp >>> 18);
        temp = b + (c & a | d & ~a) + X[8] + 1163531501;
        b = c + (temp << 20 | temp >>> 12);
        temp = a + (b & d | c & ~d) + X[13] + -1444681467;
        a = b + (temp << 5 | temp >>> 27);
        temp = d + (a & c | b & ~c) + X[2] + -51403784;
        d = a + (temp << 9 | temp >>> 23);
        temp = c + (d & b | a & ~b) + X[7] + 1735328473;
        c = d + (temp << 14 | temp >>> 18);
        temp = b + (c & a | d & ~a) + X[12] + -1926607734;
        b = c + (temp << 20 | temp >>> 12);
        temp = a + (b ^ c ^ d) + X[5] + -378558;
        a = b + (temp << 4 | temp >>> 28);
        temp = d + (a ^ b ^ c) + X[8] + -2022574463;
        d = a + (temp << 11 | temp >>> 21);
        temp = c + (d ^ a ^ b) + X[11] + 1839030562;
        c = d + (temp << 16 | temp >>> 16);
        temp = b + (c ^ d ^ a) + X[14] + -35309556;
        b = c + (temp << 23 | temp >>> 9);
        temp = a + (b ^ c ^ d) + X[1] + -1530992060;
        a = b + (temp << 4 | temp >>> 28);
        temp = d + (a ^ b ^ c) + X[4] + 1272893353;
        d = a + (temp << 11 | temp >>> 21);
        temp = c + (d ^ a ^ b) + X[7] + -155497632;
        c = d + (temp << 16 | temp >>> 16);
        temp = b + (c ^ d ^ a) + X[10] + -1094730640;
        b = c + (temp << 23 | temp >>> 9);
        temp = a + (b ^ c ^ d) + X[13] + 681279174;
        a = b + (temp << 4 | temp >>> 28);
        temp = d + (a ^ b ^ c) + X[0] + -358537222;
        d = a + (temp << 11 | temp >>> 21);
        temp = c + (d ^ a ^ b) + X[3] + -722521979;
        c = d + (temp << 16 | temp >>> 16);
        temp = b + (c ^ d ^ a) + X[6] + 76029189;
        b = c + (temp << 23 | temp >>> 9);
        temp = a + (b ^ c ^ d) + X[9] + -640364487;
        a = b + (temp << 4 | temp >>> 28);
        temp = d + (a ^ b ^ c) + X[12] + -421815835;
        d = a + (temp << 11 | temp >>> 21);
        temp = c + (d ^ a ^ b) + X[15] + 530742520;
        c = d + (temp << 16 | temp >>> 16);
        temp = b + (c ^ d ^ a) + X[2] + -995338651;
        b = c + (temp << 23 | temp >>> 9);
        temp = a + (c ^ (b | ~d)) + X[0] + -198630844;
        a = b + (temp << 6 | temp >>> 26);
        temp = d + (b ^ (a | ~c)) + X[7] + 1126891415;
        d = a + (temp << 10 | temp >>> 22);
        temp = c + (a ^ (d | ~b)) + X[14] + -1416354905;
        c = d + (temp << 15 | temp >>> 17);
        temp = b + (d ^ (c | ~a)) + X[5] + -57434055;
        b = c + (temp << 21 | temp >>> 11);
        temp = a + (c ^ (b | ~d)) + X[12] + 1700485571;
        a = b + (temp << 6 | temp >>> 26);
        temp = d + (b ^ (a | ~c)) + X[3] + -1894986606;
        d = a + (temp << 10 | temp >>> 22);
        temp = c + (a ^ (d | ~b)) + X[10] + -1051523;
        c = d + (temp << 15 | temp >>> 17);
        temp = b + (d ^ (c | ~a)) + X[1] + -2054922799;
        b = c + (temp << 21 | temp >>> 11);
        temp = a + (c ^ (b | ~d)) + X[8] + 1873313359;
        a = b + (temp << 6 | temp >>> 26);
        temp = d + (b ^ (a | ~c)) + X[15] + -30611744;
        d = a + (temp << 10 | temp >>> 22);
        temp = c + (a ^ (d | ~b)) + X[6] + -1560198380;
        c = d + (temp << 15 | temp >>> 17);
        temp = b + (d ^ (c | ~a)) + X[13] + 1309151649;
        b = c + (temp << 21 | temp >>> 11);
        temp = a + (c ^ (b | ~d)) + X[4] + -145523070;
        a = b + (temp << 6 | temp >>> 26);
        temp = d + (b ^ (a | ~c)) + X[11] + -1120210379;
        d = a + (temp << 10 | temp >>> 22);
        temp = c + (a ^ (d | ~b)) + X[2] + 718787259;
        c = d + (temp << 15 | temp >>> 17);
        temp = b + (d ^ (c | ~a)) + X[9] + -343485551;
        b = c + (temp << 21 | temp >>> 11);
        H[0] = H[0] + a;
        H[1] = H[1] + b;
        H[2] = H[2] + c;
        H[3] = H[3] + d;
        for (int i = 0; i < X.length; ++i) {
            X[i] = 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MD5 md5 = new MD5();
        System.arraycopy(this.H, 0, md5.H, 0, this.H.length);
        System.arraycopy(this.X, 0, md5.X, 0, this.X.length);
        md5.count = this.count;
        System.arraycopy(this.buffer, 0, md5.buffer, 0, this.buffer.length);
        return md5;
    }
}

