/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.SelfTestCase;
import com.initech.provider.crypto.md.HAS160;
import com.initech.provider.crypto.md.LSH256;
import com.initech.provider.crypto.md.LSH256_224;
import com.initech.provider.crypto.md.LSH256_256;
import com.initech.provider.crypto.md.LSH512;
import com.initech.provider.crypto.md.LSH512_224;
import com.initech.provider.crypto.md.LSH512_256;
import com.initech.provider.crypto.md.LSH512_384;
import com.initech.provider.crypto.md.LSH512_512;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA3;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA3_224;
import com.initech.provider.crypto.md.SHA3_256;
import com.initech.provider.crypto.md.SHA3_384;
import com.initech.provider.crypto.md.SHA3_512;
import com.initech.provider.crypto.md.SHA512;
import java.util.Arrays;

public class MDSelfTestCase
implements SelfTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void testHash(SHA3 md, String sMsg, String sVactor) {
        byte[] input = null;
        byte[] hashedtext = null;
        byte[] hash = null;
        try {
            input = Hex.hexToByteArray(sMsg);
            hashedtext = Hex.hexToByteArray(sVactor);
            md.update(input, 0, input.length);
            hash = md.digest();
            if (!Arrays.equals(hashedtext, hash)) {
                throw new KSXRuntimeException();
            }
            if (hash == null) return;
        }
        catch (Throwable throwable) {
            if (hash == null) throw throwable;
            Arrays.fill(hash, (byte)0);
            throw throwable;
        }
        Arrays.fill(hash, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void testHash(LSH256 md, String sMsg, String sVactor) {
        byte[] input = null;
        byte[] hashedtext = null;
        byte[] hash = null;
        try {
            input = Hex.hexToByteArray(sMsg);
            hashedtext = Hex.hexToByteArray(sVactor);
            md.update(input, 0, input.length);
            hash = md.digest();
            if (!Arrays.equals(hashedtext, hash)) {
                throw new KSXRuntimeException();
            }
            if (hash == null) return;
        }
        catch (Throwable throwable) {
            if (hash == null) throw throwable;
            Arrays.fill(hash, (byte)0);
            throw throwable;
        }
        Arrays.fill(hash, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void testHash(LSH512 md, String sMsg, String sVactor) {
        byte[] input = null;
        byte[] hashedtext = null;
        byte[] hash = null;
        try {
            input = Hex.hexToByteArray(sMsg);
            hashedtext = Hex.hexToByteArray(sVactor);
            md.update(input, 0, input.length);
            hash = md.digest();
            if (!Arrays.equals(hashedtext, hash)) {
                throw new KSXRuntimeException();
            }
            if (hash == null) return;
        }
        catch (Throwable throwable) {
            if (hash == null) throw throwable;
            Arrays.fill(hash, (byte)0);
            throw throwable;
        }
        Arrays.fill(hash, (byte)0);
    }

    void testSHA1() throws KSXRuntimeException {
        SHA1 sha1 = new SHA1();
        byte[] input = "Hello World".getBytes();
        String hashedtext = "0A4D55A8D778E5022FAB701977C5D840BBC486D0";
        sha1._engineUpdate(input, 0, input.length);
        byte[] md = sha1._engineDigest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), md)) {
            throw new KSXRuntimeException("SHA1 SelfTest Failed");
        }
    }

    void testSHA224() throws KSXRuntimeException {
        SHA224 sha224 = new SHA224();
        byte[] input = Hex.parseHexaString("ebf4fafdfffefffe7fbedfeef77abddfee773a9d");
        String hashedtext = "18fffea169c8e60cf61d1572e44245ae3a9a49cb38502e997f81a69b";
        sha224._engineUpdate(input, 0, input.length);
        byte[] md = sha224._engineDigest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), md)) {
            throw new KSXRuntimeException("SHA224 SelfTest Failed");
        }
    }

    void testSHA256() throws KSXRuntimeException {
        SHA256 sha256 = new SHA256();
        byte[] input = Hex.parseHexaString("51b85221c6f06d6ef07b752e9473e3ab524da1da");
        String hashedtext = "edd3b2b52cf10582c56491ccce2ee54c9fd429c7e9c7aff2b5456cebabf83715";
        sha256._engineUpdate(input, 0, input.length);
        byte[] md = sha256._engineDigest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), md)) {
            throw new KSXRuntimeException("SHA256 SelfTest Failed");
        }
    }

    void testSHA384() throws KSXRuntimeException {
        SHA384 sha384 = new SHA384();
        byte[] input = Hex.parseHexaString("47886e6d58df8ecd90e3b714d3e02178a7403c30");
        String hashedtext = "01f8af56e260ea8b0561a0e57cce6248e08fdf1cdf80b1378a160e7ece137b1fc0855f4f5ea216a6c545443035450f51";
        sha384._engineUpdate(input, 0, input.length);
        byte[] md = sha384._engineDigest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), md)) {
            throw new KSXRuntimeException("SHA384 SelfTest Failed");
        }
    }

    void testSHA512() throws KSXRuntimeException {
        SHA512 sha512 = new SHA512();
        byte[] input = Hex.parseHexaString("ace19b50bbccd54b3a17f2c24df55e789ed022cd");
        String hashedtext = "48c2ab1b72a0c0a4a327f2d00e9a59f2a355c0acbc5955bbd2a3c74000e85d1210fd044a7eb5947baf26121d31ad9630da2fa02e9008cf161a239954d8a5212d";
        sha512._engineUpdate(input, 0, input.length);
        byte[] md = sha512._engineDigest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), md)) {
            throw new KSXRuntimeException("SHA512 SelfTest Failed");
        }
    }

    void testHAS160() throws KSXRuntimeException {
        HAS160 has160 = new HAS160();
        byte[] input = "Hello World".getBytes();
        String hashedtext = "DCE2BBEF9406E70551980F3C21A1BD0A1AD5B5C6";
        has160._engineUpdate(input, 0, input.length);
        byte[] md = has160._engineDigest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), md)) {
            throw new KSXRuntimeException("HAS160 SelfTest Failed");
        }
    }

    void testSHA3_224() {
        String sMsg = "8FD714D326AB1599B2AA6BD779152AE0";
        String sVactor = "E9B1A99A0CD785A6A272C684C22A06E9D6B34527E3C08BB90BE493E7";
        this.testHash(new SHA3_224(), sMsg, sVactor);
    }

    void testSHA3_256() {
        String sMsg = "D4E1CE00EF43CFBFAA699AECB2DDD89F95852FF4CA8C66A5F2A0CA";
        String sVactor = "8343285E746FE40D89972870EBAEF29178E107942D514096005F934FBD12299B";
        this.testHash(new SHA3_256(), sMsg, sVactor);
    }

    void testSHA3_384() {
        String sMsg = "C63FC7C3C0E844255A25B5A1B7D684CCACD43ADB2C8F9563";
        String sVactor = "8550884C2D19083C2CD6297D1E48D658EB1A2DD05A7D1F2F1D05C4798B39F94681905F6308E96C19E56F41F8D997B2F3";
        this.testHash(new SHA3_384(), sMsg, sVactor);
    }

    void testSHA3_512() {
        String sMsg = "2998E6DD493D28C8B0CA7732AD633E68A9DCCD0C0A145A0C578445D49C";
        String sVactor = "AF449A2F499E7410B795F0AC8131146C7E320A056824A837D9AF7DC005AA1DB34A574CB028B82525525D0C5DE1C7AA60B65B62B0A43562A2929186E896B2C290";
        this.testHash(new SHA3_512(), sMsg, sVactor);
    }

    void testLSH256_256() {
        String sMsg = "000102030405060708090A0B0C0D0E0F";
        String sVactor = "408AE507F8F0AF0D3F6E0C2B78581AEFCE3E6A1780F28BA1CC6A0D7C39756D91";
        this.testHash(new LSH256_256(), sMsg, sVactor);
    }

    void testLSH256_224() {
        String sMsg = "000102030405060708090A0B0C0D0E0F";
        String sVactor = "7C6032979FD3633CB850680DF4B905D72B7C9FF476ADBDB9A9426D49";
        this.testHash(new LSH256_224(), sMsg, sVactor);
    }

    void testLSH512_512() {
        String sMsg = "000102030405060708090A0B0C0D0E0F";
        String sVactor = "FC55851F2E216183DEEC0900EFE168204E9A014D4F4CDC12969BCE197C1938C5CB8D4024A3B37A31FEE97C422E1CC18C9E70C7A8F0FBFA5A6987230CFFED98EC";
        this.testHash(new LSH512_512(), sMsg, sVactor);
    }

    void testLSH512_384() {
        String sMsg = "000102030405060708090A0B0C0D0E0F";
        String sVactor = "746CF3B794DF8BC2B0585D410A87C19BBB76C5F8C4D42917F3227B696B6C9DB7127AB3148EB941517BEB81C27A8DD25A";
        this.testHash(new LSH512_384(), sMsg, sVactor);
    }

    void testLSH512_256() {
        String sMsg = "000102030405060708090A0B0C0D0E0F";
        String sVactor = "855996BD40152B86B106486AF9016DB1437D7AAEEA9028A3F89832A3F724DFE7";
        this.testHash(new LSH512_256(), sMsg, sVactor);
    }

    void testLSH512_224() {
        String sMsg = "000102030405060708090A0B0C0D0E0F";
        String sVactor = "C60270DDB2829DCE62CB3AEEE9A0B5B9B364A32E8C93F77CAF369192";
        this.testHash(new LSH512_224(), sMsg, sVactor);
    }

    public void selfTest() {
        try {
            this.testSHA224();
            this.testSHA256();
            this.testSHA384();
            this.testSHA512();
            this.testSHA3_224();
            this.testSHA3_256();
            this.testSHA3_384();
            this.testSHA3_512();
            this.testLSH256_256();
            this.testLSH256_224();
            this.testLSH512_512();
            this.testLSH512_384();
            this.testLSH512_256();
            this.testLSH512_224();
        }
        catch (Exception e) {
            throw new KSXRuntimeException("Selftest of MessageDigest failed");
        }
    }
}

