/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;

public class RIPEMD160
extends MessageDigest {
    private static int blockSize = 64;
    private byte[] inputBuffer = new byte[blockSize];
    private int inputBufferOffset = 0;
    private int[] mdBuffer = new int[5];
    private int plainTextLength = 0;

    public RIPEMD160() {
        super("RIPEMD160");
        this.mdBuffer[0] = 1732584193;
        this.mdBuffer[1] = -271733879;
        this.mdBuffer[2] = -1732584194;
        this.mdBuffer[3] = 271733878;
        this.mdBuffer[4] = -1009589776;
    }

    protected byte[] _engineDigest() {
        int i;
        int temp = 56 - (this.plainTextLength & 0x3F);
        int extra = temp > 0 ? temp : 64 + temp;
        this.inputBuffer[this.inputBufferOffset] = -128;
        int start = 1;
        if (this.inputBufferOffset + extra > blockSize) {
            start = blockSize - this.inputBufferOffset;
            for (i = 1; i < start; ++i) {
                this.inputBuffer[this.inputBufferOffset + i] = 0;
            }
            RIPEMD160.doDecodeBlock(this.mdBuffer, RIPEMD160.bytesToInts(this.inputBuffer, 0, blockSize));
            this.inputBufferOffset = -start;
        }
        for (i = start; i < extra; ++i) {
            this.inputBuffer[this.inputBufferOffset + i] = 0;
        }
        this.inputBufferOffset += extra;
        long lb = this.plainTextLength * 8;
        for (int i2 = 0; i2 < 8; ++i2) {
            this.inputBuffer[this.inputBufferOffset + i2] = (byte)(lb >>> 8 * i2 & 0xFFL);
        }
        RIPEMD160.doDecodeBlock(this.mdBuffer, RIPEMD160.bytesToInts(this.inputBuffer, 0, blockSize));
        byte[] retval = RIPEMD160.intsToBytes(this.mdBuffer);
        this.doReset();
        return retval;
    }

    protected void _engineReset() {
        this.doReset();
    }

    private void doReset() {
        this.inputBufferOffset = 0;
        this.plainTextLength = 0;
        this.mdBuffer[0] = 1732584193;
        this.mdBuffer[1] = -271733879;
        this.mdBuffer[2] = -1732584194;
        this.mdBuffer[3] = 271733878;
        this.mdBuffer[4] = -1009589776;
    }

    protected void _engineUpdate(byte input) {
        byte[] in = new byte[]{input};
        this._engineUpdate(in, 0, 1);
    }

    protected void _engineUpdate(byte[] input, int inputOffset, int length) {
        int len;
        int left = length;
        int inputUsed = 0;
        while ((len = blockSize - this.inputBufferOffset) <= left) {
            System.arraycopy(input, inputUsed + inputOffset, this.inputBuffer, this.inputBufferOffset, len);
            RIPEMD160.doDecodeBlock(this.mdBuffer, RIPEMD160.bytesToInts(this.inputBuffer, 0, blockSize));
            left -= len;
            this.inputBufferOffset = 0;
            inputUsed += len;
        }
        System.arraycopy(input, inputUsed + inputOffset, this.inputBuffer, 0, left);
        this.inputBufferOffset += left;
        this.plainTextLength += length;
    }

    private static void FF(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] ^ buf[c] ^ buf[d]) + x[i]);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void GG(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] & buf[c] | ~buf[b] & buf[d]) + x[i] + 1518500249);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void HH(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + (((buf[b] | ~buf[c]) ^ buf[d]) + x[i] + 1859775393);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void II(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] & buf[d] | buf[c] & ~buf[d]) + x[i] + -1894007588);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void JJ(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] ^ (buf[c] | ~buf[d])) + x[i] + -1454113458);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void FFF(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] ^ buf[c] ^ buf[d]) + x[i]);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void GGG(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] & buf[c] | ~buf[b] & buf[d]) + x[i] + 2053994217);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void HHH(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + (((buf[b] | ~buf[c]) ^ buf[d]) + x[i] + 1836072691);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void III(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] & buf[d] | buf[c] & ~buf[d]) + x[i] + 1548603684);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void JJJ(int[] buf, int[] x, int a, int b, int c, int d, int e, int i, int s) {
        int n = a;
        buf[n] = buf[n] + ((buf[b] ^ (buf[c] | ~buf[d])) + x[i] + 1352829926);
        buf[a] = (buf[a] << s | buf[a] >>> 32 - s) + buf[e];
        buf[c] = buf[c] << 10 | buf[c] >>> 22;
    }

    private static void doDecodeBlock(int[] inout, int[] block) {
        int[] first = new int[5];
        int[] second = new int[5];
        System.arraycopy(inout, 0, first, 0, 5);
        System.arraycopy(inout, 0, second, 0, 5);
        RIPEMD160.FF(first, block, 0, 1, 2, 3, 4, 0, 11);
        RIPEMD160.FF(first, block, 4, 0, 1, 2, 3, 1, 14);
        RIPEMD160.FF(first, block, 3, 4, 0, 1, 2, 2, 15);
        RIPEMD160.FF(first, block, 2, 3, 4, 0, 1, 3, 12);
        RIPEMD160.FF(first, block, 1, 2, 3, 4, 0, 4, 5);
        RIPEMD160.FF(first, block, 0, 1, 2, 3, 4, 5, 8);
        RIPEMD160.FF(first, block, 4, 0, 1, 2, 3, 6, 7);
        RIPEMD160.FF(first, block, 3, 4, 0, 1, 2, 7, 9);
        RIPEMD160.FF(first, block, 2, 3, 4, 0, 1, 8, 11);
        RIPEMD160.FF(first, block, 1, 2, 3, 4, 0, 9, 13);
        RIPEMD160.FF(first, block, 0, 1, 2, 3, 4, 10, 14);
        RIPEMD160.FF(first, block, 4, 0, 1, 2, 3, 11, 15);
        RIPEMD160.FF(first, block, 3, 4, 0, 1, 2, 12, 6);
        RIPEMD160.FF(first, block, 2, 3, 4, 0, 1, 13, 7);
        RIPEMD160.FF(first, block, 1, 2, 3, 4, 0, 14, 9);
        RIPEMD160.FF(first, block, 0, 1, 2, 3, 4, 15, 8);
        RIPEMD160.GG(first, block, 4, 0, 1, 2, 3, 7, 7);
        RIPEMD160.GG(first, block, 3, 4, 0, 1, 2, 4, 6);
        RIPEMD160.GG(first, block, 2, 3, 4, 0, 1, 13, 8);
        RIPEMD160.GG(first, block, 1, 2, 3, 4, 0, 1, 13);
        RIPEMD160.GG(first, block, 0, 1, 2, 3, 4, 10, 11);
        RIPEMD160.GG(first, block, 4, 0, 1, 2, 3, 6, 9);
        RIPEMD160.GG(first, block, 3, 4, 0, 1, 2, 15, 7);
        RIPEMD160.GG(first, block, 2, 3, 4, 0, 1, 3, 15);
        RIPEMD160.GG(first, block, 1, 2, 3, 4, 0, 12, 7);
        RIPEMD160.GG(first, block, 0, 1, 2, 3, 4, 0, 12);
        RIPEMD160.GG(first, block, 4, 0, 1, 2, 3, 9, 15);
        RIPEMD160.GG(first, block, 3, 4, 0, 1, 2, 5, 9);
        RIPEMD160.GG(first, block, 2, 3, 4, 0, 1, 2, 11);
        RIPEMD160.GG(first, block, 1, 2, 3, 4, 0, 14, 7);
        RIPEMD160.GG(first, block, 0, 1, 2, 3, 4, 11, 13);
        RIPEMD160.GG(first, block, 4, 0, 1, 2, 3, 8, 12);
        RIPEMD160.HH(first, block, 3, 4, 0, 1, 2, 3, 11);
        RIPEMD160.HH(first, block, 2, 3, 4, 0, 1, 10, 13);
        RIPEMD160.HH(first, block, 1, 2, 3, 4, 0, 14, 6);
        RIPEMD160.HH(first, block, 0, 1, 2, 3, 4, 4, 7);
        RIPEMD160.HH(first, block, 4, 0, 1, 2, 3, 9, 14);
        RIPEMD160.HH(first, block, 3, 4, 0, 1, 2, 15, 9);
        RIPEMD160.HH(first, block, 2, 3, 4, 0, 1, 8, 13);
        RIPEMD160.HH(first, block, 1, 2, 3, 4, 0, 1, 15);
        RIPEMD160.HH(first, block, 0, 1, 2, 3, 4, 2, 14);
        RIPEMD160.HH(first, block, 4, 0, 1, 2, 3, 7, 8);
        RIPEMD160.HH(first, block, 3, 4, 0, 1, 2, 0, 13);
        RIPEMD160.HH(first, block, 2, 3, 4, 0, 1, 6, 6);
        RIPEMD160.HH(first, block, 1, 2, 3, 4, 0, 13, 5);
        RIPEMD160.HH(first, block, 0, 1, 2, 3, 4, 11, 12);
        RIPEMD160.HH(first, block, 4, 0, 1, 2, 3, 5, 7);
        RIPEMD160.HH(first, block, 3, 4, 0, 1, 2, 12, 5);
        RIPEMD160.II(first, block, 2, 3, 4, 0, 1, 1, 11);
        RIPEMD160.II(first, block, 1, 2, 3, 4, 0, 9, 12);
        RIPEMD160.II(first, block, 0, 1, 2, 3, 4, 11, 14);
        RIPEMD160.II(first, block, 4, 0, 1, 2, 3, 10, 15);
        RIPEMD160.II(first, block, 3, 4, 0, 1, 2, 0, 14);
        RIPEMD160.II(first, block, 2, 3, 4, 0, 1, 8, 15);
        RIPEMD160.II(first, block, 1, 2, 3, 4, 0, 12, 9);
        RIPEMD160.II(first, block, 0, 1, 2, 3, 4, 4, 8);
        RIPEMD160.II(first, block, 4, 0, 1, 2, 3, 13, 9);
        RIPEMD160.II(first, block, 3, 4, 0, 1, 2, 3, 14);
        RIPEMD160.II(first, block, 2, 3, 4, 0, 1, 7, 5);
        RIPEMD160.II(first, block, 1, 2, 3, 4, 0, 15, 6);
        RIPEMD160.II(first, block, 0, 1, 2, 3, 4, 14, 8);
        RIPEMD160.II(first, block, 4, 0, 1, 2, 3, 5, 6);
        RIPEMD160.II(first, block, 3, 4, 0, 1, 2, 6, 5);
        RIPEMD160.II(first, block, 2, 3, 4, 0, 1, 2, 12);
        RIPEMD160.JJ(first, block, 1, 2, 3, 4, 0, 4, 9);
        RIPEMD160.JJ(first, block, 0, 1, 2, 3, 4, 0, 15);
        RIPEMD160.JJ(first, block, 4, 0, 1, 2, 3, 5, 5);
        RIPEMD160.JJ(first, block, 3, 4, 0, 1, 2, 9, 11);
        RIPEMD160.JJ(first, block, 2, 3, 4, 0, 1, 7, 6);
        RIPEMD160.JJ(first, block, 1, 2, 3, 4, 0, 12, 8);
        RIPEMD160.JJ(first, block, 0, 1, 2, 3, 4, 2, 13);
        RIPEMD160.JJ(first, block, 4, 0, 1, 2, 3, 10, 12);
        RIPEMD160.JJ(first, block, 3, 4, 0, 1, 2, 14, 5);
        RIPEMD160.JJ(first, block, 2, 3, 4, 0, 1, 1, 12);
        RIPEMD160.JJ(first, block, 1, 2, 3, 4, 0, 3, 13);
        RIPEMD160.JJ(first, block, 0, 1, 2, 3, 4, 8, 14);
        RIPEMD160.JJ(first, block, 4, 0, 1, 2, 3, 11, 11);
        RIPEMD160.JJ(first, block, 3, 4, 0, 1, 2, 6, 8);
        RIPEMD160.JJ(first, block, 2, 3, 4, 0, 1, 15, 5);
        RIPEMD160.JJ(first, block, 1, 2, 3, 4, 0, 13, 6);
        RIPEMD160.JJJ(second, block, 0, 1, 2, 3, 4, 5, 8);
        RIPEMD160.JJJ(second, block, 4, 0, 1, 2, 3, 14, 9);
        RIPEMD160.JJJ(second, block, 3, 4, 0, 1, 2, 7, 9);
        RIPEMD160.JJJ(second, block, 2, 3, 4, 0, 1, 0, 11);
        RIPEMD160.JJJ(second, block, 1, 2, 3, 4, 0, 9, 13);
        RIPEMD160.JJJ(second, block, 0, 1, 2, 3, 4, 2, 15);
        RIPEMD160.JJJ(second, block, 4, 0, 1, 2, 3, 11, 15);
        RIPEMD160.JJJ(second, block, 3, 4, 0, 1, 2, 4, 5);
        RIPEMD160.JJJ(second, block, 2, 3, 4, 0, 1, 13, 7);
        RIPEMD160.JJJ(second, block, 1, 2, 3, 4, 0, 6, 7);
        RIPEMD160.JJJ(second, block, 0, 1, 2, 3, 4, 15, 8);
        RIPEMD160.JJJ(second, block, 4, 0, 1, 2, 3, 8, 11);
        RIPEMD160.JJJ(second, block, 3, 4, 0, 1, 2, 1, 14);
        RIPEMD160.JJJ(second, block, 2, 3, 4, 0, 1, 10, 14);
        RIPEMD160.JJJ(second, block, 1, 2, 3, 4, 0, 3, 12);
        RIPEMD160.JJJ(second, block, 0, 1, 2, 3, 4, 12, 6);
        RIPEMD160.III(second, block, 4, 0, 1, 2, 3, 6, 9);
        RIPEMD160.III(second, block, 3, 4, 0, 1, 2, 11, 13);
        RIPEMD160.III(second, block, 2, 3, 4, 0, 1, 3, 15);
        RIPEMD160.III(second, block, 1, 2, 3, 4, 0, 7, 7);
        RIPEMD160.III(second, block, 0, 1, 2, 3, 4, 0, 12);
        RIPEMD160.III(second, block, 4, 0, 1, 2, 3, 13, 8);
        RIPEMD160.III(second, block, 3, 4, 0, 1, 2, 5, 9);
        RIPEMD160.III(second, block, 2, 3, 4, 0, 1, 10, 11);
        RIPEMD160.III(second, block, 1, 2, 3, 4, 0, 14, 7);
        RIPEMD160.III(second, block, 0, 1, 2, 3, 4, 15, 7);
        RIPEMD160.III(second, block, 4, 0, 1, 2, 3, 8, 12);
        RIPEMD160.III(second, block, 3, 4, 0, 1, 2, 12, 7);
        RIPEMD160.III(second, block, 2, 3, 4, 0, 1, 4, 6);
        RIPEMD160.III(second, block, 1, 2, 3, 4, 0, 9, 15);
        RIPEMD160.III(second, block, 0, 1, 2, 3, 4, 1, 13);
        RIPEMD160.III(second, block, 4, 0, 1, 2, 3, 2, 11);
        RIPEMD160.HHH(second, block, 3, 4, 0, 1, 2, 15, 9);
        RIPEMD160.HHH(second, block, 2, 3, 4, 0, 1, 5, 7);
        RIPEMD160.HHH(second, block, 1, 2, 3, 4, 0, 1, 15);
        RIPEMD160.HHH(second, block, 0, 1, 2, 3, 4, 3, 11);
        RIPEMD160.HHH(second, block, 4, 0, 1, 2, 3, 7, 8);
        RIPEMD160.HHH(second, block, 3, 4, 0, 1, 2, 14, 6);
        RIPEMD160.HHH(second, block, 2, 3, 4, 0, 1, 6, 6);
        RIPEMD160.HHH(second, block, 1, 2, 3, 4, 0, 9, 14);
        RIPEMD160.HHH(second, block, 0, 1, 2, 3, 4, 11, 12);
        RIPEMD160.HHH(second, block, 4, 0, 1, 2, 3, 8, 13);
        RIPEMD160.HHH(second, block, 3, 4, 0, 1, 2, 12, 5);
        RIPEMD160.HHH(second, block, 2, 3, 4, 0, 1, 2, 14);
        RIPEMD160.HHH(second, block, 1, 2, 3, 4, 0, 10, 13);
        RIPEMD160.HHH(second, block, 0, 1, 2, 3, 4, 0, 13);
        RIPEMD160.HHH(second, block, 4, 0, 1, 2, 3, 4, 7);
        RIPEMD160.HHH(second, block, 3, 4, 0, 1, 2, 13, 5);
        RIPEMD160.GGG(second, block, 2, 3, 4, 0, 1, 8, 15);
        RIPEMD160.GGG(second, block, 1, 2, 3, 4, 0, 6, 5);
        RIPEMD160.GGG(second, block, 0, 1, 2, 3, 4, 4, 8);
        RIPEMD160.GGG(second, block, 4, 0, 1, 2, 3, 1, 11);
        RIPEMD160.GGG(second, block, 3, 4, 0, 1, 2, 3, 14);
        RIPEMD160.GGG(second, block, 2, 3, 4, 0, 1, 11, 14);
        RIPEMD160.GGG(second, block, 1, 2, 3, 4, 0, 15, 6);
        RIPEMD160.GGG(second, block, 0, 1, 2, 3, 4, 0, 14);
        RIPEMD160.GGG(second, block, 4, 0, 1, 2, 3, 5, 6);
        RIPEMD160.GGG(second, block, 3, 4, 0, 1, 2, 12, 9);
        RIPEMD160.GGG(second, block, 2, 3, 4, 0, 1, 2, 12);
        RIPEMD160.GGG(second, block, 1, 2, 3, 4, 0, 13, 9);
        RIPEMD160.GGG(second, block, 0, 1, 2, 3, 4, 9, 12);
        RIPEMD160.GGG(second, block, 4, 0, 1, 2, 3, 7, 5);
        RIPEMD160.GGG(second, block, 3, 4, 0, 1, 2, 10, 15);
        RIPEMD160.GGG(second, block, 2, 3, 4, 0, 1, 14, 8);
        RIPEMD160.FFF(second, block, 1, 2, 3, 4, 0, 12, 8);
        RIPEMD160.FFF(second, block, 0, 1, 2, 3, 4, 15, 5);
        RIPEMD160.FFF(second, block, 4, 0, 1, 2, 3, 10, 12);
        RIPEMD160.FFF(second, block, 3, 4, 0, 1, 2, 4, 9);
        RIPEMD160.FFF(second, block, 2, 3, 4, 0, 1, 1, 12);
        RIPEMD160.FFF(second, block, 1, 2, 3, 4, 0, 5, 5);
        RIPEMD160.FFF(second, block, 0, 1, 2, 3, 4, 8, 14);
        RIPEMD160.FFF(second, block, 4, 0, 1, 2, 3, 7, 6);
        RIPEMD160.FFF(second, block, 3, 4, 0, 1, 2, 6, 8);
        RIPEMD160.FFF(second, block, 2, 3, 4, 0, 1, 2, 13);
        RIPEMD160.FFF(second, block, 1, 2, 3, 4, 0, 13, 6);
        RIPEMD160.FFF(second, block, 0, 1, 2, 3, 4, 14, 5);
        RIPEMD160.FFF(second, block, 4, 0, 1, 2, 3, 0, 15);
        RIPEMD160.FFF(second, block, 3, 4, 0, 1, 2, 3, 13);
        RIPEMD160.FFF(second, block, 2, 3, 4, 0, 1, 9, 11);
        RIPEMD160.FFF(second, block, 1, 2, 3, 4, 0, 11, 11);
        second[3] = second[3] + (first[2] + inout[1]);
        inout[1] = inout[2] + first[3] + second[4];
        inout[2] = inout[3] + first[4] + second[0];
        inout[3] = inout[4] + first[0] + second[1];
        inout[4] = inout[0] + first[1] + second[2];
        inout[0] = second[3];
    }

    private static final byte[] intsToBytes(int[] ints) {
        byte[] bytes = new byte[4 * ints.length];
        for (int j = 0; j < bytes.length; ++j) {
            bytes[j] = (byte)(ints[j / 4] >>> 8 * (j % 4) & 0xFF);
        }
        return bytes;
    }

    private static final int[] bytesToInts(byte[] bytes, int offset, int length) {
        int[] retval = new int[(length + 3) / 4];
        for (int j = 0; j < length; ++j) {
            int n = j / 4;
            retval[n] = retval[n] + ((bytes[j + offset] & 0xFF) << 8 * (j % 4));
        }
        return retval;
    }
}

