/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;
import java.security.DigestException;

public class SHA1
extends MessageDigest {
    private static final int BLOCKSIZE = 64;
    private static final int DIGEST_LENGTH = 20;
    private int[] H;
    private int count;
    private int[] X;
    private byte[] buffer = new byte[64];
    public static final int A0 = 1732584193;
    public static final int B0 = -271733879;
    public static final int C0 = -1732584194;
    public static final int D0 = 271733878;
    public static final int E0 = -1009589776;
    public static final int K0 = 1518500249;
    public static final int K1 = 1859775393;
    public static final int K2 = -1894007588;
    public static final int K3 = -899497514;
    private static final int mask = 15;

    public SHA1() {
        super("SHA1");
        this.X = new int[16];
        this.H = new int[5];
        this._engineReset();
    }

    private static final int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset + 0] << 24 & 0xFF000000 | bytes[offset + 1] << 16 & 0xFF0000 | bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] << 0 & 0xFF;
    }

    private static final void intToBytes(byte[] bytes, int offset, int val) {
        bytes[offset + 0] = (byte)(val >>> 24 & 0xFF);
        bytes[offset + 1] = (byte)(val >>> 16 & 0xFF);
        bytes[offset + 2] = (byte)(val >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(val >>> 0 & 0xFF);
    }

    protected int _engineGetDigestLength() {
        return 20;
    }

    protected void _engineReset() {
        this.H[0] = 1732584193;
        this.H[1] = -271733879;
        this.H[2] = -1732584194;
        this.H[3] = 271733878;
        this.H[4] = -1009589776;
        this.count = 0;
    }

    protected void _engineUpdate(byte b) {
        this.buffer[this.count & 0x3F] = b;
        if ((this.count & 0x3F) == 63) {
            for (int i = 0; i < 16; ++i) {
                this.X[i] = SHA1.bytesToInt(this.buffer, i * 4);
            }
            this.processBlock(this.H, this.X);
        }
        ++this.count;
    }

    protected void _engineUpdate(byte[] bytes, int offset, int length) {
        int i;
        int index = offset;
        while ((this.count & 0x3F) != 63 && length > 0) {
            this._engineUpdate(bytes[index++]);
            --length;
        }
        if (length == 0) {
            return;
        }
        this._engineUpdate(bytes[index++]);
        --length;
        while (length > 64) {
            for (i = 0; i < 16; ++i) {
                this.X[i] = SHA1.bytesToInt(bytes, index);
                index += 4;
            }
            this.count += 64;
            length -= 64;
            this.processBlock(this.H, this.X);
        }
        for (i = 0; i != length; ++i) {
            this._engineUpdate(bytes[i + index]);
        }
    }

    protected byte[] _engineDigest() {
        long bitLength = this.count << 3;
        this._engineUpdate((byte)-128);
        while ((this.count & 0x3F) != 56) {
            this._engineUpdate((byte)0);
        }
        for (int i = 0; i < 14; ++i) {
            this.X[i] = SHA1.bytesToInt(this.buffer, i * 4);
        }
        this.X[14] = (int)(bitLength >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.processBlock(this.H, this.X);
        byte[] digest = new byte[20];
        SHA1.intToBytes(digest, 0, this.H[0]);
        SHA1.intToBytes(digest, 4, this.H[1]);
        SHA1.intToBytes(digest, 8, this.H[2]);
        SHA1.intToBytes(digest, 12, this.H[3]);
        SHA1.intToBytes(digest, 16, this.H[4]);
        this._engineReset();
        return digest;
    }

    protected int _engineDigest(byte[] buf, int off, int len) throws DigestException {
        if (len < 20 || buf.length - off < 20) {
            throw new DigestException("Not enough buffer to hold digest");
        }
        long bitLength = this.count << 3;
        this._engineUpdate((byte)-128);
        while ((this.count & 0x3F) != 56) {
            this._engineUpdate((byte)0);
        }
        for (int i = 0; i < 14; ++i) {
            this.X[i] = SHA1.bytesToInt(this.buffer, i * 4);
        }
        this.X[14] = (int)(bitLength >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.processBlock(this.H, this.X);
        SHA1.intToBytes(buf, off, this.H[0]);
        SHA1.intToBytes(buf, off + 4, this.H[1]);
        SHA1.intToBytes(buf, off + 8, this.H[2]);
        SHA1.intToBytes(buf, off + 12, this.H[3]);
        SHA1.intToBytes(buf, off + 16, this.H[4]);
        this._engineReset();
        return 20;
    }

    public final void processBlock(int[] H, int[] X) {
        int temp1;
        int s;
        int t;
        int A = H[0];
        int B = H[1];
        int C = H[2];
        int D = H[3];
        int E = H[4];
        int temp2 = 0;
        for (t = 0; t < 16; ++t) {
            s = t & 0xF;
            temp2 = (B & C | ~B & D) + 1518500249 + (A << 5 | A >>> 27) + E + X[s];
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp2;
        }
        while (t < 20) {
            s = t & 0xF;
            temp1 = X[s + 13 & 0xF] ^ X[s + 8 & 0xF] ^ X[s + 2 & 0xF] ^ X[s];
            X[s] = temp1 << 1 | temp1 >>> 31;
            temp2 = (B & C | ~B & D) + 1518500249 + (A << 5 | A >>> 27) + E + X[s];
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp2;
            ++t;
        }
        while (t < 40) {
            s = t & 0xF;
            temp1 = X[s + 13 & 0xF] ^ X[s + 8 & 0xF] ^ X[s + 2 & 0xF] ^ X[s];
            X[s] = temp1 << 1 | temp1 >>> 31;
            temp2 = (B ^ C ^ D) + 1859775393 + (A << 5 | A >>> 27) + E + X[s];
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp2;
            ++t;
        }
        while (t < 60) {
            s = t & 0xF;
            temp1 = X[s + 13 & 0xF] ^ X[s + 8 & 0xF] ^ X[s + 2 & 0xF] ^ X[s];
            X[s] = temp1 << 1 | temp1 >>> 31;
            temp2 = (B & C | B & D | C & D) + -1894007588 + (A << 5 | A >>> 27) + E + X[s];
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp2;
            ++t;
        }
        while (t < 80) {
            s = t & 0xF;
            temp1 = X[s + 13 & 0xF] ^ X[s + 8 & 0xF] ^ X[s + 2 & 0xF] ^ X[s];
            X[s] = temp1 << 1 | temp1 >>> 31;
            temp2 = (B ^ C ^ D) + -899497514 + (A << 5 | A >>> 27) + E + X[s];
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp2;
            ++t;
        }
        H[0] = H[0] + A;
        H[1] = H[1] + B;
        H[2] = H[2] + C;
        H[3] = H[3] + D;
        H[4] = H[4] + E;
    }

    public static final int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    public static final int FF0(int B, int C, int D) {
        return B & C | ~B & D;
    }

    public static final int FF1(int B, int C, int D) {
        return B ^ C ^ D;
    }

    public static final int FF2(int B, int C, int D) {
        return B & C | B & D | C & D;
    }

    public Object clone() throws CloneNotSupportedException {
        SHA1 sha1 = new SHA1();
        System.arraycopy(this.H, 0, sha1.H, 0, this.H.length);
        System.arraycopy(this.X, 0, sha1.X, 0, this.X.length);
        sha1.count = this.count;
        System.arraycopy(this.buffer, 0, sha1.buffer, 0, this.buffer.length);
        return sha1;
    }
}

