/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;

public class SHA224
extends MessageDigest {
    private static final int ITERATION = 64;
    private static final int DIGEST_LENGTH = 28;
    private static final int[] ROUND_CONSTS = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int[] H;
    private int count;
    private int[] X = new int[64];
    private byte[] buffer;

    public SHA224() {
        super("SHA-224");
        this.H = new int[8];
        this.buffer = new byte[64];
        this.engineReset();
    }

    private static final int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset + 0] << 24 & 0xFF000000 | bytes[offset + 1] << 16 & 0xFF0000 | bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] << 0 & 0xFF;
    }

    private static final void intToBytes(byte[] bytes, int offset, int val) {
        bytes[offset + 0] = (byte)(val >>> 24 & 0xFF);
        bytes[offset + 1] = (byte)(val >>> 16 & 0xFF);
        bytes[offset + 2] = (byte)(val >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(val >>> 0 & 0xFF);
    }

    protected int _engineGetDigestLength() {
        return 28;
    }

    protected byte[] _engineDigest() {
        long bitLength = this.count << 3;
        this.engineUpdate((byte)-128);
        while ((this.count & 0x3F) != 56) {
            this.engineUpdate((byte)0);
        }
        for (int i = 0; i < 14; ++i) {
            this.X[i] = SHA224.bytesToInt(this.buffer, i * 4);
        }
        this.X[14] = (int)(bitLength >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.processBlock(this.H, this.X);
        byte[] digest = new byte[28];
        SHA224.intToBytes(digest, 0, this.H[0]);
        SHA224.intToBytes(digest, 4, this.H[1]);
        SHA224.intToBytes(digest, 8, this.H[2]);
        SHA224.intToBytes(digest, 12, this.H[3]);
        SHA224.intToBytes(digest, 16, this.H[4]);
        SHA224.intToBytes(digest, 20, this.H[5]);
        SHA224.intToBytes(digest, 24, this.H[6]);
        this.engineReset();
        return digest;
    }

    protected void _engineReset() {
        this.H[0] = -1056596264;
        this.H[1] = 914150663;
        this.H[2] = 812702999;
        this.H[3] = -150054599;
        this.H[4] = -4191439;
        this.H[5] = 1750603025;
        this.H[6] = 1694076839;
        this.H[7] = -1090891868;
        this.count = 0;
    }

    protected void _engineUpdate(byte b) {
        this.buffer[this.count & 0x3F] = b;
        if ((this.count & 0x3F) == 63) {
            for (int i = 0; i < 16; ++i) {
                this.X[i] = SHA224.bytesToInt(this.buffer, i * 4);
            }
            this.processBlock(this.H, this.X);
        }
        ++this.count;
    }

    protected void _engineUpdate(byte[] bytes, int offset, int length) {
        int i;
        int index = offset;
        while ((this.count & 0x3F) != 63 && length > 0) {
            this.engineUpdate(bytes[index++]);
            --length;
        }
        if (length == 0) {
            return;
        }
        this.engineUpdate(bytes[index++]);
        --length;
        while (length > 64) {
            for (i = 0; i < 16; ++i) {
                this.X[i] = SHA224.bytesToInt(bytes, index);
                index += 4;
            }
            this.count += 64;
            length -= 64;
            this.processBlock(this.H, this.X);
        }
        for (i = 0; i != length; ++i) {
            this.engineUpdate(bytes[i + index]);
        }
    }

    public final void processBlock(int[] H, int[] X) {
        for (int t = 16; t < 64; ++t) {
            X[t] = SHA224.delta1(X[t - 2]) + X[t - 7] + SHA224.delta0(X[t - 15]) + X[t - 16];
        }
        int a = H[0];
        int b = H[1];
        int c = H[2];
        int d = H[3];
        int e = H[4];
        int f = H[5];
        int g = H[6];
        int h = H[7];
        for (int i = 0; i < 64; ++i) {
            int T1 = h + SHA224.sigma1(e) + SHA224.ch(e, f, g) + ROUND_CONSTS[i] + X[i];
            int T2 = SHA224.sigma0(a) + SHA224.maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
        }
        H[0] = H[0] + a;
        H[1] = H[1] + b;
        H[2] = H[2] + c;
        H[3] = H[3] + d;
        H[4] = H[4] + e;
        H[5] = H[5] + f;
        H[6] = H[6] + g;
        H[7] = H[7] + h;
    }

    private static int ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private static int maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private static int R(int x, int s) {
        return x >>> s;
    }

    private static int S(int x, int s) {
        return x >>> s | x << 32 - s;
    }

    private static int sigma0(int x) {
        return SHA224.S(x, 2) ^ SHA224.S(x, 13) ^ SHA224.S(x, 22);
    }

    private static int sigma1(int x) {
        return SHA224.S(x, 6) ^ SHA224.S(x, 11) ^ SHA224.S(x, 25);
    }

    private static int delta0(int x) {
        return SHA224.S(x, 7) ^ SHA224.S(x, 18) ^ SHA224.R(x, 3);
    }

    private static int delta1(int x) {
        return SHA224.S(x, 17) ^ SHA224.S(x, 19) ^ SHA224.R(x, 10);
    }

    public Object clone() throws CloneNotSupportedException {
        SHA224 sha224 = new SHA224();
        System.arraycopy(this.H, 0, sha224.H, 0, this.H.length);
        System.arraycopy(this.X, 0, sha224.X, 0, this.X.length);
        sha224.count = this.count;
        System.arraycopy(this.buffer, 0, sha224.buffer, 0, this.buffer.length);
        return sha224;
    }
}

