/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;

public abstract class SHA3
extends MessageDigest {
    protected static final int SHA3_OK = 0;
    protected static final int SHA3_PARAMETER_ERROR = 1;
    protected static final int KECCAK_SPONGE_BIT = 1600;
    protected static final int KECCAK_ROUND = 24;
    protected static final int KECCAK_STATE_SIZE = 200;
    protected static final int KECCAK_SHA3_224 = 224;
    protected static final int KECCAK_SHA3_256 = 256;
    protected static final int KECCAK_SHA3_384 = 384;
    protected static final int KECCAK_SHA3_512 = 512;
    protected static final int KECCAK_SHA3_SUFFIX = 6;
    protected static final int[][] keccakf_rndc = new int[][]{{1, 0}, {32898, 0}, {32906, Integer.MIN_VALUE}, {-2147450880, Integer.MIN_VALUE}, {32907, 0}, {-2147483647, 0}, {-2147450751, Integer.MIN_VALUE}, {32777, Integer.MIN_VALUE}, {138, 0}, {136, 0}, {-2147450871, 0}, {-2147483638, 0}, {-2147450741, 0}, {139, Integer.MIN_VALUE}, {32905, Integer.MIN_VALUE}, {32771, Integer.MIN_VALUE}, {32770, Integer.MIN_VALUE}, {128, Integer.MIN_VALUE}, {32778, 0}, {-2147483638, Integer.MIN_VALUE}, {-2147450751, Integer.MIN_VALUE}, {32896, Integer.MIN_VALUE}, {-2147483647, 0}, {-2147450872, Integer.MIN_VALUE}};
    protected static final int[] keccakf_rotc = new int[]{1, 3, 6, 10, 15, 21, 28, 36, 45, 55, 2, 14, 27, 41, 56, 8, 25, 43, 62, 18, 39, 61, 20, 44};
    protected static final int[] keccakf_piln = new int[]{10, 7, 11, 17, 18, 3, 5, 16, 8, 21, 24, 4, 15, 23, 19, 13, 12, 2, 20, 14, 22, 9, 6, 1};

    public SHA3(String algorithm) {
        super(algorithm);
    }

    protected static void ROL64(int[] in, int[] out, int offset) {
        int mask = (1 << offset) - 1;
        int shift = 0;
        if (offset == 0) {
            out[1] = in[1];
            out[0] = in[0];
        } else if (offset < 32) {
            shift = offset;
            out[1] = in[1] << shift & ~mask ^ in[0] >> 32 - shift & mask;
            out[0] = in[0] << shift & ~mask ^ in[1] >> 32 - shift & mask;
        } else if (offset < 64) {
            shift = offset - 32;
            out[1] = in[0] << shift & ~mask ^ in[1] >> 32 - shift & mask;
            out[0] = in[1] << shift & ~mask ^ in[0] >> 32 - shift & mask;
        } else {
            out[1] = in[1];
            out[0] = in[0];
        }
    }

    protected static final void keccakf(byte[] state) {
        int i;
        int[] t = new int[2];
        int[][] bc = new int[5][2];
        int[][] s = new int[25][2];
        for (i = 0; i < 25; ++i) {
            s[i][0] = 0xFF & state[i * 8 + 0] | (0xFF & state[i * 8 + 1]) << 8 | (0xFF & state[i * 8 + 2]) << 16 | (0xFF & state[i * 8 + 3]) << 24;
            s[i][1] = 0xFF & state[i * 8 + 4] | (0xFF & state[i * 8 + 5]) << 8 | (0xFF & state[i * 8 + 6]) << 16 | (0xFF & state[i * 8 + 7]) << 24;
        }
        for (int round = 0; round < 24; ++round) {
            int j;
            for (i = 0; i < 5; ++i) {
                bc[i][0] = s[i][0] ^ s[i + 5][0] ^ s[i + 10][0] ^ s[i + 15][0] ^ s[i + 20][0];
                bc[i][1] = s[i][1] ^ s[i + 5][1] ^ s[i + 10][1] ^ s[i + 15][1] ^ s[i + 20][1];
            }
            for (i = 0; i < 5; ++i) {
                SHA3.ROL64(bc[(i + 1) % 5], t, 1);
                t[0] = t[0] ^ bc[(i + 4) % 5][0];
                t[1] = t[1] ^ bc[(i + 4) % 5][1];
                for (j = 0; j < 25; j += 5) {
                    int[] nArray = s[j + i];
                    nArray[0] = nArray[0] ^ t[0];
                    int[] nArray2 = s[j + i];
                    nArray2[1] = nArray2[1] ^ t[1];
                }
            }
            t[0] = s[1][0];
            t[1] = s[1][1];
            for (i = 0; i < 24; ++i) {
                j = keccakf_piln[i];
                bc[0][0] = s[j][0];
                bc[0][1] = s[j][1];
                SHA3.ROL64(t, s[j], keccakf_rotc[i]);
                t[0] = bc[0][0];
                t[1] = bc[0][1];
            }
            for (j = 0; j < 25; j += 5) {
                for (i = 0; i < 5; ++i) {
                    bc[i][0] = s[j + i][0];
                    bc[i][1] = s[j + i][1];
                }
                for (i = 0; i < 5; ++i) {
                    int[] nArray = s[j + i];
                    nArray[0] = nArray[0] ^ ~bc[(i + 1) % 5][0] & bc[(i + 2) % 5][0];
                    int[] nArray3 = s[j + i];
                    nArray3[1] = nArray3[1] ^ ~bc[(i + 1) % 5][1] & bc[(i + 2) % 5][1];
                }
            }
            int[] nArray = s[0];
            nArray[0] = nArray[0] ^ keccakf_rndc[round][0];
            int[] nArray4 = s[0];
            nArray4[1] = nArray4[1] ^ keccakf_rndc[round][1];
        }
        for (i = 0; i < 25; ++i) {
            state[i * 8 + 0] = (byte)(s[i][0] & 0xFF);
            state[i * 8 + 1] = (byte)(s[i][0] >> 8 & 0xFF);
            state[i * 8 + 2] = (byte)(s[i][0] >> 16 & 0xFF);
            state[i * 8 + 3] = (byte)(s[i][0] >> 24 & 0xFF);
            state[i * 8 + 4] = (byte)(s[i][1] & 0xFF);
            state[i * 8 + 5] = (byte)(s[i][1] >> 8 & 0xFF);
            state[i * 8 + 6] = (byte)(s[i][1] >> 16 & 0xFF);
            state[i * 8 + 7] = (byte)(s[i][1] >> 24 & 0xFF);
        }
    }

    protected void keccak_squeeze(byte[] keccak_state, byte[] output, int end_offset, int outLen, int rate, int suffix) {
        int offset = 0;
        int oLen = outLen;
        int rateInBytes = rate / 8;
        int blockSize = end_offset;
        int i = 0;
        int n = blockSize;
        keccak_state[n] = (byte)(keccak_state[n] ^ suffix);
        if ((suffix & 0x80) != 0 && blockSize == rateInBytes - 1) {
            SHA3.keccakf(keccak_state);
        }
        int n2 = rateInBytes - 1;
        keccak_state[n2] = (byte)(keccak_state[n2] ^ 0x80);
        SHA3.keccakf(keccak_state);
        offset = 0;
        while (oLen > 0) {
            blockSize = oLen < rateInBytes ? oLen : rateInBytes;
            for (i = 0; i < blockSize; ++i) {
                output[i + offset] = keccak_state[i];
            }
            offset += blockSize;
            if ((oLen -= blockSize) <= 0) continue;
            SHA3.keccakf(keccak_state);
        }
    }
}

