/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.cryptox.MessageDigest;

public class SHA384
extends MessageDigest {
    private static final int BYTE_LENGTH = 128;
    private static final int DIGEST_LENGTH = 48;
    private byte[] xBuf;
    private int xBufOff = 0;
    private long byteCount1;
    private long byteCount2;
    protected long H1;
    protected long H2;
    protected long H3;
    protected long H4;
    protected long H5;
    protected long H6;
    protected long H7;
    protected long H8;
    private long[] W = new long[80];
    private int wOff;
    private static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    public SHA384() {
        super("SHA-384");
        this.xBuf = new byte[8];
        this.engineReset();
    }

    private static final void longToBytes(byte[] bytes, int offset, long val) {
        bytes[offset + 0] = (byte)(val >>> 56 & 0xFFL);
        bytes[offset + 1] = (byte)(val >>> 48 & 0xFFL);
        bytes[offset + 2] = (byte)(val >>> 40 & 0xFFL);
        bytes[offset + 3] = (byte)(val >>> 32 & 0xFFL);
        bytes[offset + 4] = (byte)(val >>> 24 & 0xFFL);
        bytes[offset + 5] = (byte)(val >>> 16 & 0xFFL);
        bytes[offset + 6] = (byte)(val >>> 8 & 0xFFL);
        bytes[offset + 7] = (byte)(val >>> 0 & 0xFFL);
    }

    protected void unpackWord(long word, byte[] out, int outOff) {
        out[outOff] = (byte)(word >>> 56);
        out[outOff + 1] = (byte)(word >>> 48);
        out[outOff + 2] = (byte)(word >>> 40);
        out[outOff + 3] = (byte)(word >>> 32);
        out[outOff + 4] = (byte)(word >>> 24);
        out[outOff + 5] = (byte)(word >>> 16);
        out[outOff + 6] = (byte)(word >>> 8);
        out[outOff + 7] = (byte)word;
    }

    private void adjustByteCounts() {
        if (this.byteCount1 > 0x1FFFFFFFFFFFFFFFL) {
            this.byteCount2 += this.byteCount1 >>> 61;
            this.byteCount1 &= 0x1FFFFFFFFFFFFFFFL;
        }
    }

    protected void processLength(long lowW, long hiW) {
        if (this.wOff > 14) {
            this.processBlock();
        }
        this.W[14] = hiW;
        this.W[15] = lowW;
    }

    protected int _engineGetDigestLength() {
        return 48;
    }

    protected void processWord(byte[] in, int inOff) {
        this.W[this.wOff++] = (long)(in[inOff] & 0xFF) << 56 | (long)(in[inOff + 1] & 0xFF) << 48 | (long)(in[inOff + 2] & 0xFF) << 40 | (long)(in[inOff + 3] & 0xFF) << 32 | (long)(in[inOff + 4] & 0xFF) << 24 | (long)(in[inOff + 5] & 0xFF) << 16 | (long)(in[inOff + 6] & 0xFF) << 8 | (long)(in[inOff + 7] & 0xFF);
        if (this.wOff == 16) {
            this.processBlock();
        }
    }

    protected byte[] _engineDigest() {
        this.finish();
        byte[] digest = new byte[48];
        SHA384.longToBytes(digest, 0, this.H1);
        SHA384.longToBytes(digest, 8, this.H2);
        SHA384.longToBytes(digest, 16, this.H3);
        SHA384.longToBytes(digest, 24, this.H4);
        SHA384.longToBytes(digest, 32, this.H5);
        SHA384.longToBytes(digest, 40, this.H6);
        this.engineReset();
        return digest;
    }

    public void finish() {
        this.adjustByteCounts();
        long lowBitLength = this.byteCount1 << 3;
        long hiBitLength = this.byteCount2;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(lowBitLength, hiBitLength);
        this.processBlock();
    }

    protected void _engineReset() {
        this.H1 = -3766243637369397544L;
        this.H2 = 7105036623409894663L;
        this.H3 = -7973340178411365097L;
        this.H4 = 1526699215303891257L;
        this.H5 = 7436329637833083697L;
        this.H6 = -8163818279084223215L;
        this.H7 = -2662702644619276377L;
        this.H8 = 5167115440072839076L;
        this.byteCount1 = 0L;
        this.byteCount2 = 0L;
    }

    protected void _engineUpdate(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount1;
    }

    protected void _engineUpdate(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            this.processWord(in, inOff);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount1 += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    public void processBlock() {
        int i;
        this.adjustByteCounts();
        for (int t = 16; t <= 79; ++t) {
            this.W[t] = this.Sigma1(this.W[t - 2]) + this.W[t - 7] + this.Sigma0(this.W[t - 15]) + this.W[t - 16];
        }
        long a = this.H1;
        long b = this.H2;
        long c = this.H3;
        long d = this.H4;
        long e = this.H5;
        long f = this.H6;
        long g = this.H7;
        long h = this.H8;
        int t = 0;
        for (i = 0; i < 10; ++i) {
            long l = this.Sum1(e) + SHA384.ch(e, f, g) + K[t];
            int n = t++;
            h += this.Sum0(a) + SHA384.maj(a, b, c);
            long l2 = this.Sum1(d += (h += l + this.W[n])) + SHA384.ch(d, e, f) + K[t];
            int n2 = t++;
            g += this.Sum0(h) + SHA384.maj(h, a, b);
            long l3 = this.Sum1(c += (g += l2 + this.W[n2])) + SHA384.ch(c, d, e) + K[t];
            int n3 = t++;
            f += this.Sum0(g) + SHA384.maj(g, h, a);
            long l4 = this.Sum1(b += (f += l3 + this.W[n3])) + SHA384.ch(b, c, d) + K[t];
            int n4 = t++;
            e += this.Sum0(f) + SHA384.maj(f, g, h);
            long l5 = this.Sum1(a += (e += l4 + this.W[n4])) + SHA384.ch(a, b, c) + K[t];
            int n5 = t++;
            d += this.Sum0(e) + SHA384.maj(e, f, g);
            long l6 = this.Sum1(h += (d += l5 + this.W[n5])) + SHA384.ch(h, a, b) + K[t];
            int n6 = t++;
            c += this.Sum0(d) + SHA384.maj(d, e, f);
            long l7 = this.Sum1(g += (c += l6 + this.W[n6])) + SHA384.ch(g, h, a) + K[t];
            int n7 = t++;
            b += this.Sum0(c) + SHA384.maj(c, d, e);
            e += (a += this.Sum1(f += (b += l7 + this.W[n7])) + SHA384.ch(f, g, h) + K[t] + this.W[t++]);
            a += this.Sum0(b) + SHA384.maj(b, c, d);
        }
        this.H1 += a;
        this.H2 += b;
        this.H3 += c;
        this.H4 += d;
        this.H5 += e;
        this.H6 += f;
        this.H7 += g;
        this.H8 += h;
        this.wOff = 0;
        for (i = 0; i < 16; ++i) {
            this.W[i] = 0L;
        }
    }

    private long Sum0(long x) {
        return (x << 36 | x >>> 28) ^ (x << 30 | x >>> 34) ^ (x << 25 | x >>> 39);
    }

    private long Sum1(long x) {
        return (x << 50 | x >>> 14) ^ (x << 46 | x >>> 18) ^ (x << 23 | x >>> 41);
    }

    private long Sigma0(long x) {
        return (x << 63 | x >>> 1) ^ (x << 56 | x >>> 8) ^ x >>> 7;
    }

    private long Sigma1(long x) {
        return (x << 45 | x >>> 19) ^ (x << 3 | x >>> 61) ^ x >>> 6;
    }

    private static long ch(long x, long y, long z) {
        return x & y ^ (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private static long maj(long x, long y, long z) {
        return x & y ^ x & z ^ y & z;
    }

    public Object clone() throws CloneNotSupportedException {
        SHA384 sha384 = new SHA384();
        sha384.H1 = this.H1;
        sha384.H2 = this.H2;
        sha384.H3 = this.H3;
        sha384.H4 = this.H4;
        sha384.H5 = this.H5;
        sha384.H6 = this.H6;
        sha384.H7 = this.H7;
        sha384.H8 = this.H8;
        sha384.xBufOff = this.xBufOff;
        System.arraycopy(this.xBuf, 0, sha384.xBuf, 0, this.xBuf.length);
        sha384.byteCount1 = this.byteCount1;
        sha384.byteCount2 = this.byteCount2;
        System.arraycopy(this.W, 0, sha384.W, 0, this.W.length);
        sha384.wOff = this.wOff;
        return sha384;
    }
}

