/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.provider.crypto.SelfTest;
import com.initech.provider.crypto.md.SHA3;
import java.util.Arrays;

public class SHA3_224
extends SHA3 {
    private static final int DIGEST_LENGTH = 28;
    private static final int Rate = 1152;
    private static final int Block_Size = 144;
    protected byte[] state = new byte[200];
    protected int end_offset;
    protected int count;

    public SHA3_224() {
        super("SHA3-224");
        SelfTest.checkKSXRunnable();
        this._engineReset();
    }

    protected int _engineGetDigestLength() {
        return 28;
    }

    protected byte[] _engineDigest() {
        byte[] digest = new byte[28];
        int outLen = this._engineGetDigestLength();
        this.keccak_squeeze(this.state, digest, this.end_offset, outLen, 1152, 6);
        this.engineReset();
        return digest;
    }

    protected void _engineReset() {
        this.end_offset = 0;
        this.count = 0;
        if (this.state != null) {
            Arrays.fill(this.state, (byte)0);
        }
    }

    protected void _engineUpdate(byte b) {
        byte[] bytes = new byte[]{b};
        this.engineUpdate(bytes, 0, 1);
    }

    protected void _engineUpdate(byte[] bytes, int offset, int length) {
        int iLen = length;
        int blockSize = 0;
        int i = 0;
        while (iLen > 0) {
            if (this.end_offset != 0 && this.end_offset < 144) {
                blockSize = iLen + this.end_offset < 144 ? iLen + this.end_offset : 144;
                for (i = this.end_offset; i < blockSize; ++i) {
                    int n = i;
                    this.state[n] = (byte)(this.state[n] ^ bytes[offset + i - this.end_offset]);
                }
                offset += blockSize - this.end_offset;
                iLen -= blockSize - this.end_offset;
            } else {
                blockSize = iLen < 144 ? iLen : 144;
                for (i = 0; i < blockSize; ++i) {
                    int n = i;
                    this.state[n] = (byte)(this.state[n] ^ bytes[offset + i]);
                }
                offset += blockSize;
                iLen -= blockSize;
            }
            if (blockSize == 144) {
                SHA3_224.keccakf(this.state);
                blockSize = 0;
            }
            this.end_offset = blockSize;
        }
    }
}

