/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.md;

import com.initech.provider.crypto.SelfTest;
import com.initech.provider.crypto.md.SHA3;
import java.util.Arrays;

public class SHA3_256
extends SHA3 {
    private static final int DIGEST_LENGTH = 32;
    private static final int Rate = 1088;
    private static final int Block_Size = 136;
    protected byte[] state = new byte[200];
    protected int end_offset;
    protected int count;

    public SHA3_256() {
        super("SHA3-256");
        SelfTest.checkKSXRunnable();
        this._engineReset();
    }

    protected int _engineGetDigestLength() {
        return 32;
    }

    protected byte[] _engineDigest() {
        byte[] digest = new byte[32];
        int outLen = this._engineGetDigestLength();
        this.keccak_squeeze(this.state, digest, this.end_offset, outLen, 1088, 6);
        this.engineReset();
        return digest;
    }

    protected void _engineReset() {
        this.end_offset = 0;
        this.count = 0;
        if (this.state != null) {
            Arrays.fill(this.state, (byte)0);
        }
    }

    protected void _engineUpdate(byte b) {
        byte[] bytes = new byte[]{b};
        this.engineUpdate(bytes, 0, 1);
    }

    protected void _engineUpdate(byte[] bytes, int offset, int length) {
        int iLen = length;
        int blockSize = 0;
        int i = 0;
        while (iLen > 0) {
            if (this.end_offset != 0 && this.end_offset < 136) {
                blockSize = iLen + this.end_offset < 136 ? iLen + this.end_offset : 136;
                for (i = this.end_offset; i < blockSize; ++i) {
                    int n = i;
                    this.state[n] = (byte)(this.state[n] ^ bytes[offset + i - this.end_offset]);
                }
                offset += blockSize - this.end_offset;
                iLen -= blockSize - this.end_offset;
            } else {
                blockSize = iLen < 136 ? iLen : 136;
                for (i = 0; i < blockSize; ++i) {
                    int n = i;
                    this.state[n] = (byte)(this.state[n] ^ bytes[offset + i]);
                }
                offset += blockSize;
                iLen -= blockSize;
            }
            if (blockSize == 136) {
                SHA3_256.keccakf(this.state);
                blockSize = 0;
            }
            this.end_offset = blockSize;
        }
    }
}

