/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.pkcs12;

import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBKDF;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.util.Arrays;

public class PBKDFForPKCS12
extends PBKDF {
    public static final byte KEY_MATERIAL = 1;
    public static final byte INITIAL_VECTOR = 2;
    public static final byte MAC_KEY_MATERIAL = 3;

    private int ceil(int sp, int v) {
        int ret = sp / v;
        if (sp % v != 0) {
            ++ret;
        }
        return ret;
    }

    public void genI(byte[] src, byte[] tgt, int offset, int splen) {
        int j = 0;
        for (int i = offset; i < splen + offset; ++i) {
            tgt[i] = src[j++];
            if (j < src.length) continue;
            j = 0;
        }
    }

    public byte[] process(PBEKey pbeKey, javax.crypto.spec.PBEParameterSpec pbeParameter_j, MessageDigest messageDigest, int derivedKeyLength, byte purpose) throws InvalidParameterException {
        PBEParameterSpec pbeParameter = (PBEParameterSpec)AutoJCE.toJCEX(pbeParameter_j);
        return this.process(pbeKey, pbeParameter, messageDigest, derivedKeyLength, purpose);
    }

    public byte[] process(PBEKey pbeKey, PBEParameterSpec pbeParameter, MessageDigest messageDigest, int derivedKeyLength, byte purpose) throws InvalidParameterException {
        int v;
        int u;
        this.setSalt(pbeParameter.getSalt());
        this.setIterationCount(pbeParameter.getIterationCount());
        this.setDerivedKeyLength(derivedKeyLength);
        this.setPassword(pbeKey);
        int s = this.salt.length;
        int p = this.password.length;
        if (messageDigest.getAlgorithm().equals("SHA1")) {
            u = 20;
            v = 64;
        } else if (messageDigest.getAlgorithm().equals("MD5") || messageDigest.getAlgorithm().equals("MD2")) {
            u = 16;
            v = 64;
        } else {
            u = 20;
            v = 64;
        }
        int slen = v * this.ceil(s, v);
        int plen = v * this.ceil(p, v);
        byte[] DI = new byte[v + slen + plen];
        for (int i = 0; i < v; ++i) {
            DI[i] = purpose;
        }
        this.genI(this.salt, DI, v, slen);
        this.genI(this.password, DI, slen + v, plen);
        int c = this.ceil(this.dkLen, u);
        int k = this.ceil(s, v) + this.ceil(p, v);
        byte[] Ij = new byte[v];
        byte[] B = new byte[v];
        BigInteger ONE = new BigInteger("1");
        byte[] keymaterial = new byte[this.dkLen];
        int m = 0;
        for (int i = 0; i < c; ++i) {
            byte[] digested = messageDigest.digest(DI);
            for (int j = 1; j < this.iterationCount; ++j) {
                digested = messageDigest.digest(digested);
            }
            if (digested.length > this.dkLen - m) {
                System.arraycopy(digested, 0, keymaterial, m, this.dkLen - m);
                m += this.dkLen - m;
            } else {
                System.arraycopy(digested, 0, keymaterial, m, digested.length);
                m += digested.length;
            }
            if (this.dkLen - m == 0) break;
            this.genI(digested, B, 0, v);
            BigInteger BB = new BigInteger(1, B);
            BB = BB.add(ONE);
            for (int j = 0; j < k; ++j) {
                System.arraycopy(DI, v + j * v, Ij, 0, v);
                BigInteger I = new BigInteger(1, Ij);
                I = I.add(BB);
                byte[] itemp = I.toByteArray();
                if (itemp.length > v) {
                    System.arraycopy(itemp, 1, DI, v + j * v, v);
                    continue;
                }
                if (itemp.length < v) {
                    System.arraycopy(itemp, 0, DI, v + j * v + v - itemp.length, itemp.length);
                    for (int l = 0; l < v - itemp.length; ++l) {
                        DI[v + j * v + l] = 0;
                    }
                    continue;
                }
                System.arraycopy(itemp, 0, DI, v + j * v, v);
            }
        }
        Arrays.fill(Ij, (byte)0);
        Arrays.fill(DI, (byte)0);
        Arrays.fill(this.password, (byte)0);
        return keymaterial;
    }

    public byte[] process() {
        return null;
    }
}

