/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.random;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.SecureRandomSpi;
import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.random.HashDRBG;
import com.initech.provider.crypto.random.XSeeder;
import java.math.BigInteger;
import java.util.Arrays;

public class FIPS186_2Appendix3
extends SecureRandomSpi
implements Zeroizable {
    private static final long serialVersionUID = 1901299646485917488L;
    byte[] xkey = new byte[20];
    byte[] xseed = new byte[20];
    byte[] block = new byte[20];
    int blockRemaining = 0;
    byte[] previous_block = null;
    boolean isInit = false;
    XSeeder xseeder;
    BigInteger q;

    public FIPS186_2Appendix3() {
        this((XSeeder)null);
    }

    public FIPS186_2Appendix3(XSeeder xseeder) {
        this.xseeder = xseeder;
    }

    public void setQ(byte[] q) {
        this.q = new BigInteger(1, q);
    }

    public void setXKey(byte[] newxkey) {
        System.arraycopy(newxkey, 0, this.xkey, 0, 20);
        this.previous_block = null;
        this.newblock();
        this.blockRemaining = 0;
        this.isInit = true;
    }

    private void setXSeed(byte[] xseed) {
        System.arraycopy(xseed, 0, xseed, 0, 20);
    }

    private static byte[] integers2bytes(int[] integers) {
        byte[] bytes = new byte[integers.length * 4];
        for (int i = 0; i < integers.length; ++i) {
            int j = integers[i];
            for (int k = 0; k < 4; ++k) {
                bytes[i * 4 + k] = (byte)(j >>> 24 - k * 8);
            }
        }
        return bytes;
    }

    private static int[] bytes2integers(byte[] bytes) {
        int[] integers = new int[bytes.length / 4];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = (bytes[i * 4] & 0xFF) << 24 | (bytes[i * 4 + 1] & 0xFF) << 16 | (bytes[i * 4 + 2] & 0xFF) << 8 | bytes[i * 4 + 3] & 0xFF;
        }
        return integers;
    }

    public byte[] getPreviousBlock() {
        byte[] ret = new byte[20];
        if (this.previous_block != null) {
            if (this.q == null) {
                System.arraycopy(this.previous_block, 0, ret, 0, 20);
            } else {
                BigInteger x = new BigInteger(1, this.previous_block);
                byte[] temp = x.mod(this.q).toByteArray();
                for (int i = 0; i < 20 && i < temp.length; ++i) {
                    ret[ret.length - 1 - i] = temp.length - 1 - i >= 0 ? temp[temp.length - 1 - i] : (byte)0;
                }
            }
            return ret;
        }
        throw new RuntimeException("\u73e5?\ub9b0????? ?\uba84???? ??????.");
    }

    private void newblock() {
        int i;
        byte[] xval = new byte[64];
        int[] t = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        if (this.xseeder != null && this.isInit) {
            this.setXSeed(this.xseeder.getXseed());
        }
        int carry = 0;
        for (i = 19; i >= 0; --i) {
            int sum = carry + (this.xkey[i] & 0xFF) + (this.xseed[i] & 0xFF);
            xval[i] = (byte)(sum & 0xFF);
            carry = sum >> 8;
            this.xseed[i] = 0;
        }
        for (i = 20; i < 64; ++i) {
            xval[i] = 0;
        }
        int[] intXval = FIPS186_2Appendix3.bytes2integers(xval);
        new SHA1().processBlock(t, intXval);
        this.block = FIPS186_2Appendix3.integers2bytes(t);
        carry = 1;
        for (i = 19; i >= 0; --i) {
            int sum = carry + (this.xkey[i] & 0xFF) + (this.block[i] & 0xFF);
            this.xkey[i] = (byte)(sum & 0xFF);
            carry = sum >> 8;
        }
        if (this.previous_block == null) {
            this.previous_block = new byte[20];
        } else if (Arrays.equals(this.previous_block, this.block)) {
            throw new KSXRuntimeException("Continuous Random Number Generation Check failed");
        }
        System.arraycopy(this.block, 0, this.previous_block, 0, 20);
        this.blockRemaining = 20;
    }

    private void autoseed() {
        byte[] newkey = new byte[64];
        try {
            HashDRBG random = new HashDRBG("SHA224");
            random.nextBytes(newkey);
        }
        catch (Exception e) {
            throw new RuntimeException("fail to generate salt");
        }
        this.seed(newkey);
    }

    private void seed(byte[] newSeed) {
        SHA1 sha1 = new SHA1();
        this.xkey = sha1.digest(newSeed);
        this.setXKey(this.xkey);
    }

    public void nextBytes(byte[] out) {
        if (!this.isInit) {
            this.autoseed();
        }
        int n = out.length;
        int pos = 0;
        while (n > 0) {
            int remaining;
            if (this.blockRemaining == 0) {
                this.newblock();
            }
            if ((remaining = this.blockRemaining) > n) {
                remaining = n;
            }
            System.arraycopy(this.block, 20 - this.blockRemaining, out, pos, remaining);
            pos += remaining;
            n -= remaining;
            this.blockRemaining -= remaining;
        }
    }

    protected byte[] _engineGenerateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        this.nextBytes(seed);
        return seed;
    }

    protected void _engineNextBytes(byte[] bytes) {
        this.nextBytes(bytes);
    }

    protected void _engineSetSeed(byte[] seed) {
        this.setXKey(seed);
    }

    public static void main(String[] args) {
        byte[] b = new byte[20];
        FIPS186_2Appendix3 f = new FIPS186_2Appendix3();
        f.nextBytes(b);
    }

    public void zeroize() {
        int i;
        for (i = 0; i < this.xkey.length; ++i) {
            this.xkey[i] = 0;
        }
        for (i = 0; i < this.xseed.length; ++i) {
            this.xseed[i] = 0;
        }
    }
}

