/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.random;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.SecureRandomSpi;
import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.SelfTest;
import com.initech.provider.crypto.entropy.Entropy;
import com.initech.provider.crypto.entropy.EntropyAdapter;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA512;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;

public class HashDRBG
extends SecureRandomSpi
implements Zeroizable {
    private static final long serialVersionUID = -2030696988394229401L;
    private static final int BITS_PER_BYTE = 8;
    private static final int ONE_BYTE = 1;
    private static final int SHORT_SIZE_BYTE = 2;
    private static final int CHAR_SIZE_BYTE = 2;
    private static final int INT_SIZE_BYTES = 4;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int LONG_SIZE_BYTES = 8;
    private static final int DOUBLE_SIZE_BYTES = 8;
    private String hashAlgrithm;
    private String hashDrbgAlg;
    private int drbgMaxLength = 0x20000000;
    private int securityStrength = 0;
    private int seedLen = 0;
    private int outLen = 0;
    private int minEntropyLen = 0;
    private int maxEntropyLen = 0;
    private int minNonceLen = 0;
    private int maxNonceLen = 0;
    private int maxPersonalStringLen = 0;
    private int maxAdditionalInputLen = 0;
    private int maxRequestnumberOfBytes = 524288;
    private int maxReseedInterval = 100000000;
    private boolean predictionResistanceFlag = false;
    private int predictionResistanceRequest = 0;
    private int reseedCounter = 0;
    private int entropyOutputLen = 0;
    private int collectionEntropyMode = 0;
    private transient ByteBuffer V;
    private transient ByteBuffer C;
    private transient HashDf hdf;
    private transient MessageDigest md;
    private Entropy ent = new EntropyAdapter();
    private boolean entInitFlag = false;
    private byte[] rbg_block = null;
    private int i = 0;

    public HashDRBG() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashDRBG(String hashAlg) {
        HashDRBG hashDRBG = this;
        synchronized (hashDRBG) {
            String strTemp = "HASHDRBG" + hashAlg;
            if (!strTemp.equals(this.hashDrbgAlg) || !this.entInitFlag) {
                this.hashDrbgAlg = "HASHDRBG" + hashAlg;
                this.initHashDRBG(this.hashDrbgAlg);
                boolean predictionResistanceFlag = false;
                this.predictionResistanceRequest = 0;
                int requestedInstantiationSecurityStrength = this.securityStrength;
                ByteBuffer personalizationString = null;
                int shaBaseEntropyOutputLenInfo = this.outLen;
                int collectionEntropyModeInfo = InitechProvider.isProvenMode() ? 2 : 0;
                this.instantiateHashDRBG(predictionResistanceFlag, requestedInstantiationSecurityStrength, personalizationString, shaBaseEntropyOutputLenInfo, collectionEntropyModeInfo);
                this.entInitFlag = true;
            }
        }
    }

    public HashDRBG(String hashDrbgAlg, int requestNoOfBytes, int collectionEntropyMode, byte[] generatedDRBG) {
        this.initHashDRBG(hashDrbgAlg);
        this.instantiateHashDRBG(true, this.securityStrength, null, this.outLen, collectionEntropyMode);
        this.generateHashDRBG(requestNoOfBytes, this.securityStrength, 1, null);
        System.arraycopy(this.generateHashDRBG(requestNoOfBytes, this.securityStrength, 1, null), 0, generatedDRBG, 0, requestNoOfBytes);
    }

    public HashDRBG(String hashDrbgAlg, boolean predictionResistanceFlag, int requestNoOfBytes, int collectionEntropyMode, int predictionResistanceRequest, byte[] generatedDRBG) {
        this.initHashDRBG(hashDrbgAlg);
        this.instantiateHashDRBG(predictionResistanceFlag, this.securityStrength, null, this.outLen, collectionEntropyMode);
        System.arraycopy(this.generateHashDRBG(requestNoOfBytes, this.securityStrength, predictionResistanceRequest, null), 0, generatedDRBG, 0, requestNoOfBytes);
    }

    public void nextBytes(byte[] bytes) throws Exception {
        if (SelfTest.getState() == 3 && this.hashAlgrithm.equals("SHA1")) {
            throw new KSXRuntimeException("do not supported hashDRBG SHA1");
        }
        this.nextBytes(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] bytes, int offSet, int len) throws Exception {
        HashDRBG hashDRBG = this;
        synchronized (hashDRBG) {
            int requestNumberOfBytes = bytes.length;
            ByteBuffer additionalInput = null;
            byte[] drbgRAND1 = null;
            byte[] drbgRAND2 = null;
            drbgRAND1 = this.generateHashDRBG(requestNumberOfBytes, this.securityStrength, this.predictionResistanceRequest, additionalInput);
            drbgRAND2 = this.generateHashDRBG(requestNumberOfBytes, this.securityStrength, this.predictionResistanceRequest, additionalInput);
            if (Arrays.equals(drbgRAND1, drbgRAND2)) {
                bytes = null;
                throw new KSXRuntimeException("Random value is equal with previous random");
            }
            System.arraycopy(drbgRAND1, 0, bytes, 0, len);
        }
    }

    protected byte[] _engineGenerateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        try {
            this.nextBytes(seed);
        }
        catch (Exception e) {
            seed = null;
        }
        return seed;
    }

    protected void _engineNextBytes(byte[] bytes) {
        try {
            this.nextBytes(bytes);
        }
        catch (Exception e) {
            bytes = null;
        }
    }

    protected void _engineSetSeed(byte[] seed) {
    }

    protected final void initHashDRBG(String hashDrbgAlgName) {
        try {
            if (hashDrbgAlgName.equals("HASHDRBGSHA1") || hashDrbgAlgName.equals("HASHDRBGSHA-1")) {
                this.securityStrength = 10;
                this.seedLen = 55;
                this.outLen = 20;
                this.hashAlgrithm = "SHA1";
                this.md = new SHA1();
            } else if (hashDrbgAlgName.equals("HASHDRBGSHA224") || hashDrbgAlgName.equals("HASHDRBGSHA-224")) {
                this.securityStrength = 14;
                this.seedLen = 55;
                this.outLen = 28;
                this.hashAlgrithm = "SHA224";
                this.md = new SHA224();
            } else if (hashDrbgAlgName.equals("HASHDRBGSHA256") || hashDrbgAlgName.equals("HASHDRBGSHA-256")) {
                this.securityStrength = 16;
                this.seedLen = 55;
                this.outLen = 32;
                this.hashAlgrithm = "SHA256";
                this.md = new SHA256();
            } else if (hashDrbgAlgName.equals("HASHDRBGSHA384") || hashDrbgAlgName.equals("HASHDRBGSHA-384")) {
                this.securityStrength = 24;
                this.seedLen = 111;
                this.outLen = 48;
                this.hashAlgrithm = "SHA384";
                this.md = new SHA384();
            } else if (hashDrbgAlgName.equals("HASHDRBGSHA512") || hashDrbgAlgName.equals("HASHDRBGSHA-512")) {
                this.securityStrength = 32;
                this.seedLen = 111;
                this.outLen = 64;
                this.hashAlgrithm = "SHA512";
                this.md = new SHA512();
            }
            this.minEntropyLen = this.securityStrength;
            this.maxEntropyLen = this.drbgMaxLength;
            this.minNonceLen = this.minEntropyLen / 2;
            this.maxNonceLen = this.drbgMaxLength;
            this.maxPersonalStringLen = this.drbgMaxLength;
            this.maxAdditionalInputLen = this.drbgMaxLength;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void unInstantiateHashDRBG() {
        this.zeroize();
        this.V = ByteBuffer.allocate(0);
        this.C = ByteBuffer.allocate(0);
        this.reseedCounter = 0;
    }

    private byte[] getEntropyAndCondition(int entropyOutputLen, int collectionEntropyMode, int securityStrength, int maxEntropyLen, String hashAlgrithm, int noncePluseFlag) throws Exception {
        return this.ent.collection(hashAlgrithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected final String instantiateHashDRBG(boolean predictionResistanceFlagInfo, int requestedInstantiationSecurityStrength, ByteBuffer personalizationString, int entropyOutputLenInfo, int collectionEntropyModeInfo) {
        block17: {
            byte[] nonceBytes;
            block16: {
                int persnBytesLen;
                byte[] entropy;
                block14: {
                    String string;
                    block15: {
                        entropy = null;
                        nonceBytes = null;
                        this.predictionResistanceFlag = predictionResistanceFlagInfo;
                        this.entropyOutputLen = this.outLen;
                        this.collectionEntropyMode = collectionEntropyModeInfo;
                        this.hdf = new HashDf();
                        int noncePluseFlag = 1;
                        ByteBuffer collectedEntropy = ByteBuffer.allocate(entropyOutputLenInfo + entropyOutputLenInfo / 2);
                        byte[] entData = this.getEntropyAndCondition(this.entropyOutputLen, this.collectionEntropyMode, this.securityStrength, this.maxEntropyLen, this.hashAlgrithm, noncePluseFlag);
                        collectedEntropy.put(entData);
                        collectedEntropy.rewind();
                        Arrays.fill(entData, (byte)0);
                        entropy = new byte[this.entropyOutputLen];
                        collectedEntropy.get(entropy, 0, this.entropyOutputLen);
                        nonceBytes = new byte[this.entropyOutputLen / 2];
                        collectedEntropy.get(nonceBytes, 0, this.entropyOutputLen / 2);
                        persnBytesLen = 0;
                        if (personalizationString == null) {
                            persnBytesLen = 0;
                            break block14;
                        }
                        personalizationString.rewind();
                        persnBytesLen = personalizationString.remaining();
                        if (persnBytesLen <= this.maxPersonalStringLen) break block14;
                        string = "personalization String too long";
                        this.hdf.reset();
                        if (entropy == null) break block15;
                        Arrays.fill(entropy, (byte)0);
                    }
                    if (nonceBytes != null) {
                        Arrays.fill(nonceBytes, (byte)0);
                    }
                    return string;
                }
                try {
                    ByteBuffer seedMaterial = ByteBuffer.allocate(entropy.length + nonceBytes.length + persnBytesLen);
                    if (persnBytesLen == 0) {
                        seedMaterial.put(entropy);
                        seedMaterial.put(nonceBytes);
                    } else {
                        seedMaterial.put(entropy);
                        seedMaterial.put(nonceBytes);
                        seedMaterial.put(personalizationString);
                    }
                    seedMaterial.rewind();
                    this.instantiateReseedVCEngine(seedMaterial);
                    seedMaterial = ByteBuffer.allocate(entropy.length + nonceBytes.length + persnBytesLen);
                    seedMaterial.clear();
                    this.hdf.reset();
                    if (entropy == null) break block16;
                }
                catch (Exception e) {
                    this.hdf.reset();
                    if (entropy != null) {
                        Arrays.fill(entropy, (byte)0);
                    }
                    if (nonceBytes != null) {
                        Arrays.fill(nonceBytes, (byte)0);
                    }
                    break block17;
                    catch (Throwable throwable) {
                        this.hdf.reset();
                        if (entropy != null) {
                            Arrays.fill(entropy, (byte)0);
                        }
                        if (nonceBytes != null) {
                            Arrays.fill(nonceBytes, (byte)0);
                        }
                        throw throwable;
                    }
                }
                Arrays.fill(entropy, (byte)0);
            }
            if (nonceBytes != null) {
                Arrays.fill(nonceBytes, (byte)0);
            }
        }
        return "Success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String instantiateHashDRBG(boolean predictionResistanceFlagVS, int EntropyInputLen, ByteBuffer EntropyInputVS, int NonceLen, ByteBuffer NonceVS, int PersonalizationStringLen, ByteBuffer PersonalizationStringVS) {
        try {
            this.hdf = new HashDf();
            this.predictionResistanceFlag = predictionResistanceFlagVS;
            if (PersonalizationStringLen != 0) {
                PersonalizationStringVS.rewind();
                PersonalizationStringLen = PersonalizationStringVS.remaining();
                if (PersonalizationStringLen > this.maxPersonalStringLen) {
                    String string = "personalization String too long";
                    return string;
                }
            }
            ByteBuffer seedMaterial = ByteBuffer.allocate(EntropyInputLen + NonceLen + PersonalizationStringLen);
            EntropyInputVS.rewind();
            NonceVS.rewind();
            if (PersonalizationStringLen == 0) {
                seedMaterial.put(EntropyInputVS);
                seedMaterial.put(NonceVS);
            } else {
                seedMaterial.put(EntropyInputVS);
                seedMaterial.put(NonceVS);
                seedMaterial.put(PersonalizationStringVS);
            }
            seedMaterial.rewind();
            this.instantiateReseedVCEngine(seedMaterial);
            seedMaterial.clear();
        }
        finally {
            this.hdf.reset();
        }
        return "Success";
    }

    protected void instantiateReseedVCEngine(ByteBuffer seedMaterial) {
        this.hdf.reset();
        this.V = ByteBuffer.allocate(this.seedLen);
        this.V.put(this.hdf.generate(seedMaterial));
        this.V.rewind();
        this.hdf.reset();
        ByteBuffer V0x00 = ByteBuffer.allocate(1 + this.seedLen);
        V0x00.put((byte)0).put(this.V);
        this.C = ByteBuffer.allocate(this.seedLen);
        this.C.put(this.hdf.generate(V0x00));
        this.reseedCounter = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String reseedHashDRBG(ByteBuffer additionalInput) {
        int noncePluseFlag = 0;
        int additionalInputLen = 0;
        try {
            if (additionalInput != null) {
                additionalInput.rewind();
                additionalInputLen = additionalInput.remaining();
                if (additionalInput.remaining() > this.maxAdditionalInputLen) {
                    return "The additional_input too long.";
                }
            } else {
                additionalInputLen = 0;
            }
            ByteBuffer collectedEntropy = ByteBuffer.allocate(this.entropyOutputLen);
            collectedEntropy.put(this.getEntropyAndCondition(this.entropyOutputLen, this.collectionEntropyMode, this.securityStrength, this.maxEntropyLen, this.hashAlgrithm, noncePluseFlag));
            collectedEntropy.rewind();
            ByteBuffer seedMaterial = ByteBuffer.allocate(1 + this.seedLen + collectedEntropy.remaining() + additionalInputLen);
            if (additionalInputLen == 0) {
                seedMaterial.put((byte)1).put(this.V.array()).put(collectedEntropy);
            } else {
                seedMaterial.put((byte)1).put(this.V.array()).put(collectedEntropy).put(additionalInput);
            }
            this.instantiateReseedVCEngine(seedMaterial);
            this.reseedCounter = 1;
            return "Success";
        }
        catch (Exception e) {
            return "Success";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String reseedHashDRBG(ByteBuffer entropyInputPRVS, ByteBuffer additionalInputVS) {
        int additionalInputVSLen = 0;
        int entropyInputPRVSLen = 0;
        if (entropyInputPRVS != null) {
            entropyInputPRVS.rewind();
            entropyInputPRVSLen = entropyInputPRVS.remaining();
            if (entropyInputPRVSLen > this.maxEntropyLen) {
                return "The entropy_input too long.";
            }
        } else {
            entropyInputPRVSLen = 0;
        }
        if (additionalInputVS != null) {
            additionalInputVS.rewind();
            additionalInputVSLen = additionalInputVS.remaining();
            if (additionalInputVSLen > this.maxAdditionalInputLen) {
                return "The additional_input too long.";
            }
        } else {
            additionalInputVSLen = 0;
        }
        ByteBuffer seedMaterial = ByteBuffer.allocate(1 + this.seedLen + entropyInputPRVSLen + additionalInputVSLen);
        if (entropyInputPRVSLen == 0 && additionalInputVSLen != 0) {
            seedMaterial.put((byte)1).put(this.V.array()).put(additionalInputVS);
        }
        if (entropyInputPRVSLen != 0 && additionalInputVSLen == 0) {
            seedMaterial.put((byte)1).put(this.V.array()).put(entropyInputPRVS);
        }
        if (entropyInputPRVSLen != 0 && additionalInputVSLen != 0) {
            seedMaterial.put((byte)1).put(this.V.array()).put(entropyInputPRVS).put(additionalInputVS);
        }
        this.instantiateReseedVCEngine(seedMaterial);
        this.reseedCounter = 1;
        return "Success";
    }

    protected synchronized byte[] generateHashDRBG(int requestnumberOfBytes, int requestdSecurityStrength, int predictionResistanceRequest, ByteBuffer additionalInput) {
        if (requestnumberOfBytes > this.maxRequestnumberOfBytes) {
            System.out.println("Too many bytes requested(>= 2^19bits).");
            return null;
        }
        byte[] returnBits = new byte[requestnumberOfBytes];
        if (requestdSecurityStrength > this.securityStrength) {
            System.out.println("Invalid requested security strength");
            return null;
        }
        if (predictionResistanceRequest == 1 && !this.predictionResistanceFlag) {
            System.out.println("Prediction Resistance capability not instantiated");
            return null;
        }
        try {
            if (this.reseedCounter > this.maxReseedInterval || predictionResistanceRequest == 1) {
                this.reseedHashDRBG(additionalInput);
                additionalInput = null;
            }
            BigInteger num2 = BigInteger.valueOf(2L);
            BigInteger num2Pow = num2.pow(this.seedLen * 8);
            if (additionalInput != null) {
                additionalInput.rewind();
                int additionalInputLen = additionalInput.remaining();
                if (additionalInputLen > this.maxAdditionalInputLen) {
                    System.out.println("[GenerateDRBG] Additional InputLen is too long Size.");
                }
                ByteBuffer seed = ByteBuffer.allocate(1 + this.seedLen + additionalInputLen);
                seed.put((byte)2).put(this.V).put(additionalInput);
                byte[] w = this.md.digest(seed.array());
                BigInteger bigIntV = new BigInteger(1, this.V.array());
                BigInteger bigIntw = new BigInteger(1, w);
                BigInteger addBigIntVw = bigIntV.add(bigIntw);
                BigInteger mod = addBigIntVw.remainder(num2Pow);
                this.V = ByteBuffer.allocate(this.seedLen);
                this.V.rewind();
                int modLen = mod.toByteArray().length;
                if (modLen > this.seedLen) {
                    this.V.put(mod.toByteArray(), 1, this.seedLen);
                } else if (modLen == this.seedLen) {
                    this.V.put(mod.toByteArray(), 0, this.seedLen);
                } else if (modLen < this.seedLen) {
                    modLen = this.seedLen - modLen;
                    for (int j = 0; j < modLen; ++j) {
                        this.V.put((byte)0);
                    }
                    this.V.put(mod.toByteArray(), 0, this.seedLen - modLen);
                }
            }
            returnBits = this.hashGen(requestnumberOfBytes, this.V, num2Pow);
            ByteBuffer V0x03 = ByteBuffer.allocate(1 + this.seedLen);
            this.V.rewind();
            V0x03.put((byte)3).put(this.V);
            byte[] H = this.md.digest(V0x03.array());
            this.V.rewind();
            this.C.rewind();
            BigInteger bigIntV = new BigInteger(1, this.V.array());
            BigInteger bigIntH = new BigInteger(1, H);
            BigInteger bigIntC = new BigInteger(1, this.C.array());
            BigInteger addBigIntVH = bigIntV.add(bigIntH);
            BigInteger addBigIntVHC = addBigIntVH.add(bigIntC);
            BigInteger addBigIntVHCRC = addBigIntVHC.add(BigInteger.valueOf(this.reseedCounter));
            BigInteger modFinal = addBigIntVHCRC.remainder(num2Pow);
            this.V = ByteBuffer.allocate(this.seedLen);
            this.V.rewind();
            int modFinalLen = modFinal.toByteArray().length;
            if (modFinalLen > this.seedLen) {
                this.V.put(modFinal.toByteArray(), 1, this.seedLen);
            } else if (modFinalLen == this.seedLen) {
                this.V.put(modFinal.toByteArray(), 0, this.seedLen);
            } else if (modFinalLen < this.seedLen) {
                modFinalLen = this.seedLen - modFinalLen;
                for (int j = 0; j < modFinalLen; ++j) {
                    this.V.put((byte)0);
                }
                this.V.put(modFinal.toByteArray(), 0, this.seedLen - modFinalLen);
            }
            ++this.reseedCounter;
        }
        catch (Exception e) {
            // empty catch block
        }
        return returnBits;
    }

    protected byte[] generateHashDRBG(ByteBuffer entopyInputPRVS, ByteBuffer additionalInputVS) {
        int requestnumberOfBytes = this.outLen;
        byte[] returnBits = new byte[this.outLen];
        if (this.reseedCounter > this.outLen || this.predictionResistanceFlag) {
            this.reseedHashDRBG(entopyInputPRVS, additionalInputVS);
            additionalInputVS = null;
        }
        this.V.rewind();
        this.C.rewind();
        BigInteger num2 = BigInteger.valueOf(2L);
        BigInteger num2Pow = num2.pow(this.seedLen * 8);
        if (additionalInputVS != null) {
            additionalInputVS.rewind();
            int additionalInputVSLen = additionalInputVS.remaining();
            if (additionalInputVSLen > this.maxAdditionalInputLen) {
                System.out.println("[GenerateDRBG] Additional InputLen is too long Size.");
            }
            ByteBuffer seed = ByteBuffer.allocate(1 + this.seedLen + additionalInputVSLen);
            seed.put((byte)2).put(this.V).put(additionalInputVS);
            seed.rewind();
            byte[] w = this.md.digest(seed.array());
            BigInteger bigIntV = new BigInteger(1, this.V.array());
            BigInteger bigIntw = new BigInteger(1, w);
            BigInteger addBigIntVw = bigIntV.add(bigIntw);
            BigInteger mod = addBigIntVw.remainder(num2Pow);
            this.V = ByteBuffer.allocate(this.seedLen);
            this.V.rewind();
            int modLen = mod.toByteArray().length;
            if (modLen > this.seedLen) {
                this.V.put(mod.toByteArray(), 1, this.seedLen);
            } else if (modLen == this.seedLen) {
                this.V.put(mod.toByteArray(), 0, this.seedLen);
            } else if (modLen < this.seedLen) {
                modLen = this.seedLen - modLen;
                for (int j = 0; j < modLen; ++j) {
                    this.V.put((byte)0);
                }
                this.V.put(mod.toByteArray(), 0, this.seedLen - modLen);
            }
        }
        returnBits = this.hashGen(requestnumberOfBytes, this.V, num2Pow);
        ByteBuffer V0x03 = ByteBuffer.allocate(1 + this.seedLen);
        this.V.rewind();
        V0x03.put((byte)3).put(this.V);
        byte[] H = this.md.digest(V0x03.array());
        this.V.rewind();
        this.C.rewind();
        BigInteger bigIntV = new BigInteger(1, this.V.array());
        BigInteger bigIntH = new BigInteger(1, H);
        BigInteger bigIntC = new BigInteger(1, this.C.array());
        BigInteger addBigIntVH = bigIntV.add(bigIntH);
        BigInteger addBigIntVHC = addBigIntVH.add(bigIntC);
        BigInteger addBigIntVHCRC = addBigIntVHC.add(BigInteger.valueOf(this.reseedCounter));
        BigInteger modFinal = addBigIntVHCRC.remainder(num2Pow);
        this.V = ByteBuffer.allocate(this.seedLen);
        this.V.rewind();
        int modFinalLen = modFinal.toByteArray().length;
        if (modFinalLen > this.seedLen) {
            this.V.put(modFinal.toByteArray(), 1, this.seedLen);
        } else if (modFinalLen == this.seedLen) {
            this.V.put(modFinal.toByteArray(), 0, this.seedLen);
        } else if (modFinalLen < this.seedLen) {
            modFinalLen = this.seedLen - modFinalLen;
            for (int j = 0; j < modFinalLen; ++j) {
                this.V.put((byte)0);
            }
            this.V.put(modFinal.toByteArray(), 0, this.seedLen - modFinalLen);
        }
        ++this.reseedCounter;
        return returnBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] hashGen(int requestnumberOfBytesToReturn, ByteBuffer V, BigInteger num2Pow) {
        byte[] returnBits = null;
        byte[] t_0x00 = new byte[this.outLen];
        try {
            if (this.rbg_block == null) {
                this.rbg_block = new byte[this.outLen];
            } else if (this.rbg_block.length != this.outLen) {
                this.rbg_block = new byte[this.outLen];
            }
            int m = (int)Math.ceil((float)requestnumberOfBytesToReturn / (float)this.outLen);
            ByteBuffer W = ByteBuffer.allocate(this.outLen * m);
            ByteBuffer data = ByteBuffer.allocate(this.seedLen);
            V.rewind();
            data.put(V);
            for (int i = 0; i < m; ++i) {
                data.rewind();
                byte[] w = this.md.digest(data.array());
                if (Arrays.equals(this.rbg_block, t_0x00)) {
                    System.arraycopy(w, 0, this.rbg_block, 0, w.length);
                } else {
                    if (Arrays.equals(w, this.rbg_block)) {
                        throw new KSXRuntimeException(" drbg condition test error");
                    }
                    System.arraycopy(w, 0, this.rbg_block, 0, w.length);
                }
                W.put(w);
                BigInteger bigIntData = new BigInteger(1, data.array());
                BigInteger addBigIntOne = bigIntData.add(BigInteger.ONE);
                BigInteger mod = addBigIntOne.remainder(num2Pow);
                data = ByteBuffer.allocate(this.seedLen);
                data.rewind();
                int modLen = mod.toByteArray().length;
                if (modLen > this.seedLen) {
                    data.put(mod.toByteArray(), 1, this.seedLen);
                    continue;
                }
                if (modLen == this.seedLen) {
                    data.put(mod.toByteArray(), 0, this.seedLen);
                    continue;
                }
                if (modLen >= this.seedLen) continue;
                modLen = this.seedLen - modLen;
                for (int j = 0; j < modLen; ++j) {
                    data.put((byte)0);
                }
                data.put(mod.toByteArray(), 0, this.seedLen - modLen);
            }
            returnBits = new byte[requestnumberOfBytesToReturn];
            W.rewind();
            W.get(returnBits, 0, requestnumberOfBytesToReturn);
        }
        catch (Exception e) {}
        return returnBits;
    }

    public final void zeroize() {
        if (this.V != null) {
            this.V = ByteBuffer.allocate(this.seedLen);
        }
        if (this.C != null) {
            this.C = ByteBuffer.allocate(this.seedLen);
        }
        this.reseedCounter = 0;
    }

    private class HashDf {
        private transient int counter;

        private HashDf() {
            this.reset();
        }

        public void reset() {
            this.counter = 0;
        }

        public ByteBuffer generate(ByteBuffer seedMaterial) {
            int numberOfBytesToReturn = HashDRBG.this.seedLen;
            int len = HashDRBG.this.md.getDigestLength();
            ByteBuffer seed = ByteBuffer.allocate(numberOfBytesToReturn);
            int counter = 1;
            seedMaterial.rewind();
            ByteBuffer addseedMaterial = ByteBuffer.allocate(5 + seedMaterial.remaining());
            while (seed.hasRemaining()) {
                seedMaterial.rewind();
                int numBytes = Math.min(seed.remaining(), len);
                addseedMaterial.put((byte)counter);
                addseedMaterial.putInt(numberOfBytesToReturn * 8);
                addseedMaterial.put(seedMaterial);
                seed.put(HashDRBG.this.md.digest(addseedMaterial.array()), 0, numBytes);
                addseedMaterial.rewind();
                ++counter;
            }
            return (ByteBuffer)seed.rewind();
        }
    }
}

