/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.random;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.SelfTestCase;
import com.initech.provider.crypto.entropy.EntropyAdapter;
import com.initech.provider.crypto.random.FIPS186_2Appendix3;
import com.initech.provider.crypto.random.HashDRBG;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class RandomSelfTestCase
implements SelfTestCase {
    void testFIPS186_2Appendix3() {
        FIPS186_2Appendix3 rand = new FIPS186_2Appendix3();
        byte[] newkey = Hex.parseHexaString("BD029BBE7F51960BCF9EDB2B61F06F0FEB5A38B6");
        byte[] known = Hex.parseHexaString("2070B3223DBA372FDE1C0FFC7B2E3B498B260614");
        rand.setXKey(newkey);
        byte[] x = rand.getPreviousBlock();
        if (!Arrays.equals(known, x)) {
            throw new KSXRuntimeException("FIPS 186-2 Appendix3 RNG Failed");
        }
        byte[] y = new byte[20];
        rand.nextBytes(y);
        if (Arrays.equals(x, y)) {
            throw new KSXRuntimeException("FIPS 186-2 Appendix3 RNG Failed.");
        }
    }

    void testHashDRBGSHA224() {
        try {
            ByteBuffer EntropyInput = ByteBuffer.allocate(32);
            ByteBuffer Nonce = ByteBuffer.allocate(16);
            ByteBuffer AdditionalInputTrue0 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue0 = ByteBuffer.allocate(32);
            ByteBuffer AdditionalInputTrue1 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue1 = ByteBuffer.allocate(32);
            ByteBuffer result = ByteBuffer.allocate(28);
            EntropyInput.put(Hex.parseHexaString("3e6c7658b7e12dea03c19179e013ace76f8ca3528d8c1c8f1e1f0d76aef4109f"));
            Nonce.put(Hex.parseHexaString("c09a41cc386e082cd82d2520b9756acb"));
            AdditionalInputTrue0.put(Hex.parseHexaString("774cffda7e559cd73312f91545de2b00fd40d593e68eeb21d1b1bd40df3c77fe"));
            EntropyInputPRTrue0.put(Hex.parseHexaString("8e6811c5b7a32209ecd7f7ccf6fe8506462bf3480c5b557aadd8d84809475e37"));
            AdditionalInputTrue1.put(Hex.parseHexaString("6a8472bc8433d0746220125453a6eede66db1be6e1ff6955b8a7e8efb3dde67e"));
            EntropyInputPRTrue1.put(Hex.parseHexaString("2409752b5241477be345707dc051d50646efbe4929f593bb45866cd169569d9b"));
            result.put(Hex.parseHexaString("650c84b37cb84229fdd040985a5f29d10f6bb633c2cc8c467d1f76d9"));
            HashDRBG hashdrbg = new HashDRBG("SHA224");
            hashdrbg.instantiateHashDRBG(true, 32, EntropyInput, 16, Nonce, 0, null);
            byte[] ReturnedBits0 = hashdrbg.generateHashDRBG(EntropyInputPRTrue0, AdditionalInputTrue0);
            byte[] ReturnedBits = hashdrbg.generateHashDRBG(EntropyInputPRTrue1, AdditionalInputTrue1);
            if (!Arrays.equals(ReturnedBits, result.array())) {
                throw new KSXRuntimeException("testHashDRBGSHA224 Failed");
            }
            EntropyInput.clear();
            Nonce.clear();
            AdditionalInputTrue0.clear();
            EntropyInputPRTrue0.clear();
            AdditionalInputTrue1.clear();
            EntropyInputPRTrue1.clear();
            result.clear();
            hashdrbg.unInstantiateHashDRBG();
            hashdrbg.zeroize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KSXRuntimeException("testHashDRBGSHA224 Failed");
        }
    }

    void testHashDRBGSHA256() {
        try {
            ByteBuffer EntropyInput = ByteBuffer.allocate(32);
            ByteBuffer Nonce = ByteBuffer.allocate(16);
            ByteBuffer AdditionalInputTrue0 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue0 = ByteBuffer.allocate(32);
            ByteBuffer AdditionalInputTrue1 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue1 = ByteBuffer.allocate(32);
            ByteBuffer result = ByteBuffer.allocate(32);
            EntropyInput.put(Hex.parseHexaString("3e6c7658b7e12dea03c19179e013ace76f8ca3528d8c1c8f1e1f0d76aef4109f"));
            Nonce.put(Hex.parseHexaString("c09a41cc386e082cd82d2520b9756acb"));
            AdditionalInputTrue0.put(Hex.parseHexaString("774cffda7e559cd73312f91545de2b00fd40d593e68eeb21d1b1bd40df3c77fe"));
            EntropyInputPRTrue0.put(Hex.parseHexaString("8e6811c5b7a32209ecd7f7ccf6fe8506462bf3480c5b557aadd8d84809475e37"));
            AdditionalInputTrue1.put(Hex.parseHexaString("6a8472bc8433d0746220125453a6eede66db1be6e1ff6955b8a7e8efb3dde67e"));
            EntropyInputPRTrue1.put(Hex.parseHexaString("2409752b5241477be345707dc051d50646efbe4929f593bb45866cd169569d9b"));
            result.put(Hex.parseHexaString("ceda12104a1cf6ca5fdaa3f277c1dfac8c41e6ef436d7b53b74098b23bf426f2"));
            HashDRBG hashdrbg = new HashDRBG("SHA256");
            hashdrbg.instantiateHashDRBG(true, 32, EntropyInput, 16, Nonce, 0, null);
            byte[] ReturnedBits0 = hashdrbg.generateHashDRBG(EntropyInputPRTrue0, AdditionalInputTrue0);
            byte[] ReturnedBits = hashdrbg.generateHashDRBG(EntropyInputPRTrue1, AdditionalInputTrue1);
            if (!Arrays.equals(ReturnedBits, result.array())) {
                throw new KSXRuntimeException("testHashDRBGSHA256 Failed");
            }
            EntropyInput.clear();
            Nonce.clear();
            AdditionalInputTrue0.clear();
            EntropyInputPRTrue0.clear();
            AdditionalInputTrue1.clear();
            EntropyInputPRTrue1.clear();
            result.clear();
            hashdrbg.unInstantiateHashDRBG();
            hashdrbg.zeroize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KSXRuntimeException("testHashDRBGSHA256 Failed");
        }
    }

    void testHashDRBGSHA384() {
        try {
            ByteBuffer EntropyInput = ByteBuffer.allocate(32);
            ByteBuffer Nonce = ByteBuffer.allocate(16);
            ByteBuffer AdditionalInputTrue0 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue0 = ByteBuffer.allocate(32);
            ByteBuffer AdditionalInputTrue1 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue1 = ByteBuffer.allocate(32);
            ByteBuffer result = ByteBuffer.allocate(48);
            EntropyInput.put(Hex.parseHexaString("3e6c7658b7e12dea03c19179e013ace76f8ca3528d8c1c8f1e1f0d76aef4109f"));
            Nonce.put(Hex.parseHexaString("c09a41cc386e082cd82d2520b9756acb"));
            AdditionalInputTrue0.put(Hex.parseHexaString("774cffda7e559cd73312f91545de2b00fd40d593e68eeb21d1b1bd40df3c77fe"));
            EntropyInputPRTrue0.put(Hex.parseHexaString("8e6811c5b7a32209ecd7f7ccf6fe8506462bf3480c5b557aadd8d84809475e37"));
            AdditionalInputTrue1.put(Hex.parseHexaString("6a8472bc8433d0746220125453a6eede66db1be6e1ff6955b8a7e8efb3dde67e"));
            EntropyInputPRTrue1.put(Hex.parseHexaString("2409752b5241477be345707dc051d50646efbe4929f593bb45866cd169569d9b"));
            result.put(Hex.parseHexaString("b33b33bfe02091775aa369a97f8e80913af6060263cea9a642eb861a16c5563b73cdeaa986c528b7fe1bf96b99a1869b"));
            HashDRBG hashdrbg = new HashDRBG("SHA384");
            hashdrbg.instantiateHashDRBG(true, 32, EntropyInput, 16, Nonce, 0, null);
            byte[] ReturnedBits0 = hashdrbg.generateHashDRBG(EntropyInputPRTrue0, AdditionalInputTrue0);
            byte[] ReturnedBits = hashdrbg.generateHashDRBG(EntropyInputPRTrue1, AdditionalInputTrue1);
            if (!Arrays.equals(ReturnedBits, result.array())) {
                throw new KSXRuntimeException("testHashDRBGSHA384 Failed");
            }
            EntropyInput.clear();
            Nonce.clear();
            AdditionalInputTrue0.clear();
            EntropyInputPRTrue0.clear();
            AdditionalInputTrue1.clear();
            EntropyInputPRTrue1.clear();
            result.clear();
            hashdrbg.unInstantiateHashDRBG();
            hashdrbg.zeroize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KSXRuntimeException("testHashDRBGSHA384 Failed");
        }
    }

    void testHashDRBGSHA512() {
        try {
            ByteBuffer EntropyInput = ByteBuffer.allocate(32);
            ByteBuffer Nonce = ByteBuffer.allocate(16);
            ByteBuffer AdditionalInputTrue0 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue0 = ByteBuffer.allocate(32);
            ByteBuffer AdditionalInputTrue1 = ByteBuffer.allocate(32);
            ByteBuffer EntropyInputPRTrue1 = ByteBuffer.allocate(32);
            ByteBuffer result = ByteBuffer.allocate(64);
            EntropyInput.put(Hex.parseHexaString("3e6c7658b7e12dea03c19179e013ace76f8ca3528d8c1c8f1e1f0d76aef4109f"));
            Nonce.put(Hex.parseHexaString("c09a41cc386e082cd82d2520b9756acb"));
            AdditionalInputTrue0.put(Hex.parseHexaString("774cffda7e559cd73312f91545de2b00fd40d593e68eeb21d1b1bd40df3c77fe"));
            EntropyInputPRTrue0.put(Hex.parseHexaString("8e6811c5b7a32209ecd7f7ccf6fe8506462bf3480c5b557aadd8d84809475e37"));
            AdditionalInputTrue1.put(Hex.parseHexaString("6a8472bc8433d0746220125453a6eede66db1be6e1ff6955b8a7e8efb3dde67e"));
            EntropyInputPRTrue1.put(Hex.parseHexaString("2409752b5241477be345707dc051d50646efbe4929f593bb45866cd169569d9b"));
            result.put(Hex.parseHexaString("9025A01977602F41394616E3F5EC4EA918B58B5FD42DAFE9C2B5D9e304ab3987ccd0a69ed016d41fe1d8766e5f52e4f996b20458dd0c704393d386a8239a770c"));
            HashDRBG hashdrbg = new HashDRBG("SHA512");
            hashdrbg.instantiateHashDRBG(true, 32, EntropyInput, 16, Nonce, 0, null);
            byte[] ReturnedBits0 = hashdrbg.generateHashDRBG(EntropyInputPRTrue0, AdditionalInputTrue0);
            byte[] ReturnedBits = hashdrbg.generateHashDRBG(EntropyInputPRTrue1, AdditionalInputTrue1);
            if (!Arrays.equals(ReturnedBits, result.array())) {
                throw new KSXRuntimeException("testHashDRBGSHA512 Failed");
            }
            EntropyInput.clear();
            Nonce.clear();
            AdditionalInputTrue0.clear();
            EntropyInputPRTrue0.clear();
            AdditionalInputTrue1.clear();
            EntropyInputPRTrue1.clear();
            result.clear();
            hashdrbg.unInstantiateHashDRBG();
            hashdrbg.zeroize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KSXRuntimeException("testHashDRBGSHA512 Failed");
        }
    }

    void testEntropy() {
        EntropyAdapter ent = new EntropyAdapter();
        int entropyOutputLen = 32;
        int securityStrength = 16;
        int maxEntropyLen = 555555555;
        String hashAlg = "SHA256";
        boolean noncePluseFlag = true;
        int mdOutputEntropyNonceLen = 0;
        mdOutputEntropyNonceLen = noncePluseFlag ? entropyOutputLen + entropyOutputLen / 2 : entropyOutputLen;
        ByteBuffer EntropyCollect1 = ByteBuffer.allocate(mdOutputEntropyNonceLen);
        EntropyCollect1.put(ent.collection(hashAlg));
        EntropyCollect1.rewind();
        ByteBuffer EntropyCollect2 = ByteBuffer.allocate(mdOutputEntropyNonceLen);
        EntropyCollect2.put(ent.collection(hashAlg));
        EntropyCollect2.rewind();
        if (Arrays.equals(EntropyCollect1.array(), EntropyCollect2.array())) {
            throw new KSXRuntimeException("Entropy data is same!");
        }
    }

    public void selfTest() {
        this.testHashDRBGSHA224();
        this.testHashDRBGSHA256();
        this.testHashDRBGSHA384();
        this.testHashDRBGSHA512();
    }
}

