/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.random;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.spec.DESedeKeySpec;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.random.HashDRBG;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class X9_17
extends SecureRandomSpi {
    private static final long serialVersionUID = 5500396677672394825L;
    protected byte[] key = null;
    protected final int DESEDE_BLOCKSIZE = 8;
    protected byte[] seed = new byte[8];
    protected Cipher cipher;
    protected byte[] data = new byte[8];
    protected byte[] temp = new byte[8];

    public X9_17() {
        this.key = new byte[24];
        try {
            HashDRBG random = new HashDRBG("SHA224");
            random.nextBytes(this.key);
        }
        catch (Exception e) {
            new SecureRandom().nextBytes(this.key);
        }
        System.arraycopy(this.key, 0, this.key, 16, 8);
        try {
            this.cipher = Cipher.getInstance("DESede/ECB/NoPadding", InitechProvider.NAME);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede", InitechProvider.NAME);
            SecretKey deskey = skf.generateSecret(new DESedeKeySpec(this.key));
            this.cipher.init(1, (Key)deskey, (SecureRandom)null);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] ret = new byte[numBytes];
        this.engineNextBytes(ret);
        for (int i = 0; i < ret.length; ++i) {
            int n = i;
            ret[n] = (byte)(ret[n] ^ this.seed[i % 8]);
        }
        return ret;
    }

    protected void engineNextBytes(byte[] bytes) {
        int lengthLeft = bytes.length;
        while (lengthLeft > 0) {
            if (lengthLeft >= 8) {
                this.processStage(bytes, bytes.length - lengthLeft);
                lengthLeft -= 8;
                continue;
            }
            this.processStage(this.temp, 0);
            System.arraycopy(this.temp, 0, bytes, bytes.length - lengthLeft, lengthLeft);
            lengthLeft = 0;
        }
    }

    protected void engineSetSeed(byte[] seed) {
        int i;
        for (i = 0; i < this.seed.length; ++i) {
            this.seed[i] = 0;
        }
        for (i = 0; i < seed.length; ++i) {
            int n = i % 8;
            this.seed[n] = (byte)(this.seed[n] ^ seed[i]);
        }
    }

    protected void processStage(byte[] out, int offset) {
        long current = System.currentTimeMillis();
        this.data[0] = (byte)(current & 0xFFL);
        this.data[1] = (byte)((current & 0xFF00L) >>> 8);
        this.data[2] = (byte)((current & 0xFF0000L) >>> 16);
        this.data[3] = (byte)((current & 0xFF000000L) >>> 24);
        this.data[4] = (byte)((current & 0xFF00000000L) >>> 32);
        this.data[5] = (byte)((current & 0xFF0000000000L) >>> 40);
        this.data[6] = (byte)((current & 0xFF000000000000L) >>> 48);
        this.data[7] = (byte)((current & 0xFF00000000000000L) >>> 56);
        try {
            int i;
            if (this.cipher == null) {
                throw new NullPointerException("cipher is null");
            }
            this.cipher.doFinal(this.data, 0, 8, this.data, 0);
            for (i = 0; i < 8; ++i) {
                this.temp[i] = (byte)(this.data[i] ^ this.seed[i]);
            }
            this.cipher.doFinal(this.temp, 0, 8, out, offset);
            for (i = 0; i < 8; ++i) {
                this.temp[i] = (byte)(this.data[i] ^ out[i + offset]);
            }
            this.cipher.doFinal(this.temp, 0, 8, this.seed);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

