/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;

public class DigestInfo
extends ASN1Object {
    private static final long serialVersionUID = -1015747821323295308L;
    private AlgorithmID digestAlg = new AlgorithmID();
    private byte[] digest = null;

    public DigestInfo() {
    }

    public DigestInfo(String hAlg, byte[] dig) {
        this.setDigestAlgorithm(hAlg);
        this.setDigest(dig);
    }

    public DigestInfo(byte[] byteArray) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(byteArray);
        this.decode(dec);
        this.encoded = (byte[])byteArray.clone();
        this.modified = false;
    }

    public void setDigestAlgorithm(String digestAlg) {
        this.digestAlg.setAlgorithm(digestAlg);
        this.digestAlg.setParameter(null);
        this.digestAlg.omitParameter(false);
    }

    public void setDigest(byte[] digest) {
        this.modified = true;
        this.digest = digest;
    }

    public String getDigestAlgorithm() {
        return this.digestAlg.getAlgName();
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        this.digestAlg.encode(enc);
        enc.encodeOctetString(this.digest);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.digestAlg.decode(dec);
        this.digest = dec.decodeOctetString();
        dec.endOf(id);
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

