/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;

public class EMSAPKCS15Codec
implements Cloneable {
    private static final byte[] MD2_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 2, 5, 0, 4, 16};
    private static final byte[] MD5_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] SHA160_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] SHA224_PREFIX = new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28};
    private static final byte[] SHA256_PREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] SHA384_PREFIX = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    private static final byte[] SHA512_PREFIX = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    private MessageDigest hash;
    private int hLen;
    private byte[] prefix;

    public EMSAPKCS15Codec(MessageDigest hash) {
        this.hash = hash;
        this.hLen = hash.getDigestLength();
        String name = hash.getAlgorithm();
        if (name.equals("MD2")) {
            this.prefix = MD2_PREFIX;
        } else if (name.equals("MD5")) {
            this.prefix = MD5_PREFIX;
        } else if (name.equals("SHA1")) {
            this.prefix = SHA160_PREFIX;
        } else if (name.equals("SHA224") || name.equals("SHA-224")) {
            this.prefix = SHA224_PREFIX;
        } else if (name.equals("SHA256") || name.equals("SHA-256")) {
            this.prefix = SHA256_PREFIX;
        } else if (name.equals("SHA384") || name.equals("SHA-384")) {
            this.prefix = SHA384_PREFIX;
        } else if (name.equals("SHA512") || name.equals("SHA-512")) {
            this.prefix = SHA512_PREFIX;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new EMSAPKCS15Codec((MessageDigest)this.hash.clone());
    }

    public byte[] encode(byte[] mHash, int emLen) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.prefix, 0, this.prefix.length);
        baos.write(mHash, 0, mHash.length);
        byte[] T = baos.toByteArray();
        int tLen = T.length;
        if (emLen < tLen + 11) {
            throw new IllegalArgumentException("emLen too short");
        }
        byte[] PS = new byte[emLen - tLen - 3];
        for (int i = 0; i < PS.length; ++i) {
            PS[i] = -1;
        }
        baos.reset();
        baos.write(0);
        baos.write(1);
        baos.write(PS, 0, PS.length);
        baos.write(0);
        baos.write(T, 0, tLen);
        byte[] result = baos.toByteArray();
        baos.reset();
        return result;
    }
}

