/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.util.Hex;
import java.security.MessageDigest;

public class EMSAPSSCodec
implements Cloneable {
    boolean DEBUG = false;
    MessageDigest md = null;
    int hLen = -1;

    public EMSAPSSCodec(MessageDigest md) {
        this.md = md;
        this.hLen = md.getDigestLength();
    }

    public Object clone() throws CloneNotSupportedException {
        return new EMSAPSSCodec((MessageDigest)this.md.clone());
    }

    public byte[] encode(byte[] mHash, int emBits, byte[] salt) throws CloneNotSupportedException {
        int i;
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.encode.mHash : " + Hex.dumpHex(mHash));
        }
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.encode.salt : " + Hex.dumpHex(salt));
        }
        int sLen = salt.length;
        if (this.hLen != mHash.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (emBits < 8 * this.hLen + 8 * sLen + 9) {
            throw new IllegalArgumentException("encoding error");
        }
        int emLen = (emBits + 7) / 8;
        for (i = 0; i < 8; ++i) {
            this.md.update((byte)0);
        }
        this.md.update(mHash, 0, this.hLen);
        this.md.update(salt, 0, salt.length);
        byte[] H = this.md.digest();
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.encode.H : " + Hex.dumpHex(H));
        }
        byte[] DB = new byte[emLen - sLen - this.hLen - 2 + 1 + sLen];
        DB[emLen - sLen - this.hLen - 2] = 1;
        System.arraycopy(salt, 0, DB, emLen - sLen - this.hLen - 1, sLen);
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.encode.DB : " + Hex.dumpHex(DB, ' '));
        }
        byte[] dbMask = this.MGF1(H, 0, H.length, DB.length);
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.encode.dbMask : " + Hex.dumpHex(dbMask, ' '));
        }
        for (i = 0; i < DB.length; ++i) {
            DB[i] = (byte)(DB[i] ^ dbMask[i]);
        }
        DB[0] = (byte)(DB[0] & 255 >>> 8 * emLen - emBits);
        byte[] result = new byte[emLen];
        System.arraycopy(DB, 0, result, 0, emLen - this.hLen - 1);
        System.arraycopy(H, 0, result, emLen - this.hLen - 1, this.hLen);
        result[emLen - 1] = -68;
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.encode.EM : " + Hex.dumpHex(result));
        }
        return result;
    }

    public boolean decode(byte[] mHash, byte[] EM, int emBits, int sLen) throws CloneNotSupportedException {
        int i;
        if (sLen < 0) {
            throw new IllegalArgumentException("sLen");
        }
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.mHash : " + Hex.dumpHex(mHash));
        }
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.EM : " + Hex.dumpHex(EM));
        }
        if (this.hLen != mHash.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (emBits < 8 * this.hLen + 8 * sLen + 9) {
            throw new IllegalArgumentException("decoding error");
        }
        int emLen = (emBits + 7) / 8;
        if ((EM[EM.length - 1] & 0xFF) != 188) {
            return false;
        }
        if ((EM[0] & 255 << 8 - (8 * emLen - emBits)) != 0) {
            return false;
        }
        byte[] DB = new byte[emLen - this.hLen - 1];
        byte[] H = new byte[this.hLen];
        System.arraycopy(EM, 0, DB, 0, emLen - this.hLen - 1);
        System.arraycopy(EM, emLen - this.hLen - 1, H, 0, this.hLen);
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.H : " + Hex.dumpHex(H));
        }
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.DB : " + Hex.dumpHex(DB));
        }
        byte[] dbMask = this.MGF1(H, 0, H.length, DB.length);
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.dbMask : " + Hex.dumpHex(dbMask, ' '));
        }
        for (i = 0; i < DB.length; ++i) {
            DB[i] = (byte)(DB[i] ^ dbMask[i]);
        }
        DB[0] = (byte)(DB[0] & 255 >>> 8 * emLen - emBits);
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.db : " + Hex.dumpHex(DB, ' '));
        }
        for (i = 0; i < emLen - this.hLen - sLen - 2; ++i) {
            if (DB[i] == 0) continue;
            return false;
        }
        if (DB[i] != 1) {
            return false;
        }
        byte[] salt = new byte[sLen];
        System.arraycopy(DB, DB.length - sLen, salt, 0, sLen);
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.salt : " + Hex.dumpHex(salt, ' '));
        }
        this.md.reset();
        for (i = 0; i < 8; ++i) {
            this.md.update((byte)0);
        }
        this.md.update(mHash, 0, this.hLen);
        this.md.update(salt, 0, sLen);
        byte[] H0 = this.md.digest();
        if (this.DEBUG) {
            System.out.println("INICrypto-EMSAPSSCodec.decode.H  : " + Hex.dumpHex(H));
            System.out.println("INICrypto-EMSAPSSCodec.decode.H0 : " + Hex.dumpHex(H0));
        }
        return this.isEqual(H, H0);
    }

    private boolean isEqual(byte[] h1, byte[] h2) {
        if (h1.length != h2.length) {
            return false;
        }
        for (int i = 0; i < h1.length; ++i) {
            if (h1[i] == h2[i]) continue;
            return false;
        }
        return true;
    }

    public final void MGF1(byte[] Z, int zoff, int zlen, byte[] mask, int moff, int l) {
        int outlen = 0;
        byte[] cnt = new byte[4];
        if (mask.length < moff + l) {
            throw new RuntimeException("MGF1: too small mask");
        }
        int i = 0;
        while (outlen < l) {
            cnt[0] = (byte)(i >> 24 & 0xFF);
            cnt[1] = (byte)(i >> 16 & 0xFF);
            cnt[2] = (byte)(i >> 8 & 0xFF);
            cnt[3] = (byte)(i & 0xFF);
            this.md.reset();
            this.md.update(Z, zoff, zlen);
            this.md.update(cnt);
            byte[] ret = this.md.digest();
            if (outlen + this.hLen <= l) {
                System.arraycopy(ret, 0, mask, outlen + moff, this.hLen);
                outlen += this.hLen;
            } else {
                System.arraycopy(ret, 0, mask, outlen + moff, l - outlen);
                outlen = l;
            }
            ++i;
        }
    }

    public byte[] MGF1(byte[] Z, int zoff, int zlen, int l) {
        byte[] mask = new byte[l];
        this.MGF1(Z, zoff, zlen, mask, 0, l);
        return mask;
    }
}

