/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.Cipher;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.rsa.DigestInfo;
import com.initech.provider.crypto.spec.NonHashedSignatureSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class NonHashedRSASignature
extends Signature {
    byte[] data;
    RSAPrivateKey privkey;
    String algId;
    RSAPublicKey pubkey;

    public NonHashedRSASignature() {
        super("RSA");
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privkey = (RSAPrivateKey)privateKey;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.pubkey = (RSAPublicKey)publicKey;
    }

    protected void engineUpdate(byte b) throws SignatureException {
        throw new SignatureException("not supported method");
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.data = new byte[len];
        System.arraycopy(b, off, this.data, 0, len);
    }

    private byte[] getT() {
        byte[] H = this.data;
        DigestInfo di = new DigestInfo(this.algId, H);
        return di.getEncoded();
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] T = this.getT();
        byte[] signature = null;
        try {
            Cipher cip = Cipher.getInstance("RSA/ECB/PKCS1Padding", InitechProvider.NAME);
            cip.init(1, (Key)this.privkey, this.appRandom);
            signature = cip.doFinal(T);
            return signature;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException();
        }
    }

    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] T = this.getT();
        try {
            Cipher cip = Cipher.getInstance("RSA/ECB/PKCS1Padding", InitechProvider.NAME);
            cip.init(1, (Key)this.privkey, this.appRandom);
            return cip.doFinal(T, 0, T.length, outbuf, offset);
        }
        catch (Exception e) {
            throw new SignatureException();
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            int zIndex = 0;
            Cipher cip = Cipher.getInstance("RSA/ECB/PKCS1Padding", InitechProvider.NAME);
            cip.init(2, (Key)this.pubkey, this.appRandom);
            byte[] T = cip.doFinal(sigBytes);
            byte[] TT = this.getT();
            if (T[0] == 0) {
                zIndex = 1;
            }
            if (T.length - zIndex != TT.length) {
                return false;
            }
            for (int i = 0; i < TT.length; ++i) {
                if (T[i + zIndex] == TT[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new SignatureException();
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof NonHashedSignatureSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        NonHashedSignatureSpec sigSpec = (NonHashedSignatureSpec)params;
        this.algId = sigSpec.getHashAlgorithm();
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("this is deprecated method");
    }
}

