/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.rsa.DigestInfo;
import com.initech.provider.crypto.rsa.RSAPublicKeyImpl;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class RSAAutoSignature {
    RSAPublicKeyImpl pubKey;
    String hashAlg = "SHA1";
    byte[] plainText;
    byte[] signature;

    public RSAAutoSignature() {
    }

    public RSAAutoSignature(PublicKey pubKey) throws InvalidKeyException {
        this.pubKey = new RSAPublicKeyImpl(pubKey.getEncoded());
    }

    public RSAAutoSignature(PublicKey pubKey, String plainText, String signature) throws InvalidKeyException {
        this(pubKey, plainText.getBytes(), signature.getBytes());
    }

    public RSAAutoSignature(PublicKey pubKey, String plainText, String signature, String hashAlg) throws InvalidKeyException {
        this(pubKey, plainText.getBytes(), signature.getBytes(), hashAlg);
    }

    public RSAAutoSignature(PublicKey pubKey, byte[] plainText, byte[] signature) throws InvalidKeyException {
        this.pubKey = new RSAPublicKeyImpl(pubKey.getEncoded());
        this.plainText = plainText;
        this.signature = signature;
    }

    public RSAAutoSignature(PublicKey pubKey, byte[] plainText, byte[] signature, String hashAlg) throws InvalidKeyException {
        this.pubKey = new RSAPublicKeyImpl(pubKey.getEncoded());
        this.plainText = plainText;
        this.signature = signature;
        this.hashAlg = hashAlg;
    }

    private BigInteger RSAEP(BigInteger m) {
        BigInteger n = this.pubKey.getModulus();
        if (m.compareTo(BigInteger.ZERO) < 0 || m.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        BigInteger e = this.pubKey.getPublicExponent();
        BigInteger result = m.modPow(e, n);
        return result;
    }

    public boolean verify() {
        boolean result = false;
        int modBits = this.pubKey.getModulus().bitLength();
        int k = (modBits + 7) / 8;
        if (this.signature.length != k) {
            return false;
        }
        BigInteger s = new BigInteger(1, this.signature);
        BigInteger m = this.RSAEP(s);
        byte[] EM = this.I2OSP(m, k);
        byte[] decEM = this.padPKCSV15(EM);
        try {
            Signature sign = decEM == null ? Signature.getInstance(this.hashAlg + "withRSAPSS", InitechProvider.NAME) : Signature.getInstance(this.hashAlg + "withRSA", InitechProvider.NAME);
            sign.initVerify(this.pubKey);
            sign.update(this.plainText);
            result = sign.verify(this.signature);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public byte[] I2OSP(BigInteger s, int k) {
        byte[] result = s.toByteArray();
        if (result.length < k) {
            byte[] newResult = new byte[k];
            System.arraycopy(result, 0, newResult, k - result.length, result.length);
            result = newResult;
        } else if (result.length > k) {
            int limit = result.length - k;
            for (int i = 0; i < limit; ++i) {
                if (result[i] == 0) continue;
                throw new IllegalArgumentException("integer too large");
            }
            byte[] newResult = new byte[k];
            System.arraycopy(result, limit, newResult, 0, k);
            result = newResult;
        }
        return result;
    }

    public boolean verify(byte[] signature) {
        this.signature = signature;
        return this.verify();
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public byte[] getSignautre() {
        return this.signature;
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public void setHashAlg(String hashAlg) {
        this.hashAlg = hashAlg;
    }

    public void setPublicKey(PublicKey pubKey) throws InvalidKeyException {
        this.pubKey = new RSAPublicKeyImpl(pubKey.getEncoded());
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] padPKCSV15(byte[] data) {
        int i;
        byte[] result = null;
        for (i = 2; i < data.length && data[i] != 0; ++i) {
        }
        if (i == data.length) {
            return null;
        }
        byte[] di = new byte[data.length - i - 1];
        System.arraycopy(data, i + 1, di, 0, di.length);
        result = di;
        try {
            DigestInfo d = new DigestInfo(result);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        InitechProvider.addAsProvider();
        byte[] msg = "test msg".getBytes();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", InitechProvider.NAME);
        KeyPair kp = kpg.generateKeyPair();
        PublicKey pubKey = kp.getPublic();
        PrivateKey privKey = kp.getPrivate();
        String hashAlg = "SHA256";
        Signature sig = Signature.getInstance(hashAlg + "withRSA", InitechProvider.NAME);
        sig.initSign(privKey);
        sig.update(msg);
        byte[] signature = sig.sign();
        System.out.println(Hex.dumpHex(signature));
        RSAAutoSignature as = new RSAAutoSignature(pubKey, msg, signature, hashAlg);
        boolean result = as.verify();
        System.out.println(result);
    }
}

