/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.cryptox.KeyFactorySpi;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.provider.crypto.rsa.RSAPrivateCrtKeyImpl;
import com.initech.provider.crypto.rsa.RSAPrivateKeyImpl;
import com.initech.provider.crypto.rsa.RSAPublicKeyImpl;
import com.initech.provider.crypto.spec.PKCS1EncodedPrivateKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyFactory
extends KeyFactorySpi {
    private AlgorithmID algorithmID;

    public RSAKeyFactory() {
        this.algorithmID = new AlgorithmID("1.2.840.113549.1.1.1", null);
    }

    public RSAKeyFactory(AlgorithmID algorithmID) {
        this.algorithmID = algorithmID;
    }

    protected PrivateKey _engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec spec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKeyImpl(spec.getModulus(), spec.getPublicExponent(), spec.getPrivateExponent(), spec.getPrimeP(), spec.getPrimeQ(), spec.getPrimeExponentP(), spec.getPrimeExponentQ(), spec.getCrtCoefficient(), this.algorithmID);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec spec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKeyImpl(spec.getModulus(), spec.getPrivateExponent(), this.algorithmID);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                PKCS8EncodedKeySpec p8ks = (PKCS8EncodedKeySpec)keySpec;
                try {
                    return new RSAPrivateCrtKeyImpl(p8ks.getEncoded());
                }
                catch (InvalidKeyException ex) {
                    return new RSAPrivateKeyImpl(p8ks.getEncoded());
                }
            }
            if (keySpec instanceof PKCS1EncodedPrivateKeySpec) {
                PKCS1EncodedPrivateKeySpec asn1private = (PKCS1EncodedPrivateKeySpec)keySpec;
                PrivateKeyInfo pkinfo = new PrivateKeyInfo();
                pkinfo.setPrivateKey(asn1private.getEncoded());
                pkinfo.setPrivateKeyAlgorithm(this.algorithmID);
                try {
                    try {
                        return new RSAPrivateCrtKeyImpl(pkinfo.getEncoded());
                    }
                    catch (ASN1Exception aex) {
                        throw new InvalidKeyException(aex.getMessage());
                    }
                }
                catch (InvalidKeyException ex) {
                    try {
                        return new RSAPrivateKeyImpl(pkinfo.getEncoded());
                    }
                    catch (ASN1Exception aex) {
                        throw new InvalidKeyException(aex.getMessage());
                    }
                }
            }
            throw new InvalidKeyException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected PublicKey _engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec spec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKeyImpl(spec.getModulus(), spec.getPublicExponent(), this.algorithmID);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                PublicKeyInfo spki = new PublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
                String alg = spki.getAlg();
                if (!alg.equals("1.2.840.113549.1.1.1") && !alg.equals("1.2.840.113549.1.1.10")) {
                    throw new InvalidKeySpecException("key is not RSA public key");
                }
                return new RSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded(), this.algorithmID);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                PublicKeyInfo spki = new PublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
                String alg = spki.getAlg();
                if (!alg.equals("1.2.840.113549.1.1.1") && !alg.equals("1.2.840.113549.1.1.10")) {
                    throw new InvalidKeySpecException("key is not RSA public key");
                }
                return new RSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded(), this.algorithmID);
            }
            throw new InvalidKeyException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new InvalidKeySpecException("key spec is Illegal encoded spec");
        }
    }

    protected KeySpec _engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof RSAPublicKey) {
                Class<?> c1 = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> c2 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (c1.isAssignableFrom(keySpec)) {
                    RSAPublicKey pubkey = (RSAPublicKey)key;
                    return new RSAPublicKeySpec(pubkey.getModulus(), pubkey.getPublicExponent());
                }
                if (c2.isAssignableFrom(keySpec)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey privkey = (RSAPrivateCrtKey)key;
                Class<?> c1 = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (c1.isAssignableFrom(keySpec)) {
                    return new RSAPrivateCrtKeySpec(privkey.getModulus(), privkey.getPublicExponent(), privkey.getPrivateExponent(), privkey.getPrimeP(), privkey.getPrimeQ(), privkey.getPrimeExponentP(), privkey.getPrimeExponentQ(), privkey.getCrtCoefficient());
                }
                if (PKCS1EncodedPrivateKeySpec.class.isAssignableFrom(keySpec)) {
                    RSAPrivateCrtKeyImpl rsapkey = new RSAPrivateCrtKeyImpl(privkey.getModulus(), privkey.getPublicExponent(), privkey.getPrivateExponent(), privkey.getPrimeP(), privkey.getPrimeQ(), privkey.getPrimeExponentP(), privkey.getPrimeExponentQ(), privkey.getCrtCoefficient());
                    try {
                        PrivateKeyInfo pkinfo = new PrivateKeyInfo(rsapkey.getEncoded());
                        return new PKCS1EncodedPrivateKeySpec(pkinfo.getPrivateKey());
                    }
                    catch (ASN1Exception aex) {
                        return null;
                    }
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof RSAPrivateKey) {
                Class<?> c1 = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> c2 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (c1.isAssignableFrom(keySpec)) {
                    RSAPrivateKey privkey = (RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(privkey.getModulus(), privkey.getPrivateExponent());
                }
                if (c2.isAssignableFrom(keySpec)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected Key _engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof RSAPublicKey) {
                if (key instanceof RSAPublicKeyImpl) {
                    return key;
                }
                RSAPublicKeySpec keySpec = (RSAPublicKeySpec)this._engineGetKeySpec(key, RSAPublicKeySpec.class);
                return this._engineGeneratePublic(keySpec);
            }
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateCrtKeyImpl) {
                    return key;
                }
                RSAPrivateCrtKeySpec keySpec = (RSAPrivateCrtKeySpec)this._engineGetKeySpec(key, RSAPrivateCrtKeySpec.class);
                return this._engineGeneratePrivate(keySpec);
            }
            if (key instanceof RSAPrivateKey) {
                if (key instanceof RSAPrivateKeyImpl) {
                    return key;
                }
                RSAPrivateKeySpec keySpec = (RSAPrivateKeySpec)this._engineGetKeySpec(key, RSAPrivateKeySpec.class);
                return this._engineGeneratePrivate(keySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }
}

