/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.KeyPairGenerator;
import com.initech.cryptox.SecureRandom;
import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    int keySize;
    boolean genParam;
    java.security.SecureRandom random = null;
    String algorithmName;
    BigInteger modulus = null;
    BigInteger publicExponent = null;
    BigInteger privateExponent = null;
    BigInteger primeP = null;
    BigInteger primeQ = null;
    BigInteger primeExponentP = null;
    BigInteger primeExponentQ = null;
    BigInteger crtCoefficient = null;
    BigInteger ONE = new BigInteger("1");

    public RSAKeyPairGenerator() {
        this("RSA");
    }

    public RSAKeyPairGenerator(String algorithmName) {
        super(algorithmName);
        this.algorithmName = algorithmName;
        this.keySize = 2048;
        byte[] a = new byte[]{1, 0, 1};
        this.publicExponent = new BigInteger(1, a);
    }

    public void changePublicExponent(int publicExponent) {
        this.publicExponent = new BigInteger("" + publicExponent);
    }

    protected KeyPair _generateKeyPair() {
        int plen = (this.keySize + 1) / 2;
        int qlen = this.keySize - plen;
        BigInteger phiN = null;
        BigInteger primeP_1 = null;
        BigInteger primeQ_1 = null;
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("HASHDRBGSHA256", InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("[A] HASHDRBGSHA256 \u745c??\u044a???? ??????.", e);
            }
        } else {
            InitechProvider.checkKSXRandom(this.random);
        }
        try {
            while (true) {
                this.primeP = new BigInteger(plen, 50, this.random);
                this.primeP = this.primeP.setBit(0);
                if (this.primeP.clearBit(0).gcd(this.publicExponent).compareTo(this.ONE) != 0) continue;
                primeP_1 = this.primeP.clearBit(0);
                do {
                    this.primeQ = new BigInteger(qlen, 50, this.random);
                    this.primeQ = this.primeQ.setBit(0);
                } while (this.primeQ.clearBit(0).gcd(this.publicExponent).compareTo(this.ONE) != 0);
                primeQ_1 = this.primeQ.clearBit(0);
                this.modulus = this.primeP.multiply(this.primeQ);
                phiN = primeP_1.multiply(primeQ_1);
                BigInteger gcd = primeP_1.gcd(primeQ_1);
                BigInteger rambdaN = phiN.divide(gcd);
                this.privateExponent = this.publicExponent.modInverse(rambdaN);
                this.primeExponentP = this.privateExponent.mod(primeP_1);
                this.primeExponentQ = this.privateExponent.mod(primeQ_1);
                this.crtCoefficient = this.primeQ.modInverse(this.primeP);
                if (this.modulus.bitLength() % 8 == 0) break;
            }
            KeyPair keypair = this.getKeyInstance();
            this.testPairWiseConsistencyTest(keypair);
            KeyPair keyPair = keypair;
            return keyPair;
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        finally {
            if (phiN != null) {
                phiN = BigInteger.ZERO;
            }
            if (primeP_1 != null) {
                primeP_1 = BigInteger.ZERO;
            }
            if (primeQ_1 != null) {
                primeQ_1 = BigInteger.ZERO;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void testPairWiseConsistencyTest(KeyPair keypair) {
        byte[] ciphertext;
        byte[] output;
        block10: {
            PublicKey pubkey = null;
            PrivateKey privkey = null;
            byte[] plaintext = null;
            output = null;
            ciphertext = null;
            try {
                plaintext = "0123456789abcdef".getBytes();
                pubkey = keypair.getPublic();
                privkey = keypair.getPrivate();
                Cipher rsa = Cipher.getInstance("RSA", InitechProvider.NAME);
                rsa.init(1, pubkey);
                ciphertext = rsa.doFinal(plaintext);
                if (Arrays.equals(ciphertext, plaintext)) {
                    throw new KSXRuntimeException("pair-wise consistency test fail.(ciphertext=plaintext)");
                }
                rsa.init(2, privkey);
                output = rsa.doFinal(ciphertext);
                if (!Arrays.equals(output, plaintext)) {
                    throw new KSXRuntimeException("pair-wise consistency test fail.(plaintext!=output)");
                }
                if (plaintext == null) break block10;
            }
            catch (KSXRuntimeException ksxre) {
                try {
                    this.engineZeroize();
                    throw ksxre;
                    catch (Exception e) {
                        this.engineZeroize();
                        throw new KSXRuntimeException("Internal Error in pair-wise consistency test", e);
                    }
                }
                catch (Throwable throwable) {
                    if (plaintext != null) {
                        Arrays.fill(plaintext, (byte)0);
                    }
                    if (output != null) {
                        Arrays.fill(output, (byte)0);
                    }
                    if (ciphertext == null) throw throwable;
                    Arrays.fill(ciphertext, (byte)0);
                    throw throwable;
                }
            }
            Arrays.fill(plaintext, (byte)0);
        }
        if (output != null) {
            Arrays.fill(output, (byte)0);
        }
        if (ciphertext == null) return;
        Arrays.fill(ciphertext, (byte)0);
    }

    private KeyPair getKeyInstance() {
        RSAPrivateCrtKeySpec privkeyspec = new RSAPrivateCrtKeySpec(this.modulus, this.publicExponent, this.privateExponent, this.primeP, this.primeQ, this.primeExponentP, this.primeExponentQ, this.crtCoefficient);
        RSAPublicKeySpec pubkeyspec = new RSAPublicKeySpec(this.modulus, this.publicExponent);
        try {
            KeyFactory kf = KeyFactory.getInstance(this.algorithmName, InitechProvider.NAME);
            PrivateKey privkey = kf.generatePrivate(privkeyspec);
            PublicKey pubkey = kf.generatePublic(pubkeyspec);
            return new KeyPair(pubkey, privkey);
        }
        catch (Exception e) {
            throw new RuntimeException("RSA not installed");
        }
    }

    protected void _initialize(int keysize, java.security.SecureRandom random) {
        this.keySize = keysize;
        this.random = random;
    }

    protected void _initialize(AlgorithmParameterSpec params, java.security.SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException();
    }

    protected void engineZeroize() {
        if (this.modulus != null) {
            this.modulus = BigInteger.ZERO;
        }
        if (this.publicExponent != null) {
            this.publicExponent = BigInteger.ZERO;
        }
        if (this.privateExponent != null) {
            this.privateExponent = BigInteger.ZERO;
        }
        if (this.primeP != null) {
            this.primeP = BigInteger.ZERO;
        }
        if (this.primeQ != null) {
            this.primeQ = BigInteger.ZERO;
        }
        if (this.primeExponentP != null) {
            this.primeExponentP = BigInteger.ZERO;
        }
        if (this.primeExponentQ != null) {
            this.primeExponentQ = BigInteger.ZERO;
        }
        if (this.crtCoefficient != null) {
            this.crtCoefficient = BigInteger.ZERO;
        }
        if (this.random != null && this.random instanceof SecureRandom) {
            ((Zeroizable)((Object)this.random)).zeroize();
        }
    }
}

