/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.Signature;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA512;
import com.initech.provider.crypto.rsa.EMSAPKCS15Codec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSAPKCS1v15Signature
extends Signature {
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private MessageDigest hash;
    private String hashAlg;
    private EMSAPKCS15Codec pkcs1;

    public RSAPKCS1v15Signature() throws NoSuchAlgorithmException, NoSuchProviderException {
        this("SHA-256");
    }

    public RSAPKCS1v15Signature(String alg) throws NoSuchAlgorithmException, NoSuchProviderException {
        super(alg + "withRSAPKCS1v1_5");
        this.hashAlg = alg;
        if (alg.equalsIgnoreCase("SHA1")) {
            this.hash = new SHA1();
            this.pkcs1 = new EMSAPKCS15Codec(this.hash);
        } else if (alg.equalsIgnoreCase("SHA-224") || alg.equalsIgnoreCase("SHA224")) {
            this.hash = new SHA224();
            this.pkcs1 = new EMSAPKCS15Codec(this.hash);
        } else if (alg.equalsIgnoreCase("SHA-256") || alg.equalsIgnoreCase("SHA256")) {
            this.hash = new SHA256();
            this.pkcs1 = new EMSAPKCS15Codec(this.hash);
        } else if (alg.equalsIgnoreCase("SHA-384") || alg.equalsIgnoreCase("SHA384")) {
            this.hash = new SHA384();
            this.pkcs1 = new EMSAPKCS15Codec(this.hash);
        } else if (alg.equalsIgnoreCase("SHA-512") || alg.equalsIgnoreCase("SHA512")) {
            this.hash = new SHA512();
            this.pkcs1 = new EMSAPKCS15Codec(this.hash);
        } else {
            this.hash = MessageDigest.getInstance(alg, InitechProvider.NAME);
            this.pkcs1 = new EMSAPKCS15Codec(this.hash);
        }
    }

    protected Object _engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    protected void _engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (RSAPrivateKey)privateKey;
        this.hash.reset();
    }

    protected void _engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (RSAPublicKey)publicKey;
        this.hash.reset();
    }

    protected void _engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected byte[] _engineSign() throws SignatureException {
        byte[] byArray;
        BigInteger s;
        BigInteger m;
        block9: {
            byte[] EM = null;
            m = null;
            s = null;
            try {
                int modBits = this.privateKey.getModulus().bitLength();
                int k = (modBits + 7) / 8;
                EM = this.pkcs1.encode(this.hash.digest(), k);
                m = new BigInteger(1, EM);
                s = this.RSADP(m);
                byArray = this.I2OSP(s, k);
                if (EM == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new SignatureException();
                }
                catch (Throwable throwable) {
                    if (EM != null) {
                        Arrays.fill(EM, (byte)0);
                    }
                    if (m != null) {
                        m = BigInteger.ZERO;
                    }
                    if (s != null) {
                        s = BigInteger.ZERO;
                    }
                    throw throwable;
                }
            }
            Arrays.fill(EM, (byte)0);
        }
        if (m != null) {
            m = BigInteger.ZERO;
        }
        if (s != null) {
            s = BigInteger.ZERO;
        }
        return byArray;
    }

    private BigInteger RSADP(BigInteger c) {
        BigInteger n = this.privateKey.getModulus();
        if (c.compareTo(BigInteger.ZERO) < 0 || c.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        BigInteger result = c.modPow(this.privateKey.getPrivateExponent(), this.privateKey.getModulus());
        n = BigInteger.ZERO;
        return result;
    }

    private BigInteger RSAEP(BigInteger m) {
        BigInteger n = this.publicKey.getModulus();
        if (m.compareTo(BigInteger.ZERO) < 0 || m.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        BigInteger e = this.publicKey.getPublicExponent();
        BigInteger result = m.modPow(e, n);
        n = BigInteger.ZERO;
        e = BigInteger.ZERO;
        return result;
    }

    public byte[] I2OSP(BigInteger s, int k) {
        byte[] result = s.toByteArray();
        if (result.length < k) {
            byte[] newResult = new byte[k];
            System.arraycopy(result, 0, newResult, k - result.length, result.length);
            result = newResult;
        } else if (result.length > k) {
            int limit = result.length - k;
            for (int i = 0; i < limit; ++i) {
                if (result[i] == 0) continue;
                throw new IllegalArgumentException("integer too large");
            }
            byte[] newResult = new byte[k];
            System.arraycopy(result, limit, newResult, 0, k);
            result = newResult;
        }
        return result;
    }

    protected void _engineUpdate(byte b) throws SignatureException {
        this.hash.update(b);
    }

    protected void _engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.hash.update(b, off, len);
    }

    protected boolean _engineVerify(byte[] sigBytes) throws SignatureException {
        int modBits = this.publicKey.getModulus().bitLength();
        int k = (modBits + 7) / 8;
        if (sigBytes.length != k) {
            return false;
        }
        BigInteger s = new BigInteger(1, sigBytes);
        BigInteger m = this.RSAEP(s);
        byte[] EM = this.I2OSP(m, k);
        byte[] EMp = this.pkcs1.encode(this.hash.digest(), k);
        return Arrays.equals(EM, EMp);
    }
}

