/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.SecureRandom;
import com.initech.cryptox.Signature;
import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.rsa.EMSAPSSCodec;
import com.initech.provider.crypto.spec.RSAPSSParameterSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class RSAPSSSignature
extends Signature {
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private MessageDigest hash;
    private String hashAlg;
    private String algId;
    private EMSAPSSCodec pss;
    RSAPSSParameterSpec pssparm = null;

    public RSAPSSSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
        this("SHA1");
    }

    public RSAPSSSignature(String alg) throws NoSuchAlgorithmException, NoSuchProviderException {
        super(alg + "withRSAPSS");
        this.hashAlg = alg;
        this.algId = "1.2.840.113549.1.1.10";
        try {
            this.hash = MessageDigest.getInstance(this.hashAlg, InitechProvider.NAME);
            this.pss = new EMSAPSSCodec(this.hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("NoSuchAlgorithm: " + this.hashAlg);
        }
    }

    public RSAPSSSignature(MessageDigest md) throws NoSuchAlgorithmException, NoSuchProviderException {
        super(md.getAlgorithm() + "withRSAPSS");
        this.hash = md;
        this.hashAlg = md.getAlgorithm();
        this.algId = "1.2.840.113549.1.1.10";
        this.pss = new EMSAPSSCodec(md);
    }

    protected Object _engineGetParameter(String param) throws InvalidParameterException {
        return this.pssparm;
    }

    protected void _engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.pssparm = (RSAPSSParameterSpec)params;
    }

    protected void _engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (RSAPrivateKey)privateKey;
        this.hash.reset();
    }

    protected void _engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (RSAPublicKey)publicKey;
        this.hash.reset();
    }

    protected void _engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected byte[] _engineSign() throws SignatureException {
        byte[] salt;
        if (this.pssparm == null) {
            salt = new byte[this.hash.getDigestLength()];
            try {
                SecureRandom sr = SecureRandom.getInstance("HASHDRBGSHA256", InitechProvider.NAME);
                sr.nextBytes(salt);
                ((Zeroizable)sr).zeroize();
            }
            catch (Exception e) {
                throw new SignatureException("fail to generate salt");
            }
            this.pssparm = new RSAPSSParameterSpec(salt);
        }
        salt = this.pssparm.getSalt();
        this.pssparm = null;
        byte[] EM = null;
        BigInteger m = null;
        BigInteger s = null;
        try {
            int modBits = this.privateKey.getModulus().bitLength();
            try {
                EM = this.pss.encode(this.hash.digest(), modBits - 1, salt);
            }
            catch (CloneNotSupportedException e) {
                throw new SignatureException("digiest-" + this.hashAlg + " is not clonable class");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
            m = new BigInteger(1, EM);
            s = this.RSADP(m);
            int k = (modBits + 7) / 8;
            byte[] byArray = this.I2OSP(s, k);
            return byArray;
        }
        catch (Exception e) {
            throw new SignatureException();
        }
        finally {
            if (salt != null) {
                Arrays.fill(salt, (byte)0);
            }
            if (m != null) {
                m = BigInteger.ZERO;
            }
            if (s != null) {
                s = BigInteger.ZERO;
            }
        }
    }

    private BigInteger RSADP(BigInteger c) {
        BigInteger n = this.privateKey.getModulus();
        if (c.compareTo(BigInteger.ZERO) < 0 || c.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        BigInteger result = c.modPow(this.privateKey.getPrivateExponent(), this.privateKey.getModulus());
        n = BigInteger.ZERO;
        return result;
    }

    private BigInteger RSAEP(BigInteger m) {
        BigInteger n = this.publicKey.getModulus();
        if (m.compareTo(BigInteger.ZERO) < 0 || m.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        BigInteger e = this.publicKey.getPublicExponent();
        BigInteger result = m.modPow(e, n);
        n = BigInteger.ZERO;
        e = BigInteger.ZERO;
        return result;
    }

    public byte[] I2OSP(BigInteger s, int k) {
        byte[] result = s.toByteArray();
        if (result.length < k) {
            byte[] newResult = new byte[k];
            System.arraycopy(result, 0, newResult, k - result.length, result.length);
            result = newResult;
        } else if (result.length > k) {
            int limit = result.length - k;
            for (int i = 0; i < limit; ++i) {
                if (result[i] == 0) continue;
                throw new IllegalArgumentException("integer too large");
            }
            byte[] newResult = new byte[k];
            System.arraycopy(result, limit, newResult, 0, k);
            result = newResult;
        }
        return result;
    }

    protected void _engineUpdate(byte b) throws SignatureException {
        this.hash.update(b);
    }

    protected void _engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.hash.update(b, off, len);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean _engineVerify(byte[] sigBytes) throws SignatureException {
        boolean bl;
        byte[] EM;
        BigInteger m;
        BigInteger s;
        block21: {
            boolean bl2;
            block19: {
                block20: {
                    s = null;
                    m = null;
                    EM = null;
                    try {
                        int modBits;
                        int k;
                        if (this.pssparm == null) {
                            this.pssparm = new RSAPSSParameterSpec(this.hash.getDigestLength());
                        }
                        if (sigBytes.length != (k = ((modBits = this.publicKey.getModulus().bitLength()) + 7) / 8)) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        s = new BigInteger(1, sigBytes);
                        m = this.RSAEP(s);
                        int emBits = modBits - 1;
                        int emLen = (emBits + 7) / 8;
                        EM = m.toByteArray();
                        if (EM.length > emLen) {
                            bl2 = false;
                            this.pssparm = null;
                            if (EM == null) break block19;
                            break block20;
                        }
                        if (EM.length < emLen) {
                            byte[] newEM = new byte[emLen];
                            System.arraycopy(EM, 0, newEM, emLen - EM.length, EM.length);
                            EM = newEM;
                        }
                        boolean result = false;
                        try {
                            byte[] mHash = this.hash.digest();
                            result = this.pss.decode(mHash, EM, emBits, this.pssparm.getSize());
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                            result = false;
                        }
                        bl = result;
                        this.pssparm = null;
                        break block21;
                    }
                    catch (Exception e) {
                        throw new SignatureException();
                    }
                }
                Arrays.fill(EM, (byte)0);
            }
            if (m != null) {
                m = BigInteger.ZERO;
            }
            if (s == null) return bl2;
            s = BigInteger.ZERO;
            return bl2;
        }
        if (EM != null) {
            Arrays.fill(EM, (byte)0);
        }
        if (m != null) {
            m = BigInteger.ZERO;
        }
        if (s == null) return bl;
        s = BigInteger.ZERO;
        return bl;
        finally {
            this.pssparm = null;
            if (EM != null) {
                Arrays.fill(EM, (byte)0);
            }
            if (m != null) {
                m = BigInteger.ZERO;
            }
            if (s != null) {
                s = BigInteger.ZERO;
            }
        }
    }
}

