/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.Zeroizable;
import com.initech.cryptox.util.Hex;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class RSAPrivateCrtKeyImpl
implements Zeroizable,
RSAPrivateCrtKey {
    private static final long serialVersionUID = -5702261624351985911L;
    private int version;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private AlgorithmID privateKeyAlgorithm;
    private PrivateKeyInfo pkinfo = new PrivateKeyInfo();
    private boolean modified = true;

    public RSAPrivateCrtKeyImpl(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        this(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient, new AlgorithmID("1.2.840.113549.1.1.1", null));
    }

    public RSAPrivateCrtKeyImpl(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient, AlgorithmID privateKeyAlgorithmID) {
        this.setVersion(0);
        this.setModulus(modulus);
        this.setPublicExponent(publicExponent);
        this.setPrivateExponent(privateExponent);
        this.setPrimeP(primeP);
        this.setPrimeQ(primeQ);
        this.setPrimeExponentP(primeExponentP);
        this.setPrimeExponentQ(primeExponentQ);
        this.setCrtCoefficient(crtCoefficient);
        this.setPrivateKeyAlgorithm(privateKeyAlgorithmID);
    }

    public RSAPrivateCrtKeyImpl(byte[] byteArray) throws InvalidKeyException {
        try {
            this.pkinfo = new PrivateKeyInfo(byteArray);
            if (!this.pkinfo.getAlgorithm().equals("1.2.840.113549.1.1.1") && !this.pkinfo.getAlgorithm().equals("1.2.840.113549.1.1.10")) {
                throw new InvalidKeyException("this algorithm is not RSA");
            }
            this.setPrivateKeyAlgorithm(new AlgorithmID(this.pkinfo.getAlgorithm(), this.pkinfo.getParameters()));
            DERDecoder dec = new DERDecoder(this.pkinfo.getPrivateKey());
            int id = dec.decodeSequence();
            this.version = dec.decodeIntegerAsInt();
            this.modulus = dec.decodeInteger();
            this.publicExponent = dec.decodeInteger();
            this.privateExponent = dec.decodeInteger();
            this.primeP = dec.decodeInteger();
            this.primeQ = dec.decodeInteger();
            this.primeExponentP = dec.decodeInteger();
            this.primeExponentQ = dec.decodeInteger();
            this.crtCoefficient = dec.decodeInteger();
            dec.endOf(id);
            this.modified = false;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public RSAPrivateCrtKeyImpl(byte[] byteArray, AlgorithmID algorithmID) throws InvalidKeyException {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(byteArray);
            if (!algorithmID.getAlg().equals("1.2.840.113549.1.1.1") && !algorithmID.getAlg().equals("1.2.840.113549.1.1.10")) {
                throw new InvalidKeyException("this algorithm is not RSA");
            }
            this.setPrivateKeyAlgorithm(algorithmID);
            DERDecoder dec = new DERDecoder(privateKeyInfo.getPrivateKey());
            int id = dec.decodeSequence();
            this.version = dec.decodeIntegerAsInt();
            this.modulus = dec.decodeInteger();
            this.publicExponent = dec.decodeInteger();
            this.privateExponent = dec.decodeInteger();
            this.primeP = dec.decodeInteger();
            this.primeQ = dec.decodeInteger();
            this.primeExponentP = dec.decodeInteger();
            this.primeExponentQ = dec.decodeInteger();
            this.crtCoefficient = dec.decodeInteger();
            dec.endOf(id);
            privateKeyInfo.setPrivateKeyAlgorithm(algorithmID);
            this.pkinfo = privateKeyInfo;
            this.modified = false;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public void setVersion(int v) {
        this.modified = true;
        this.version = v;
    }

    public void setModulus(BigInteger i) {
        this.modified = true;
        this.modulus = i;
    }

    public void setPublicExponent(BigInteger p) {
        this.modified = true;
        this.publicExponent = p;
    }

    public void setPrivateExponent(BigInteger p) {
        this.modified = true;
        this.privateExponent = p;
    }

    public void setPrimeP(BigInteger p1) {
        this.modified = true;
        this.primeP = p1;
    }

    public void setPrimeQ(BigInteger p2) {
        this.modified = true;
        this.primeQ = p2;
    }

    public void setPrimeExponentP(BigInteger e1) {
        this.modified = true;
        this.primeExponentP = e1;
    }

    public void setPrimeExponentQ(BigInteger e2) {
        this.modified = true;
        this.primeExponentQ = e2;
    }

    public void setCrtCoefficient(BigInteger c) {
        this.modified = true;
        this.crtCoefficient = c;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public void setPrivateKeyAlgorithm(AlgorithmID id) {
        this.modified = true;
        this.privateKeyAlgorithm = (AlgorithmID)id.clone();
    }

    public AlgorithmID getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public String getAlgorithm() {
        return this.privateKeyAlgorithm.getAlgName();
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.pkinfo.getEncoded();
            }
            this.pkinfo.setPrivateKeyAlgorithm(this.privateKeyAlgorithm);
            DEREncoder enc = new DEREncoder();
            int id = enc.encodeSequence();
            enc.encodeInteger(this.version);
            enc.encodeInteger(this.modulus);
            enc.encodeInteger(this.publicExponent);
            enc.encodeInteger(this.privateExponent);
            enc.encodeInteger(this.primeP);
            enc.encodeInteger(this.primeQ);
            enc.encodeInteger(this.primeExponentP);
            enc.encodeInteger(this.primeExponentQ);
            enc.encodeInteger(this.crtCoefficient);
            enc.endOf(id);
            byte[] key = enc.toByteArray();
            this.pkinfo.setPrivateKey(key);
            byte[] ret = this.pkinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RSAPrivateKey)) {
            return false;
        }
        RSAPrivateKey p = (RSAPrivateKey)o;
        if (!this.modulus.equals(p.getModulus())) {
            return false;
        }
        return this.privateExponent.equals(p.getPrivateExponent());
    }

    public int hashCode() {
        if (this.modulus == null || this.privateExponent == null) {
            return 0;
        }
        return this.modulus.hashCode() * this.privateExponent.hashCode();
    }

    public String toString() {
        String s = "";
        s = "Private Key Algorithm : " + this.privateKeyAlgorithm.getAlgName() + "\n";
        s = s + "Modules :\n";
        s = s + Hex.prettyDump(this.modulus.toByteArray(), 40, ':');
        s = s + "\n\nPublicExponent :\n";
        s = s + Hex.prettyDump(this.publicExponent.toByteArray(), 40, ':');
        s = s + "\n\nPrivateExponent :\n";
        s = s + Hex.prettyDump(this.privateExponent.toByteArray(), 40, ':');
        s = s + "\n\nPrime P:\n";
        s = s + Hex.prettyDump(this.primeP.toByteArray(), 40, ':');
        s = s + "\n\nPrime Q:\n";
        s = s + Hex.prettyDump(this.primeQ.toByteArray(), 40, ':');
        s = s + "\n\nPrime P exponent:\n";
        s = s + Hex.prettyDump(this.primeExponentP.toByteArray(), 40, ':');
        s = s + "\n\nPrime Q exponent:\n";
        s = s + Hex.prettyDump(this.primeExponentQ.toByteArray(), 40, ':');
        s = s + "\n\nChReminder coeff:\n";
        s = s + Hex.prettyDump(this.crtCoefficient.toByteArray(), 40, ':');
        return s;
    }

    public void zeroize() {
        if (this.modulus != null) {
            this.modulus = BigInteger.ZERO;
        }
        if (this.publicExponent != null) {
            this.publicExponent = BigInteger.ZERO;
        }
        if (this.privateExponent != null) {
            this.privateExponent = BigInteger.ZERO;
        }
        if (this.primeP != null) {
            this.primeP = BigInteger.ZERO;
        }
        if (this.primeQ != null) {
            this.primeQ = BigInteger.ZERO;
        }
        if (this.primeExponentP != null) {
            this.primeExponentP = BigInteger.ZERO;
        }
        if (this.primeExponentQ != null) {
            this.primeExponentQ = BigInteger.ZERO;
        }
        if (this.crtCoefficient != null) {
            this.crtCoefficient = BigInteger.ZERO;
        }
        if (this.privateKeyAlgorithm != null) {
            this.privateKeyAlgorithm = null;
        }
        this.modified = true;
    }
}

