/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.util.Hex;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateKey;

public class RSAPrivateKeyImpl
implements RSAPrivateKey {
    private static final long serialVersionUID = -4919481925611814890L;
    private BigInteger mod;
    private BigInteger privExp;
    private AlgorithmID privateKeyAlgorithm;
    private PrivateKeyInfo pkinfo = new PrivateKeyInfo();
    private boolean modified = true;

    public RSAPrivateKeyImpl(BigInteger modulus, BigInteger privateExponent) {
        this(modulus, privateExponent, new AlgorithmID("1.2.840.113549.1.1.1", null));
    }

    public RSAPrivateKeyImpl(BigInteger modulus, BigInteger privateExponent, AlgorithmID privateKeyAlgorithmID) {
        this.setModulus(modulus);
        this.setPrivateExponent(privateExponent);
        this.setPrivateKeyAlgorithm(privateKeyAlgorithmID);
    }

    public RSAPrivateKeyImpl(byte[] byteArray) throws InvalidKeyException {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(byteArray);
            if (!privateKeyInfo.getAlgorithm().equals("1.2.840.113549.1.1.1") && !privateKeyInfo.getAlgorithm().equals("1.2.840.113549.1.1.10")) {
                throw new InvalidKeyException("this algorithm is not RSA");
            }
            this.setPrivateKeyAlgorithm(new AlgorithmID(privateKeyInfo.getAlgorithm(), privateKeyInfo.getParameters()));
            DERDecoder dec = new DERDecoder(privateKeyInfo.getPrivateKey());
            int id = dec.decodeSequence();
            this.mod = dec.decodeInteger();
            this.privExp = dec.decodeInteger();
            dec.endOf(id);
            this.modified = false;
            this.pkinfo = privateKeyInfo;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public RSAPrivateKeyImpl(byte[] byteArray, AlgorithmID algorithmID) throws InvalidKeyException {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(byteArray);
            if (!algorithmID.getAlg().equals("1.2.840.113549.1.1.1") && !algorithmID.getAlg().equals("1.2.840.113549.1.1.10")) {
                throw new InvalidKeyException("this algorithm is not RSA");
            }
            this.setPrivateKeyAlgorithm(algorithmID);
            DERDecoder dec = new DERDecoder(privateKeyInfo.getPrivateKey());
            int id = dec.decodeSequence();
            this.mod = dec.decodeInteger();
            this.privExp = dec.decodeInteger();
            dec.endOf(id);
            privateKeyInfo.setPrivateKeyAlgorithm(algorithmID);
            this.pkinfo = privateKeyInfo;
            this.modified = false;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public void setModulus(BigInteger i) {
        this.modified = true;
        this.mod = i;
    }

    public void setPrivateExponent(BigInteger pe) {
        this.modified = true;
        this.privExp = pe;
    }

    public BigInteger getModulus() {
        return this.mod;
    }

    public BigInteger getPrivateExponent() {
        return this.privExp;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public String getAlgorithm() {
        return this.privateKeyAlgorithm.getAlgName();
    }

    public void setPrivateKeyAlgorithm(AlgorithmID id) {
        this.modified = true;
        this.privateKeyAlgorithm = (AlgorithmID)id.clone();
    }

    public AlgorithmID getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.pkinfo.getEncoded();
            }
            this.pkinfo.setPrivateKeyAlgorithm(this.privateKeyAlgorithm);
            DEREncoder enc = new DEREncoder();
            int id = enc.encodeSequence();
            enc.encodeInteger(this.mod);
            enc.encodeInteger(this.privExp);
            enc.endOf(id);
            byte[] key = enc.toByteArray();
            this.pkinfo.setPrivateKey(key);
            byte[] ret = this.pkinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RSAPrivateKey)) {
            return false;
        }
        RSAPrivateKey p = (RSAPrivateKey)o;
        if (!this.mod.equals(p.getModulus())) {
            return false;
        }
        return this.privExp.equals(p.getPrivateExponent());
    }

    public int hashCode() {
        if (this.mod == null || this.privExp == null) {
            return 0;
        }
        return this.mod.hashCode() * this.privExp.hashCode();
    }

    public String toString() {
        String s = "";
        s = "Private Key Algorithm : " + this.privateKeyAlgorithm.getAlgName() + "\n";
        s = s + "Modules :\n";
        s = s + Hex.prettyDump(this.mod.toByteArray(), 40, ':');
        s = s + "\n\nPrivateExponent :\n";
        s = s + Hex.prettyDump(this.privExp.toByteArray(), 40, ':');
        return s;
    }

    public void zeroize() {
        if (this.mod != null) {
            this.mod = BigInteger.ZERO;
        }
        if (this.privExp != null) {
            this.privExp = BigInteger.ZERO;
        }
        if (this.privateKeyAlgorithm != null) {
            this.privateKeyAlgorithm = null;
        }
        this.modified = true;
    }
}

