/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.cryptox.Zeroizable;
import com.initech.cryptox.util.Hex;
import com.initech.cryptox.util.StringUtil;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPublicKey;

public class RSAPublicKeyImpl
implements Zeroizable,
RSAPublicKey {
    private BigInteger mod;
    private BigInteger pubExp;
    private AlgorithmID algId;
    private PublicKeyInfo kinfo;
    private boolean modified = false;

    public RSAPublicKeyImpl(BigInteger modulus, BigInteger publicExponent) {
        this(modulus, publicExponent, new AlgorithmID("1.2.840.113549.1.1.1", null));
    }

    public RSAPublicKeyImpl(BigInteger modulus, BigInteger publicExponent, AlgorithmID algorithmID) {
        this.kinfo = new PublicKeyInfo();
        this.setModulus(modulus);
        this.setPublicExponent(publicExponent);
        this.setAlgId(algorithmID);
    }

    public RSAPublicKeyImpl(byte[] byteArray) throws InvalidKeyException {
        try {
            PublicKeyInfo pubKeyInfo = new PublicKeyInfo(byteArray);
            if (!pubKeyInfo.getAlg().equals("1.2.840.113549.1.1.1") && !pubKeyInfo.getAlg().equals("1.2.840.113549.1.1.10")) {
                throw new InvalidKeyException("this algorithm is not RSA");
            }
            this.setAlgId(new AlgorithmID(pubKeyInfo.getAlg(), pubKeyInfo.getAlgParameter()));
            DERDecoder dec = new DERDecoder(pubKeyInfo.getPublicKeyAsByteArray());
            int id = dec.decodeSequence();
            this.mod = dec.decodeInteger();
            this.pubExp = dec.decodeInteger();
            dec.endOf(id);
            this.kinfo = pubKeyInfo;
            this.modified = false;
        }
        catch (Exception ex) {
            throw new InvalidKeyException(ex.toString());
        }
    }

    public RSAPublicKeyImpl(byte[] byteArray, AlgorithmID algorithmID) throws InvalidKeyException {
        try {
            PublicKeyInfo pubKeyInfo = new PublicKeyInfo(byteArray);
            if (!algorithmID.getAlg().equals("1.2.840.113549.1.1.1") && !algorithmID.getAlg().equals("1.2.840.113549.1.1.10")) {
                throw new InvalidKeyException("this algorithm is not RSA");
            }
            this.setAlgId(algorithmID);
            DERDecoder dec = new DERDecoder(pubKeyInfo.getPublicKeyAsByteArray());
            int id = dec.decodeSequence();
            this.mod = dec.decodeInteger();
            this.pubExp = dec.decodeInteger();
            dec.endOf(id);
            pubKeyInfo.setAlgorithm(algorithmID);
            this.kinfo = pubKeyInfo;
            this.modified = false;
        }
        catch (Exception ex) {
            throw new InvalidKeyException(ex.toString());
        }
    }

    public void setModulus(BigInteger i) {
        this.modified = true;
        this.mod = i;
    }

    public void setPublicExponent(BigInteger pe) {
        this.modified = true;
        this.pubExp = pe;
    }

    public BigInteger getModulus() {
        return this.mod;
    }

    public BigInteger getPublicExponent() {
        return this.pubExp;
    }

    public String getFormat() {
        return "X.509";
    }

    public String getAlgorithm() {
        return this.algId.getAlgName();
    }

    public void setAlgId(AlgorithmID id) {
        this.modified = true;
        this.algId = (AlgorithmID)id.clone();
    }

    public AlgorithmID getAlgId() {
        return this.algId;
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.kinfo.getEncoded();
            }
            this.kinfo.setAlgName(this.algId.getAlg());
            this.kinfo.setAlgParameter(null);
            DEREncoder enc = new DEREncoder();
            int id = enc.encodeSequence();
            enc.encodeInteger(this.mod);
            enc.encodeInteger(this.pubExp);
            enc.endOf(id);
            byte[] key = enc.toByteArray();
            this.kinfo.setPublicKey(key);
            byte[] ret = this.kinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey p = (RSAPublicKey)o;
        if (!this.mod.equals(p.getModulus())) {
            return false;
        }
        return this.pubExp.equals(p.getPublicExponent());
    }

    public int hashCode() {
        if (this.mod == null || this.pubExp == null) {
            return 0;
        }
        return this.mod.hashCode() * this.pubExp.hashCode();
    }

    public void toString(StringBuffer buf, int n) {
        StringUtil.indent(buf, n);
        buf.append("Public Key Algorithm : " + this.algId.getAlgName() + "\n");
        StringUtil.indent(buf, n);
        buf.append("RSA Public Key: (");
        buf.append(this.mod.bitLength());
        buf.append(" bit)\n");
        StringUtil.indent(buf, n + 1);
        buf.append("Modulus (");
        buf.append(this.mod.bitLength());
        buf.append(" bit)\n");
        buf.append(Hex.prettyDump(this.mod.toByteArray(), 48, ':', n + 2));
        buf.append('\n');
        StringUtil.indent(buf, n + 1);
        buf.append("Exponent: ");
        buf.append(this.pubExp.intValue());
        buf.append("(0x");
        buf.append(this.pubExp.toString(16));
        buf.append(")\n");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, 0);
        return new String(buf);
    }

    public void zeroize() {
        if (this.mod != null) {
            this.mod = BigInteger.ZERO;
        }
        if (this.pubExp != null) {
            this.pubExp = BigInteger.ZERO;
        }
        this.modified = true;
    }
}

