/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.SelfTestCase;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.rsa.RSAPKCS1v15Signature;
import com.initech.provider.crypto.rsa.RSAPSSSignature;
import com.initech.provider.crypto.rsa.RSAPrivateKeyImpl;
import com.initech.provider.crypto.rsa.RSAPublicKeyImpl;
import com.initech.provider.crypto.spec.RSAPSSParameterSpec;
import java.math.BigInteger;

public class RSASignSelfTestCase
implements SelfTestCase {
    static BigInteger n = new BigInteger("00E0284C35CA731948BE79C0A30FA892DE1947CB5748E0664B5A50460C48F5EA21FFC9FED4FA33B69DBCCFB4E0820E338F6D9A5D5C5F15129A60FD4D0547037DD741DC0BAC56C472DEABADA556E3EC29171C68229DCD49702978A094C55F5AA41C7821EB6CF870729D84ED8EFC5918D1D2178CC7FF0B9DB3BDFFE3C57E30431D23", 16);
    static BigInteger e = new BigInteger("3");
    static BigInteger d = new BigInteger("00957032CE86F766307EFBD5C20A7061E9662FDCE4DB4044323C35840830A3F16BFFDBFF38A6CD2469288A7895AC0977B4F3BC3E3D94B8B71195FE3358DA0253E396A90E2D8F28457A5E9DF0A0C9C79AF612E1CFE65FF62A81F1199A8D286A343881D17CA5586486EB1941B0AEEE7B6D6176365EEC57852E93000227B5E1A99F4B", 16);
    static BigInteger n2 = new BigInteger("a158d0b6a1a1b401b156c8fa50acb2f4ae8c9ca2c73f7a729d0eb54aa2fcb6be4f7ee6946904eba21a10e522fe6ff919fe2fd38f5580f60abb62b02c2ed4a117a74bdd101def4b1dea200c49ba0738a30cb9b13d81caad9f5b42238d0f61389c07ba7de10f15cf243fab5feb39e44484e986e5ff6203d757399b2ee11f11c932ee708f28d151a6df80c3bfca5a6129bd0866baf1a0fca02914ca844da9b876282508e33714c2a3841c92b77c33ab4141ef3c3770e36ddf6a9e0a18e529d097a7f39d64ae0b02fd496d9ad3705bf078dbd77ad1b5923995ffd9ff7f951d04f07ea3fb687862400985701a6f0ddc544d17df6a0fe3e1108f425ab4286502f9ddb3", 16);
    static BigInteger e2 = new BigInteger("10001", 16);
    static BigInteger d2 = new BigInteger("01e5ec96a972208f008a17d5320bc61330d680a53d98d694f09a12b1ed16f2036d25fe0a72edd6e3d250ae9169d2e16857e03229f6848ce07571e4c6b04a5a16d0260954be356979d19e4ce6b5248e9b04744ecc7d7167f77ef85938b89c9930e4ba61eebae1b3cd265e9ac346ac13ce487d08c9a75a8a37017b7ce2b31ddf7310131f188d82e94bd2b6353d3202e9601d5f0f58376d5650e2078c7c44ab335bf67a064feddfad315ddec098c8a283ca744294ce40921ceb84ecc7b19779de8bb9709dc66a234f5266cbb98b3fe2bb540108e7ee7746d45b28b2a08a6a7b37ed59cba13caf03f88a044b684344e26cbbc38668b163c31e94151c32df4fe2db61", 16);
    static byte[] input = Hex.parseHexaString("fc529dbd0e82f3d6cd1686a819673d79243feaefae4dcfa4f86d582cd0730fd21a0d669b1ca399edc9276bb4be67f2ca6ec319b14eb46164a2813824a58ee866ddda90a88d49200f223fdb640a253c71c630a47496bcb2b429fdbf8de7caabd6d31790551ab193a41f8166d1739841e89f6465966678b3e56c5e80309e2723f2");

    void testRSAPKCS() throws KSXRuntimeException {
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(n, e);
            RSAPrivateKeyImpl privateKey = new RSAPrivateKeyImpl(n, d);
            RSAPKCS1v15Signature sign = new RSAPKCS1v15Signature("SHA1");
            sign._engineInitSign(privateKey);
            sign._engineUpdate(input, 0, input.length);
            byte[] signature = sign._engineSign();
            sign = new RSAPKCS1v15Signature("SHA1");
            sign._engineInitVerify(publicKey);
            sign._engineUpdate(input, 0, input.length);
            if (!sign._engineVerify(signature)) {
                throw new KSXRuntimeException("RSAPKCS SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("RSAPKCS SelfTest Error", e);
        }
    }

    void testRSAPKCS2048() throws KSXRuntimeException {
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(n2, e2);
            RSAPrivateKeyImpl privateKey = new RSAPrivateKeyImpl(n2, d2);
            RSAPKCS1v15Signature sign = new RSAPKCS1v15Signature("SHA256");
            sign._engineInitSign(privateKey);
            sign._engineUpdate(input, 0, input.length);
            byte[] signature = sign._engineSign();
            sign = new RSAPKCS1v15Signature("SHA256");
            sign._engineInitVerify(publicKey);
            sign._engineUpdate(input, 0, input.length);
            if (!sign._engineVerify(signature)) {
                throw new KSXRuntimeException("RSAPKCS_2048 SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("RSAPKCS_2048 SelfTest Error", e);
        }
    }

    void testRSAPSS() throws KSXRuntimeException {
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(n, e);
            RSAPrivateKeyImpl privateKey = new RSAPrivateKeyImpl(n, d);
            RSAPSSSignature sign = new RSAPSSSignature(new SHA1());
            sign._engineSetParameter(new RSAPSSParameterSpec(new byte[20]));
            sign._engineInitSign(privateKey);
            sign._engineUpdate(input, 0, input.length);
            byte[] signature = sign._engineSign();
            sign = new RSAPSSSignature(new SHA1());
            sign._engineSetParameter(new RSAPSSParameterSpec(new byte[20]));
            sign._engineInitVerify(publicKey);
            sign._engineUpdate(input, 0, input.length);
            if (!sign._engineVerify(signature)) {
                throw new KSXRuntimeException("RSAPSS SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("RSAPSS SelfTest Error", e);
        }
    }

    void testRSAPSS2048_SHA224() throws KSXRuntimeException {
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(n2, e2);
            RSAPrivateKeyImpl privateKey = new RSAPrivateKeyImpl(n2, d2);
            RSAPSSSignature sign = new RSAPSSSignature(new SHA224());
            sign._engineSetParameter(new RSAPSSParameterSpec(new byte[28]));
            sign._engineInitSign(privateKey);
            sign._engineUpdate(input, 0, input.length);
            byte[] signature = sign._engineSign();
            sign = new RSAPSSSignature(new SHA224());
            sign._engineSetParameter(new RSAPSSParameterSpec(new byte[28]));
            sign._engineInitVerify(publicKey);
            sign._engineUpdate(input, 0, input.length);
            if (!sign._engineVerify(signature)) {
                throw new KSXRuntimeException("SHA224RSAPSS SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("SHA224RSAPSS SelfTest Error", e);
        }
    }

    void testRSAPSS2048_SHA256() throws KSXRuntimeException {
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(n2, e2);
            RSAPrivateKeyImpl privateKey = new RSAPrivateKeyImpl(n2, d2);
            RSAPSSSignature sign = new RSAPSSSignature(new SHA256());
            sign._engineSetParameter(new RSAPSSParameterSpec(new byte[32]));
            sign._engineInitSign(privateKey);
            sign._engineUpdate(input, 0, input.length);
            byte[] signature = sign._engineSign();
            sign = new RSAPSSSignature(new SHA256());
            sign._engineSetParameter(new RSAPSSParameterSpec(new byte[32]));
            sign._engineInitVerify(publicKey);
            sign._engineUpdate(input, 0, input.length);
            if (!sign._engineVerify(signature)) {
                throw new KSXRuntimeException("SHA256RSAPSS SelfTest Failed");
            }
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("SHA256RSAPSS SelfTest Error", e);
        }
    }

    public void selfTest() {
        this.testRSAPSS2048_SHA224();
        this.testRSAPSS2048_SHA256();
    }
}

