/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.rsa;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.Signature;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.rsa.DigestInfo;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSASignature
extends Signature {
    MessageDigest md = null;
    RSAPrivateKey privkey = null;
    String algId;
    RSAPublicKey pubkey = null;
    String hashAlg;

    public RSASignature(String alg, String algId) {
        super(alg + "withRSA");
        try {
            this.md = MessageDigest.getInstance(alg, InitechProvider.NAME);
            this.hashAlg = alg;
        }
        catch (Exception e) {
            throw new RuntimeException(alg + " is not installed");
        }
        this.algId = algId;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void _engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privkey = (RSAPrivateKey)privateKey;
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance(this.hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException(this.hashAlg + " is not installed");
            }
        }
        this.md.reset();
    }

    protected void _engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.pubkey = (RSAPublicKey)publicKey;
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance(this.hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException(this.hashAlg + " is not installed");
            }
        }
        this.md.reset();
    }

    protected void _engineUpdate(byte b) throws SignatureException {
        this.md.update(b);
    }

    protected void _engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.md.update(b, off, len);
    }

    private byte[] getT() {
        byte[] H = this.md.digest();
        DigestInfo di = new DigestInfo(this.algId, H);
        return di.getEncoded();
    }

    protected byte[] _engineSign() throws SignatureException {
        byte[] T = this.getT();
        byte[] signature = null;
        try {
            Cipher cip = Cipher.getInstance("RSA/ECB/PKCS1Padding", InitechProvider.NAME);
            cip.init(1, (Key)this.privkey, this.appRandom);
            byte[] byArray = signature = cip.doFinal(T);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException();
        }
        finally {
            if (T != null) {
                Arrays.fill(T, (byte)0);
            }
        }
    }

    protected int _engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] T = this.getT();
        try {
            Cipher cip = Cipher.getInstance("RSA/ECB/PKCS1Padding", InitechProvider.NAME);
            cip.init(1, (Key)this.privkey, this.appRandom);
            int n = cip.doFinal(T, 0, T.length, outbuf, offset);
            return n;
        }
        catch (Exception e) {
            throw new SignatureException();
        }
        finally {
            if (T != null) {
                Arrays.fill(T, (byte)0);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean _engineVerify(byte[] sigBytes) throws SignatureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void _engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected Object _engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("this is deprecated method");
    }
}

