/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.spec;

import com.initech.cryptox.Zeroizable;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.util.Arrays;

public class AriaKeySpec
implements Zeroizable,
KeySpec {
    private byte[] ariaKey;
    public static final int ARIA128_KEY_LEN = 16;
    public static final int ARIA192_KEY_LEN = 24;
    public static final int ARIA256_KEY_LEN = 32;

    public AriaKeySpec(byte[] key) throws InvalidKeyException {
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new InvalidKeyException("Invaild key size.('ARIA ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???')");
        }
        this.ariaKey = new byte[key.length];
        System.arraycopy(key, 0, this.ariaKey, 0, key.length);
    }

    public byte[] getKey() {
        return this.ariaKey;
    }

    public void zeroize() {
        Arrays.fill(this.ariaKey, (byte)0);
    }
}

