/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.spec;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.cryptox.spec.PBEParameterSpec;
import java.security.InvalidParameterException;

public class EnhancedPBEParameterSpec
extends PBEParameterSpec
implements ASN1Type {
    private static final long serialVersionUID = 3426032110027875805L;
    protected byte[] salt;
    protected int iterationCount;

    public EnhancedPBEParameterSpec(byte[] data) throws InvalidParameterException {
        super(null, 0);
        try {
            DERDecoder dec = new DERDecoder(data);
            this.decode(dec);
        }
        catch (ASN1Exception ex) {
            throw new InvalidParameterException("Invalid PBE parameter");
        }
    }

    public EnhancedPBEParameterSpec(byte[] s, int it) {
        super(null, 0);
        this.salt = (byte[])s.clone();
        this.iterationCount = it;
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.salt = dec.decodeOctetString();
        this.iterationCount = dec.decodeIntegerAsInt();
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeOctetString(this.salt);
        enc.encodeInteger(this.iterationCount);
        enc.endOf(id);
    }

    public byte[] getEncoded() {
        byte[] ret = null;
        try {
            DEREncoder enc = new DEREncoder();
            this.encode(enc);
            ret = enc.toByteArray();
        }
        catch (ASN1Exception ex) {
            ret = null;
        }
        return ret;
    }
}

