/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.spec;

import com.initech.asn1.ASN1OID;
import com.initech.provider.crypto.interfaces.ECDSACurve;
import com.initech.provider.crypto.spec.ECDSA_Fp_ParameterSpec;
import com.initech.provider.crypto.spec.ECDSA_Fp_PrivateKeySpec;
import com.initech.provider.crypto.spec.ECDSA_Fp_PublicKeySpec;
import java.math.BigInteger;

public class InitechECDSACurve
implements ECDSACurve {
    protected String[] curveNames = new String[]{"secp160r2", "secp192r1", "secp224r1", "secp256r1", "secp384r1", "secp512r1", "secp192k1", "secp224k1", "secp256k1", "sm2"};
    protected String[] curveOIDs = new String[]{"1.3.132.0.30", "1.2.840.10045.3.1.1", "1.3.132.0.33", "1.2.840.10045.3.1.7", "1.3.132.0.34", "1.3.132.0.35", "1.3.132.0.31", "1.3.132.0.32", "1.3.132.0.10", ""};
    protected String[] primes = new String[]{"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001", "00ffffffff00000001000000000000000000000000ffffffffffffffffffffffff", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D", "00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF"};
    protected String[] as = new String[]{"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE", "00ffffffff00000001000000000000000000000000fffffffffffffffffffffffc", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC"};
    protected String[] bs = new String[]{"B4E134D3FB59EB8BAB57274904664D5AF50388BA", "64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1", "B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "000000000000000000000000000000000000000000000003", "00000000000000000000000000000000000000000000000000000005", "0000000000000000000000000000000000000000000000000000000000000007", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93"};
    protected String[] seeds = new String[]{"B99B99B099B323E02709A4D696E6768756151751", "3045AE6FC8422F64ED579528D38120EAE12196D5", "BD71344799D5C7FCDC45B59FA3B9AB8F6A948BC5", "C49D360886E704936A6678E1139D26B7819F7E90", "A335926AA319A27A1D00896A6773A4827ACDAC73", "D09E8800291CB85396CC6717393284AAA0DA64BA", "00", "00", "00", "00"};
    protected String[] gxs = new String[]{"B4E134D3FB59EB8BAB57274904664D5AF50388BA", "188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF1012", "B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", "DB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7D", "A1455B334DF099DF30FC28A169A467E9E47075A90F7E650EB6B7A45C", "79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7"};
    protected String[] gys = new String[]{"FEAFFEF2E331F296E071FA0DF9982CFEA7D43F2E", "07192B95FFC8DA78631011ED6B24CDD573F977A11E794811", "BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", "9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9D", "7E089FED7FBA344282CAFBD6F7E319F7C0B0BD59E2CA4BDB556D61A5", "483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    protected String[] orders = new String[]{"0100000000000000000000351EE786A818F3A1A16B", "FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831", "FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D", "00ffffffff00000000ffffffffffffffffbce6faada7179e84f3b9cac2fc632551", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", "FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D", "010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7", "00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"};
    protected String[] cofactors = new String[]{"01", "01", "01", "01", "01", "01", "01", "01", "01", "01"};
    private int index = -1;

    public InitechECDSACurve(String curveName) {
        for (int i = 0; i < this.curveNames.length; ++i) {
            if (!curveName.equals(this.curveNames[i]) && !curveName.equals(this.curveOIDs[i])) continue;
            this.index = i;
            break;
        }
    }

    public InitechECDSACurve(byte[] oid) {
        for (int i = 0; i < this.curveNames.length; ++i) {
            ASN1OID coid = new ASN1OID(this.curveOIDs[i]);
            byte[] id = coid.encode();
            if (!this.compareArr(oid, 2, id)) continue;
            this.index = i;
            break;
        }
    }

    private boolean compareArr(byte[] src, int pos, byte[] a) {
        if (src == null || a == null) {
            return false;
        }
        try {
            for (int i = 0; i < a.length; ++i) {
                if (src[pos + i] == a[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getName() {
        if (this.index >= 0) {
            return this.curveNames[this.index];
        }
        return null;
    }

    public String getOID() {
        if (this.index >= 0) {
            return this.curveOIDs[this.index];
        }
        return null;
    }

    public BigInteger getPrime() {
        return new BigInteger(this.primes[this.index], 16);
    }

    public BigInteger getA() {
        return new BigInteger(this.as[this.index], 16);
    }

    public BigInteger getB() {
        return new BigInteger(this.bs[this.index], 16);
    }

    public BigInteger getGx() {
        return new BigInteger(this.gxs[this.index], 16);
    }

    public BigInteger getGy() {
        return new BigInteger(this.gys[this.index], 16);
    }

    public BigInteger getSeed() {
        return new BigInteger(this.seeds[this.index], 16);
    }

    public BigInteger getOrder() {
        return new BigInteger(this.orders[this.index], 16);
    }

    public BigInteger getCofactor() {
        return new BigInteger(this.cofactors[this.index], 16);
    }

    public ECDSA_Fp_ParameterSpec make_Fp_ParameterSpec() {
        if (this.index >= 0) {
            return new ECDSA_Fp_ParameterSpec(this.getPrime(), 1, this.getA(), this.getB(), this.getSeed(), this.getGx(), this.getGy(), this.getOrder(), this.getCofactor());
        }
        return null;
    }

    public ECDSA_Fp_PublicKeySpec make_Fp_PublicKeySpec(BigInteger x, BigInteger y) {
        if (this.index >= 0) {
            return new ECDSA_Fp_PublicKeySpec(x, y, this.getPrime(), 1, this.getA(), this.getB(), this.getSeed(), this.getGx(), this.getGy(), this.getOrder(), this.getCofactor());
        }
        return null;
    }

    public ECDSA_Fp_PrivateKeySpec make_Fp_PrivateKeySpec(BigInteger d) {
        if (this.index >= 0) {
            return new ECDSA_Fp_PrivateKeySpec(d, this.getPrime(), 1, this.getA(), this.getB(), this.getSeed(), this.getGx(), this.getGy(), this.getOrder(), this.getCofactor());
        }
        return null;
    }
}

