/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class KCDSAGenParameterSpec
implements AlgorithmParameterSpec {
    private int pSize = 2048;
    private int qSize = 256;
    private String hashAlg = "SHA256";

    public KCDSAGenParameterSpec(int ps, int qs) {
        if (ps < 1024 || ps > 2048 || qs < 160 || qs > 256) {
            throw new IllegalArgumentException("Illegal length of P or Q");
        }
        this.pSize = ps;
        this.qSize = qs;
        if ((ps - 1024) % 256 != 0) {
            throw new IllegalArgumentException("Illegal length of P size");
        }
        if ((qs - 160) % 32 != 0) {
            throw new IllegalArgumentException("Illegal length of Q size");
        }
    }

    public KCDSAGenParameterSpec(int ps, int qs, String hashAlg) {
        if (ps < 1024 || ps > 2048 || qs < 160 || qs > 256) {
            throw new IllegalArgumentException("Illegal length of P or Q");
        }
        this.pSize = ps;
        this.qSize = qs;
        if ((ps - 1024) % 256 != 0) {
            throw new IllegalArgumentException("Illegal length of P size");
        }
        if ((qs - 160) % 32 != 0) {
            throw new IllegalArgumentException("Illegal length of Q size");
        }
        this.hashAlg = hashAlg;
    }

    public int getPsize() {
        return this.pSize;
    }

    public int getQsize() {
        return this.qSize;
    }

    public String getHashAlg() {
        return this.hashAlg;
    }
}

