/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.spec;

import com.initech.provider.crypto.interfaces.KCDSAParams;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class KCDSAParameterSpec
implements AlgorithmParameterSpec,
KCDSAParams,
Serializable {
    private static final long serialVersionUID = 5222641756853288536L;
    BigInteger P;
    BigInteger Q;
    BigInteger G;
    BigInteger J;
    byte[] seed;
    int count;
    String hashName = null;

    public KCDSAParameterSpec(BigInteger p, BigInteger q, BigInteger g) {
        this.P = p;
        this.Q = q;
        this.G = g;
    }

    public KCDSAParameterSpec(BigInteger p, BigInteger q, BigInteger g, BigInteger j, byte[] seed, int count) {
        this.P = p;
        this.Q = q;
        this.G = g;
        this.J = j;
        this.seed = seed;
        this.count = count;
        this.hashName = "SHA256";
    }

    public KCDSAParameterSpec(BigInteger p, BigInteger q, BigInteger g, BigInteger j, byte[] seed, int count, String hashName) {
        this.P = p;
        this.Q = q;
        this.G = g;
        this.J = j;
        this.seed = seed;
        this.count = count;
        this.hashName = hashName != null ? hashName : "SHA256";
    }

    public BigInteger getP() {
        return this.P;
    }

    public BigInteger getQ() {
        return this.Q;
    }

    public BigInteger getG() {
        return this.G;
    }

    public BigInteger getJ() {
        return this.J;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public int getCount() {
        return this.count;
    }

    public String getHashName() {
        return this.hashName;
    }
}

