/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.spec;

import com.initech.cryptox.Zeroizable;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.util.Arrays;

public class SeedKeySpec
implements Zeroizable,
KeySpec {
    private byte[] seedKey;
    public static final int SEED_KEY_LEN = 16;

    public SeedKeySpec(byte[] key) throws InvalidKeyException {
        if (key.length < 16) {
            throw new InvalidKeyException("Not enough key material");
        }
        this.seedKey = new byte[16];
        System.arraycopy(key, 0, this.seedKey, 0, 16);
    }

    public byte[] getKey() {
        return this.seedKey;
    }

    public void zeroize() {
        Arrays.fill(this.seedKey, (byte)0);
    }
}

