/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.pkcs.pkcs5;

import com.initech.provider.pkcs.pkcs5.PBEKey;
import java.security.InvalidParameterException;

public abstract class PBKDF {
    protected byte[] password;
    protected byte[] salt;
    protected int iterationCount;
    protected int dkLen;

    public abstract byte[] process();

    protected void setSalt(byte[] salt) {
        this.salt = salt;
    }

    protected void setIterationCount(int iterationCount) throws InvalidParameterException {
        this.iterationCount = iterationCount;
        if (iterationCount <= 0) {
            throw new InvalidParameterException("Iteration count must be positive");
        }
    }

    protected void setDerivedKeyLength(int dkLen) throws InvalidParameterException {
        this.dkLen = dkLen;
        if (dkLen < 0) {
            throw new InvalidParameterException("Derived Key length must be positive");
        }
    }

    protected void setPassword(PBEKey pbeKey) {
        this.password = pbeKey.getEncoded();
    }

    public void zeroize() {
        this.password = null;
        this.salt = null;
    }
}

