/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.pkcs.pkcs5;

import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBKDF;
import java.security.InvalidParameterException;
import java.security.MessageDigest;

public class PBKDF1
extends PBKDF {
    protected MessageDigest messageDigest = null;

    public PBKDF1(PBEKey pbeKey, javax.crypto.spec.PBEParameterSpec pbeParameter_j, MessageDigest messageDigest, int derivedKeyLength) throws InvalidParameterException {
        this(pbeKey, (PBEParameterSpec)AutoJCE.toJCEX(pbeParameter_j), messageDigest, derivedKeyLength);
    }

    public PBKDF1(PBEKey pbeKey, PBEParameterSpec pbeParameter, MessageDigest messageDigest, int derivedKeyLength) throws InvalidParameterException {
        this.setSalt(pbeParameter.getSalt());
        this.setIterationCount(pbeParameter.getIterationCount());
        this.setDerivedKeyLength(derivedKeyLength);
        this.setMD(messageDigest);
        this.setPassword(pbeKey);
    }

    public PBKDF1(PBEKey pbeKey, javax.crypto.spec.PBEParameterSpec pbeParameter_j, MessageDigest messageDigest) throws InvalidParameterException {
        this(pbeKey, (PBEParameterSpec)AutoJCE.toJCEX(pbeParameter_j), messageDigest);
    }

    public PBKDF1(PBEKey pbeKey, PBEParameterSpec pbeParameter, MessageDigest messageDigest) throws InvalidParameterException {
        this.setSalt(pbeParameter.getSalt());
        this.setIterationCount(pbeParameter.getIterationCount());
        this.setDerivedKeyLength(0);
        this.setMD(messageDigest);
        this.setPassword(pbeKey);
    }

    protected void setMD(MessageDigest md) throws InvalidParameterException {
        this.messageDigest = md;
        if (this.dkLen == 0) {
            this.dkLen = md.getDigestLength();
        } else if (this.dkLen > md.getDigestLength()) {
            throw new InvalidParameterException("Derived Key length must be shorter than message digest algorithm output");
        }
    }

    public byte[] process() {
        int i;
        this.messageDigest.update(this.password);
        this.messageDigest.update(this.salt);
        byte[] digested = this.messageDigest.digest();
        for (int i2 = 1; i2 < this.iterationCount; ++i2) {
            digested = this.messageDigest.digest(digested);
        }
        byte[] result = new byte[this.dkLen];
        System.arraycopy(digested, 0, result, 0, this.dkLen);
        for (i = 0; i < digested.length; ++i) {
            digested[i] = 0;
        }
        for (i = 0; i < this.password.length; ++i) {
            this.password[i] = 0;
        }
        return result;
    }
}

