/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.pkcs.pkcs5;

import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.mac.HMACKey;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBKDF;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.Mac;

public class PBKDF2
extends PBKDF {
    protected Mac mac = null;

    public PBKDF2(PBEKey pbeKey, javax.crypto.spec.PBEParameterSpec pbeParameter_j, Mac mac, int derivedKeyLength) {
        this(pbeKey, (PBEParameterSpec)AutoJCE.toJCEX(pbeParameter_j), mac, derivedKeyLength);
    }

    public PBKDF2(PBEKey pbeKey, PBEParameterSpec pbeParameter, Mac mac, int derivedKeyLength) {
        this.setSalt(pbeParameter.getSalt());
        this.setIterationCount(pbeParameter.getIterationCount());
        this.setDerivedKeyLength(derivedKeyLength);
        this.setMac(mac);
        this.setPassword(pbeKey);
    }

    public PBKDF2(PBEKey pbeKey, javax.crypto.spec.PBEParameterSpec pbeParameter_j, int derivedKeyLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(pbeKey, (PBEParameterSpec)AutoJCE.toJCEX(pbeParameter_j), derivedKeyLength);
    }

    public PBKDF2(PBEKey pbeKey, PBEParameterSpec pbeParameter, int derivedKeyLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.setSalt(pbeParameter.getSalt());
        this.setIterationCount(pbeParameter.getIterationCount());
        this.setDerivedKeyLength(derivedKeyLength);
        this.setMac(Mac.getInstance("HMACwithSHA1", InitechProvider.NAME));
        this.setPassword(pbeKey);
    }

    public void setMac(Mac mac) {
        this.mac = mac;
    }

    public byte[] process() {
        int hLen = this.mac.getMacLength();
        int lBlocks = (int)Math.ceil((float)this.dkLen / (float)hLen);
        int rBlocks = this.dkLen - (lBlocks - 1) * hLen;
        int outland = 0;
        byte[] derivedKey = new byte[this.dkLen];
        byte[] F = new byte[hLen];
        HMACKey passwordKey = new HMACKey(this.password);
        for (int i = 1; i <= lBlocks; ++i) {
            try {
                this.mac.init(passwordKey);
            }
            catch (InvalidKeyException e) {
                // empty catch block
            }
            this.mac.update(this.salt);
            byte[] lArray = new byte[]{(byte)((i & 0xFF000000) >> 24), (byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF00) >> 8), (byte)(i & 0xFF)};
            byte[] U = this.mac.doFinal(lArray);
            System.arraycopy(U, 0, F, 0, hLen);
            for (int c = 1; c < this.iterationCount; ++c) {
                try {
                    this.mac.init(passwordKey);
                }
                catch (InvalidKeyException e) {
                    // empty catch block
                }
                U = this.mac.doFinal(U);
                for (int k = 0; k < hLen; ++k) {
                    F[k] = (byte)(F[k] ^ U[k]);
                }
            }
            if (i != lBlocks) {
                System.arraycopy(F, 0, derivedKey, outland, hLen);
                outland += hLen;
            } else {
                System.arraycopy(F, 0, derivedKey, outland, rBlocks);
                outland += rBlocks;
            }
            Arrays.fill(U, (byte)0);
            Arrays.fill(lArray, (byte)0);
        }
        passwordKey.zeroize();
        Arrays.fill(this.password, (byte)0);
        Arrays.fill(F, (byte)0);
        return derivedKey;
    }
}

