/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.pkcs.pkcs5;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;

public class PBMAC1Data
extends ASN1Object {
    private static final long serialVersionUID = -71295646531346199L;
    protected AlgorithmID keyDerivationFunc = new AlgorithmID();
    protected AlgorithmID messageAuthScheme = new AlgorithmID();
    protected byte[] salt;
    protected int iterationCount;
    protected int keyLength = -1;
    protected AlgorithmID prfAlgorithm = new AlgorithmID();
    public static final int UNDEFINED = -1;

    public PBMAC1Data(byte[] rawParameters) throws ASN1Exception {
        BERDecoder dec = new BERDecoder(rawParameters);
        this.decode(dec);
        this.modified = false;
    }

    public PBMAC1Data(byte[] salt, int iterationCount, AlgorithmID messageAuthScheme, int keyLength) throws ASN1Exception {
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.messageAuthScheme = messageAuthScheme;
        this.keyLength = keyLength;
        DEREncoder enc = new DEREncoder();
        this.encode(enc);
        this.modified = true;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seqid = dec.decodeSequence();
        this.keyDerivationFunc.decode(dec);
        this.messageAuthScheme.decode(dec);
        dec.endOf(seqid);
        this.keyDerivationFunc.getAlgName().equals("1.2.840.113549.1.5.12");
        BERDecoder kdfDec = new BERDecoder(this.keyDerivationFunc.getParameter());
        int kseqid = kdfDec.decodeSequence();
        int[] saltChoice = new int[]{4, 16};
        int saltTag = kdfDec.decodeChoice(saltChoice);
        if (saltTag != 4) {
            if (saltTag == 16) {
                AlgorithmID saltSource = new AlgorithmID();
                saltSource.decode(kdfDec);
                throw new ASN1Exception("No salt sources implemented(PBMAC1)");
            }
            throw new ASN1Exception("Failed to decode PBKDF2-params.salt");
        }
        this.salt = kdfDec.decodeOctetString();
        this.iterationCount = kdfDec.decodeIntegerAsInt();
        if (!kdfDec.nextIsOptional(2)) {
            this.keyLength = kdfDec.decodeIntegerAsInt();
        }
        if (kdfDec.nextIsDefault(16)) {
            this.prfAlgorithm = AlgorithmID.HMACWithSHA1;
        } else {
            this.prfAlgorithm.decode(kdfDec);
        }
        kdfDec.endOf(kseqid);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        DEREncoder kdfParam = new DEREncoder();
        int kdfid = kdfParam.encodeSequence();
        kdfParam.encodeOctetString(this.salt);
        kdfParam.encodeInteger(this.iterationCount);
        if (this.keyLength != -1) {
            kdfParam.encodeInteger(this.keyLength);
        }
        AlgorithmID.HMACWithSHA1.encode(kdfParam);
        kdfParam.endOf(kdfid);
        this.keyDerivationFunc.setAlgorithm("PBKDF2");
        this.keyDerivationFunc.setParameter(kdfParam.toByteArray());
        int seqid = enc.encodeSequence();
        this.keyDerivationFunc.encode(enc);
        this.messageAuthScheme.encode(enc);
        enc.endOf(seqid);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public AlgorithmID getPRFAlgorithm() {
        return this.prfAlgorithm;
    }

    public AlgorithmID getmessageAuthScheme() {
        return this.messageAuthScheme;
    }
}

